/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model.transform;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.moladb.model.AttributeValue;
import com.baidubce.services.moladb.model.BatchGetItemResponse;
import com.baidubce.services.moladb.model.KeysAndAttributes;
import com.baidubce.services.moladb.model.transform.BatchGetItemResponseContentUnmarshaller;
import com.baidubce.services.moladb.model.transform.BatchGetUnprocessItemsUnmarshaller;
import com.baidubce.services.moladb.model.transform.Unmarshaller;
import com.baidubce.services.moladb.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class BatchGetItemResponseUnmarshaller
implements Unmarshaller<BatchGetItemResponse, InputStream> {
    BatchGetItemResponse result = null;

    public BatchGetItemResponseUnmarshaller(AbstractBceResponse response) {
        this.result = (BatchGetItemResponse)response;
    }

    @Override
    public BatchGetItemResponse unmarshall(InputStream stream) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(stream);
        if (streamContents == null || streamContents.isEmpty()) {
            return null;
        }
        BatchGetItemResponseContentUnmarshaller responseUnmarshaller = new BatchGetItemResponseContentUnmarshaller();
        BatchGetUnprocessItemsUnmarshaller unprocessUnmarshaller = new BatchGetUnprocessItemsUnmarshaller();
        JsonNode jsonObj = JsonUtils.jsonNodeOf(streamContents);
        JsonNode respObj = jsonObj.get("responses");
        JsonNode unprocessObj = jsonObj.get("unprocessedItems");
        Map<String, KeysAndAttributes> unprocess = null;
        if (unprocessObj != null) {
            unprocess = unprocessUnmarshaller.unmarshall(unprocessObj);
        }
        Map<String, List<Map<String, AttributeValue>>> resp = null;
        if (respObj != null) {
            resp = responseUnmarshaller.unmarshall(respObj);
        }
        this.result.setResponses(resp);
        this.result.setUnprocessedItems(unprocess);
        return this.result;
    }
}

