/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.services.moladb.model.KeySchemaElement;
import com.baidubce.services.moladb.model.transform.Unmarshaller;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KeySchemaUnmarshaller
implements Unmarshaller<List<KeySchemaElement>, JsonNode> {
    @Override
    public List<KeySchemaElement> unmarshall(JsonNode jsonObj) throws Exception {
        if (!jsonObj.isArray()) {
            throw new BceClientException("input json object is not an array");
        }
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        Iterator keyList = jsonObj.elements();
        while (keyList.hasNext()) {
            JsonNode keyObj = (JsonNode)keyList.next();
            String name = keyObj.get("attributeName").asText();
            String type = keyObj.get("keyType").asText();
            KeySchemaElement element = new KeySchemaElement();
            element.setAttributeName(name);
            element.setKeyType(type);
            keySchema.add(element);
        }
        return keySchema;
    }
}

