/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.aop;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.dynamic.datasource.tx.TransactionalExecutor;
import com.baomidou.dynamic.datasource.tx.TransactionalInfo;
import com.baomidou.dynamic.datasource.tx.TransactionalTemplate;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicLocalTransactionInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DynamicLocalTransactionInterceptor.class);
    private final TransactionalTemplate transactionalTemplate = new TransactionalTemplate();

    public Object invoke(final MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        final DSTransactional dsTransactional = method.getAnnotation(DSTransactional.class);
        TransactionalExecutor transactionalExecutor = new TransactionalExecutor(){

            @Override
            public Object execute() throws Throwable {
                return methodInvocation.proceed();
            }

            @Override
            public TransactionalInfo getTransactionInfo() {
                TransactionalInfo transactionInfo = new TransactionalInfo();
                transactionInfo.setPropagation(dsTransactional.propagation());
                transactionInfo.setNoRollbackFor(dsTransactional.noRollbackFor());
                transactionInfo.setRollbackFor(dsTransactional.rollbackFor());
                return transactionInfo;
            }
        };
        return this.transactionalTemplate.execute(transactionalExecutor);
    }
}

