/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator.jndi;

import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DataSourceProperty;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;

public class JndiDataSourceCreator
implements DataSourceCreator {
    private static final JndiDataSourceLookup LOOKUP = new JndiDataSourceLookup();

    public DataSource createDataSource(String jndiName) {
        return LOOKUP.getDataSource(jndiName);
    }

    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        return this.createDataSource(dataSourceProperty.getJndiName());
    }

    public boolean support(DataSourceProperty dataSourceProperty) {
        String jndiName = dataSourceProperty.getJndiName();
        return jndiName != null && !jndiName.isEmpty();
    }
}

