/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso;

import com.baomidou.kisso.SSOAuthorization;
import com.baomidou.kisso.SSOCache;
import com.baomidou.kisso.SSOPlugin;
import com.baomidou.kisso.exception.KissoException;
import com.baomidou.kisso.security.token.SSOToken;
import java.util.List;

public class SSOConfig {
    private String encoding = "UTF-8";
    private String signkey = "3QD2j1B1s6Uj1jx6q8";
    private String signAlgorithm = "HS512";
    private String rsaCertstore;
    private String rsaKeystore;
    private String rsaAlias = "jwtkey";
    private String rsaKeypass = "keypassword";
    private String rsaStorepass = "letkisso";
    private String accessTokenName = "accessToken";
    private String cookieName = "uid";
    private String cookieDomain;
    private String cookiePath = "/";
    private boolean cookieSecure = false;
    private boolean cookieHttponly = true;
    private int cookieMaxage = -1;
    private boolean cookieBrowser = false;
    private boolean cookieCheckip = false;
    private String loginUrl = "";
    private String logoutUrl = "";
    private String paramReturl = "ReturnURL";
    private int cacheExpires = -1;
    private SSOToken ssoToken;
    private boolean permissionUri = false;
    private List<SSOPlugin> pluginList;
    private SSOCache cache;
    private static SSOConfig SSO_CONFIG = null;
    private static SSOAuthorization SSO_AUTHORIZATION;

    public static SSOConfig getInstance() {
        if (SSO_CONFIG == null) {
            SSO_CONFIG = new SSOConfig();
        }
        return SSO_CONFIG;
    }

    public static SSOConfig init(SSOConfig ssoConfig) {
        SSO_CONFIG = ssoConfig;
        return ssoConfig;
    }

    public static String getSSOEncoding() {
        return SSOConfig.getInstance().getEncoding();
    }

    public String getRsaCertstore() {
        if (null == this.rsaCertstore) {
            throw new KissoException("public.cert not found");
        }
        return this.rsaCertstore;
    }

    public String getRsaKeystore() {
        if (null == this.rsaKeystore) {
            throw new KissoException("jwt.jks not found");
        }
        return this.rsaKeystore;
    }

    public SSOAuthorization getAuthorization() {
        return SSO_AUTHORIZATION;
    }

    public SSOConfig setAuthorization(SSOAuthorization ssoAuthorization) {
        SSO_AUTHORIZATION = ssoAuthorization;
        return this;
    }

    public static String toCacheKey(Object userId) {
        StringBuffer ck = new StringBuffer();
        ck.append("ssoTokenKey_");
        ck.append(userId);
        return ck.toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getSignkey() {
        return this.signkey;
    }

    public String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public String getRsaAlias() {
        return this.rsaAlias;
    }

    public String getRsaKeypass() {
        return this.rsaKeypass;
    }

    public String getRsaStorepass() {
        return this.rsaStorepass;
    }

    public String getAccessTokenName() {
        return this.accessTokenName;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public boolean isCookieSecure() {
        return this.cookieSecure;
    }

    public boolean isCookieHttponly() {
        return this.cookieHttponly;
    }

    public int getCookieMaxage() {
        return this.cookieMaxage;
    }

    public boolean isCookieBrowser() {
        return this.cookieBrowser;
    }

    public boolean isCookieCheckip() {
        return this.cookieCheckip;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public String getParamReturl() {
        return this.paramReturl;
    }

    public int getCacheExpires() {
        return this.cacheExpires;
    }

    public SSOToken getSsoToken() {
        return this.ssoToken;
    }

    public boolean isPermissionUri() {
        return this.permissionUri;
    }

    public List<SSOPlugin> getPluginList() {
        return this.pluginList;
    }

    public SSOCache getCache() {
        return this.cache;
    }

    public SSOConfig setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public SSOConfig setSignkey(String signkey) {
        this.signkey = signkey;
        return this;
    }

    public SSOConfig setSignAlgorithm(String signAlgorithm) {
        this.signAlgorithm = signAlgorithm;
        return this;
    }

    public SSOConfig setRsaCertstore(String rsaCertstore) {
        this.rsaCertstore = rsaCertstore;
        return this;
    }

    public SSOConfig setRsaKeystore(String rsaKeystore) {
        this.rsaKeystore = rsaKeystore;
        return this;
    }

    public SSOConfig setRsaAlias(String rsaAlias) {
        this.rsaAlias = rsaAlias;
        return this;
    }

    public SSOConfig setRsaKeypass(String rsaKeypass) {
        this.rsaKeypass = rsaKeypass;
        return this;
    }

    public SSOConfig setRsaStorepass(String rsaStorepass) {
        this.rsaStorepass = rsaStorepass;
        return this;
    }

    public SSOConfig setAccessTokenName(String accessTokenName) {
        this.accessTokenName = accessTokenName;
        return this;
    }

    public SSOConfig setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }

    public SSOConfig setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
        return this;
    }

    public SSOConfig setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
        return this;
    }

    public SSOConfig setCookieSecure(boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
        return this;
    }

    public SSOConfig setCookieHttponly(boolean cookieHttponly) {
        this.cookieHttponly = cookieHttponly;
        return this;
    }

    public SSOConfig setCookieMaxage(int cookieMaxage) {
        this.cookieMaxage = cookieMaxage;
        return this;
    }

    public SSOConfig setCookieBrowser(boolean cookieBrowser) {
        this.cookieBrowser = cookieBrowser;
        return this;
    }

    public SSOConfig setCookieCheckip(boolean cookieCheckip) {
        this.cookieCheckip = cookieCheckip;
        return this;
    }

    public SSOConfig setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
        return this;
    }

    public SSOConfig setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
        return this;
    }

    public SSOConfig setParamReturl(String paramReturl) {
        this.paramReturl = paramReturl;
        return this;
    }

    public SSOConfig setCacheExpires(int cacheExpires) {
        this.cacheExpires = cacheExpires;
        return this;
    }

    public SSOConfig setSsoToken(SSOToken ssoToken) {
        this.ssoToken = ssoToken;
        return this;
    }

    public SSOConfig setPermissionUri(boolean permissionUri) {
        this.permissionUri = permissionUri;
        return this;
    }

    public SSOConfig setPluginList(List<SSOPlugin> pluginList) {
        this.pluginList = pluginList;
        return this;
    }

    public SSOConfig setCache(SSOCache cache) {
        this.cache = cache;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SSOConfig)) {
            return false;
        }
        SSOConfig other = (SSOConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$encoding = this.getEncoding();
        String other$encoding = other.getEncoding();
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        String this$signkey = this.getSignkey();
        String other$signkey = other.getSignkey();
        if (this$signkey == null ? other$signkey != null : !this$signkey.equals(other$signkey)) {
            return false;
        }
        String this$signAlgorithm = this.getSignAlgorithm();
        String other$signAlgorithm = other.getSignAlgorithm();
        if (this$signAlgorithm == null ? other$signAlgorithm != null : !this$signAlgorithm.equals(other$signAlgorithm)) {
            return false;
        }
        String this$rsaCertstore = this.getRsaCertstore();
        String other$rsaCertstore = other.getRsaCertstore();
        if (this$rsaCertstore == null ? other$rsaCertstore != null : !this$rsaCertstore.equals(other$rsaCertstore)) {
            return false;
        }
        String this$rsaKeystore = this.getRsaKeystore();
        String other$rsaKeystore = other.getRsaKeystore();
        if (this$rsaKeystore == null ? other$rsaKeystore != null : !this$rsaKeystore.equals(other$rsaKeystore)) {
            return false;
        }
        String this$rsaAlias = this.getRsaAlias();
        String other$rsaAlias = other.getRsaAlias();
        if (this$rsaAlias == null ? other$rsaAlias != null : !this$rsaAlias.equals(other$rsaAlias)) {
            return false;
        }
        String this$rsaKeypass = this.getRsaKeypass();
        String other$rsaKeypass = other.getRsaKeypass();
        if (this$rsaKeypass == null ? other$rsaKeypass != null : !this$rsaKeypass.equals(other$rsaKeypass)) {
            return false;
        }
        String this$rsaStorepass = this.getRsaStorepass();
        String other$rsaStorepass = other.getRsaStorepass();
        if (this$rsaStorepass == null ? other$rsaStorepass != null : !this$rsaStorepass.equals(other$rsaStorepass)) {
            return false;
        }
        String this$accessTokenName = this.getAccessTokenName();
        String other$accessTokenName = other.getAccessTokenName();
        if (this$accessTokenName == null ? other$accessTokenName != null : !this$accessTokenName.equals(other$accessTokenName)) {
            return false;
        }
        String this$cookieName = this.getCookieName();
        String other$cookieName = other.getCookieName();
        if (this$cookieName == null ? other$cookieName != null : !this$cookieName.equals(other$cookieName)) {
            return false;
        }
        String this$cookieDomain = this.getCookieDomain();
        String other$cookieDomain = other.getCookieDomain();
        if (this$cookieDomain == null ? other$cookieDomain != null : !this$cookieDomain.equals(other$cookieDomain)) {
            return false;
        }
        String this$cookiePath = this.getCookiePath();
        String other$cookiePath = other.getCookiePath();
        if (this$cookiePath == null ? other$cookiePath != null : !this$cookiePath.equals(other$cookiePath)) {
            return false;
        }
        if (this.isCookieSecure() != other.isCookieSecure()) {
            return false;
        }
        if (this.isCookieHttponly() != other.isCookieHttponly()) {
            return false;
        }
        if (this.getCookieMaxage() != other.getCookieMaxage()) {
            return false;
        }
        if (this.isCookieBrowser() != other.isCookieBrowser()) {
            return false;
        }
        if (this.isCookieCheckip() != other.isCookieCheckip()) {
            return false;
        }
        String this$loginUrl = this.getLoginUrl();
        String other$loginUrl = other.getLoginUrl();
        if (this$loginUrl == null ? other$loginUrl != null : !this$loginUrl.equals(other$loginUrl)) {
            return false;
        }
        String this$logoutUrl = this.getLogoutUrl();
        String other$logoutUrl = other.getLogoutUrl();
        if (this$logoutUrl == null ? other$logoutUrl != null : !this$logoutUrl.equals(other$logoutUrl)) {
            return false;
        }
        String this$paramReturl = this.getParamReturl();
        String other$paramReturl = other.getParamReturl();
        if (this$paramReturl == null ? other$paramReturl != null : !this$paramReturl.equals(other$paramReturl)) {
            return false;
        }
        if (this.getCacheExpires() != other.getCacheExpires()) {
            return false;
        }
        SSOToken this$ssoToken = this.getSsoToken();
        SSOToken other$ssoToken = other.getSsoToken();
        if (this$ssoToken == null ? other$ssoToken != null : !this$ssoToken.equals(other$ssoToken)) {
            return false;
        }
        if (this.isPermissionUri() != other.isPermissionUri()) {
            return false;
        }
        List<SSOPlugin> this$pluginList = this.getPluginList();
        List<SSOPlugin> other$pluginList = other.getPluginList();
        if (this$pluginList == null ? other$pluginList != null : !((Object)this$pluginList).equals(other$pluginList)) {
            return false;
        }
        SSOCache this$cache = this.getCache();
        SSOCache other$cache = other.getCache();
        return !(this$cache == null ? other$cache != null : !this$cache.equals(other$cache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SSOConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        String $signkey = this.getSignkey();
        result = result * 59 + ($signkey == null ? 43 : $signkey.hashCode());
        String $signAlgorithm = this.getSignAlgorithm();
        result = result * 59 + ($signAlgorithm == null ? 43 : $signAlgorithm.hashCode());
        String $rsaCertstore = this.getRsaCertstore();
        result = result * 59 + ($rsaCertstore == null ? 43 : $rsaCertstore.hashCode());
        String $rsaKeystore = this.getRsaKeystore();
        result = result * 59 + ($rsaKeystore == null ? 43 : $rsaKeystore.hashCode());
        String $rsaAlias = this.getRsaAlias();
        result = result * 59 + ($rsaAlias == null ? 43 : $rsaAlias.hashCode());
        String $rsaKeypass = this.getRsaKeypass();
        result = result * 59 + ($rsaKeypass == null ? 43 : $rsaKeypass.hashCode());
        String $rsaStorepass = this.getRsaStorepass();
        result = result * 59 + ($rsaStorepass == null ? 43 : $rsaStorepass.hashCode());
        String $accessTokenName = this.getAccessTokenName();
        result = result * 59 + ($accessTokenName == null ? 43 : $accessTokenName.hashCode());
        String $cookieName = this.getCookieName();
        result = result * 59 + ($cookieName == null ? 43 : $cookieName.hashCode());
        String $cookieDomain = this.getCookieDomain();
        result = result * 59 + ($cookieDomain == null ? 43 : $cookieDomain.hashCode());
        String $cookiePath = this.getCookiePath();
        result = result * 59 + ($cookiePath == null ? 43 : $cookiePath.hashCode());
        result = result * 59 + (this.isCookieSecure() ? 79 : 97);
        result = result * 59 + (this.isCookieHttponly() ? 79 : 97);
        result = result * 59 + this.getCookieMaxage();
        result = result * 59 + (this.isCookieBrowser() ? 79 : 97);
        result = result * 59 + (this.isCookieCheckip() ? 79 : 97);
        String $loginUrl = this.getLoginUrl();
        result = result * 59 + ($loginUrl == null ? 43 : $loginUrl.hashCode());
        String $logoutUrl = this.getLogoutUrl();
        result = result * 59 + ($logoutUrl == null ? 43 : $logoutUrl.hashCode());
        String $paramReturl = this.getParamReturl();
        result = result * 59 + ($paramReturl == null ? 43 : $paramReturl.hashCode());
        result = result * 59 + this.getCacheExpires();
        SSOToken $ssoToken = this.getSsoToken();
        result = result * 59 + ($ssoToken == null ? 43 : $ssoToken.hashCode());
        result = result * 59 + (this.isPermissionUri() ? 79 : 97);
        List<SSOPlugin> $pluginList = this.getPluginList();
        result = result * 59 + ($pluginList == null ? 43 : ((Object)$pluginList).hashCode());
        SSOCache $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        return result;
    }

    public String toString() {
        return "SSOConfig(encoding=" + this.getEncoding() + ", signkey=" + this.getSignkey() + ", signAlgorithm=" + this.getSignAlgorithm() + ", rsaCertstore=" + this.getRsaCertstore() + ", rsaKeystore=" + this.getRsaKeystore() + ", rsaAlias=" + this.getRsaAlias() + ", rsaKeypass=" + this.getRsaKeypass() + ", rsaStorepass=" + this.getRsaStorepass() + ", accessTokenName=" + this.getAccessTokenName() + ", cookieName=" + this.getCookieName() + ", cookieDomain=" + this.getCookieDomain() + ", cookiePath=" + this.getCookiePath() + ", cookieSecure=" + this.isCookieSecure() + ", cookieHttponly=" + this.isCookieHttponly() + ", cookieMaxage=" + this.getCookieMaxage() + ", cookieBrowser=" + this.isCookieBrowser() + ", cookieCheckip=" + this.isCookieCheckip() + ", loginUrl=" + this.getLoginUrl() + ", logoutUrl=" + this.getLogoutUrl() + ", paramReturl=" + this.getParamReturl() + ", cacheExpires=" + this.getCacheExpires() + ", ssoToken=" + this.getSsoToken() + ", permissionUri=" + this.isPermissionUri() + ", pluginList=" + this.getPluginList() + ", cache=" + this.getCache() + ")";
    }
}

