/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.common.util.RandomUtil;
import com.baomidou.kisso.security.token.SSOToken;
import com.baomidou.kisso.service.ConfigurableAbstractKissoService;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SSOHelper {
    protected static ConfigurableAbstractKissoService kissoService;

    public static ConfigurableAbstractKissoService getKissoService() {
        if (kissoService == null) {
            kissoService = new ConfigurableAbstractKissoService();
        }
        return kissoService;
    }

    public static String getSecretKey() {
        return RandomUtil.getCharacterAndNumber(18);
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, SSOToken ssoToken, boolean invalidate) {
        if (invalidate) {
            SSOHelper.getKissoService().authCookie(request, response, ssoToken);
        } else {
            SSOHelper.getKissoService().setCookie(request, response, ssoToken);
        }
    }

    public static <T extends SSOToken> T getSSOToken(HttpServletRequest request) {
        return (T)SSOHelper.getKissoService().getSSOToken(request);
    }

    public static <T extends SSOToken> T attrToken(HttpServletRequest request) {
        return SSOHelper.getKissoService().attrSSOToken(request);
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SSOHelper.getKissoService().logout(request, response);
    }

    public static boolean clearLogin(HttpServletRequest request, HttpServletResponse response) {
        return SSOHelper.getKissoService().clearLogin(request, response);
    }

    public static void clearRedirectLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SSOHelper.getKissoService().clearRedirectLogin(request, response);
    }

    public static String getTokenCacheKey(HttpServletRequest request) {
        return ((SSOToken)SSOHelper.getSSOToken(request)).toCacheKey();
    }

    public static String getTokenCacheKey(Object userId) {
        return SSOConfig.toCacheKey(userId);
    }

    public static boolean kickLogin(Object userId) {
        return SSOHelper.getKissoService().kickLogin(userId);
    }
}

