/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.captcha;

import com.baomidou.kisso.captcha.CaptchaStoreSession;
import com.baomidou.kisso.captcha.ColorType;
import com.baomidou.kisso.captcha.ICaptcha;
import com.baomidou.kisso.captcha.ICaptchaStore;
import com.baomidou.kisso.common.util.RandomType;
import com.baomidou.kisso.common.util.RandomUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractCaptcha
implements ICaptcha {
    protected boolean gif;
    protected Font font;
    protected int[][] rgbArr;
    protected int interfere = 5;
    protected Color interfereColor;
    protected Color color;
    protected int length;
    protected int width;
    protected int height;
    protected String suffix;
    protected RandomType randomType;
    protected String chineseUnicode;
    protected ICaptchaStore captchaStore;
    protected boolean ignoreCase = true;

    @Override
    public void generate(HttpServletRequest request, OutputStream out, String ticket) throws IOException {
        String captcha = this.randomCaptcha();
        if (this.getCaptchaStore(request).put(ticket, captcha)) {
            this.writeImage(captcha, out);
        }
    }

    @Override
    public boolean verification(HttpServletRequest request, String ticket, String captcha) {
        String tc = this.getCaptchaStore(request).get(ticket);
        if (null == tc) {
            return false;
        }
        return this.ignoreCase ? tc.equalsIgnoreCase(captcha) : tc.equals(captcha);
    }

    private ICaptchaStore getCaptchaStore(HttpServletRequest request) {
        if (null == this.captchaStore) {
            return new CaptchaStoreSession(request);
        }
        return this.captchaStore;
    }

    protected abstract String writeImage(String var1, OutputStream var2) throws IOException;

    protected int num(int min, int max) {
        return min + RandomUtil.RANDOM.nextInt(max - min);
    }

    protected int num(int num) {
        return RandomUtil.RANDOM.nextInt(num);
    }

    protected String randomCaptcha() {
        if (null == this.randomType) {
            this.randomType = RandomType.MIX;
        }
        if (null == this.font) {
            this.font = RandomType.CHINESE == this.randomType ? new Font("\u6977\u4f53", 0, 28) : new Font("Arial", 0, 32);
        }
        if (null == this.rgbArr) {
            this.rgbArr = ColorType.LIVELY;
        }
        if (null == this.suffix) {
            String string = this.suffix = this.gif ? "gif" : "png";
        }
        if (this.width < 10) {
            this.width = 120;
        }
        if (this.height < 10) {
            this.height = 48;
        }
        if (this.length < 1) {
            this.length = 5;
        }
        if (RandomType.CHINESE == this.randomType) {
            return RandomUtil.getChinese(this.chineseUnicode, this.length);
        }
        return RandomUtil.getText(this.randomType, this.length);
    }

    public boolean isGif() {
        return this.gif;
    }

    public Font getFont() {
        return this.font;
    }

    public int[][] getRgbArr() {
        return this.rgbArr;
    }

    public int getInterfere() {
        return this.interfere;
    }

    public Color getInterfereColor() {
        return this.interfereColor;
    }

    public Color getColor() {
        return this.color;
    }

    public int getLength() {
        return this.length;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public RandomType getRandomType() {
        return this.randomType;
    }

    public String getChineseUnicode() {
        return this.chineseUnicode;
    }

    public ICaptchaStore getCaptchaStore() {
        return this.captchaStore;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public AbstractCaptcha setGif(boolean gif) {
        this.gif = gif;
        return this;
    }

    public AbstractCaptcha setFont(Font font) {
        this.font = font;
        return this;
    }

    public AbstractCaptcha setRgbArr(int[][] rgbArr) {
        this.rgbArr = rgbArr;
        return this;
    }

    public AbstractCaptcha setInterfere(int interfere) {
        this.interfere = interfere;
        return this;
    }

    public AbstractCaptcha setInterfereColor(Color interfereColor) {
        this.interfereColor = interfereColor;
        return this;
    }

    public AbstractCaptcha setColor(Color color) {
        this.color = color;
        return this;
    }

    public AbstractCaptcha setLength(int length) {
        this.length = length;
        return this;
    }

    public AbstractCaptcha setWidth(int width) {
        this.width = width;
        return this;
    }

    public AbstractCaptcha setHeight(int height) {
        this.height = height;
        return this;
    }

    public AbstractCaptcha setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public AbstractCaptcha setRandomType(RandomType randomType) {
        this.randomType = randomType;
        return this;
    }

    public AbstractCaptcha setChineseUnicode(String chineseUnicode) {
        this.chineseUnicode = chineseUnicode;
        return this;
    }

    public AbstractCaptcha setCaptchaStore(ICaptchaStore captchaStore) {
        this.captchaStore = captchaStore;
        return this;
    }

    public AbstractCaptcha setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractCaptcha)) {
            return false;
        }
        AbstractCaptcha other = (AbstractCaptcha)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGif() != other.isGif()) {
            return false;
        }
        Font this$font = this.getFont();
        Font other$font = other.getFont();
        if (this$font == null ? other$font != null : !((Object)this$font).equals(other$font)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getRgbArr(), (Object[])other.getRgbArr())) {
            return false;
        }
        if (this.getInterfere() != other.getInterfere()) {
            return false;
        }
        Color this$interfereColor = this.getInterfereColor();
        Color other$interfereColor = other.getInterfereColor();
        if (this$interfereColor == null ? other$interfereColor != null : !((Object)this$interfereColor).equals(other$interfereColor)) {
            return false;
        }
        Color this$color = this.getColor();
        Color other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)this$color).equals(other$color)) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        RandomType this$randomType = this.getRandomType();
        RandomType other$randomType = other.getRandomType();
        if (this$randomType == null ? other$randomType != null : !((Object)((Object)this$randomType)).equals((Object)other$randomType)) {
            return false;
        }
        String this$chineseUnicode = this.getChineseUnicode();
        String other$chineseUnicode = other.getChineseUnicode();
        if (this$chineseUnicode == null ? other$chineseUnicode != null : !this$chineseUnicode.equals(other$chineseUnicode)) {
            return false;
        }
        ICaptchaStore this$captchaStore = this.getCaptchaStore();
        ICaptchaStore other$captchaStore = other.getCaptchaStore();
        if (this$captchaStore == null ? other$captchaStore != null : !this$captchaStore.equals(other$captchaStore)) {
            return false;
        }
        return this.isIgnoreCase() == other.isIgnoreCase();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractCaptcha;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGif() ? 79 : 97);
        Font $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : ((Object)$font).hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getRgbArr());
        result = result * 59 + this.getInterfere();
        Color $interfereColor = this.getInterfereColor();
        result = result * 59 + ($interfereColor == null ? 43 : ((Object)$interfereColor).hashCode());
        Color $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        result = result * 59 + this.getLength();
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        RandomType $randomType = this.getRandomType();
        result = result * 59 + ($randomType == null ? 43 : ((Object)((Object)$randomType)).hashCode());
        String $chineseUnicode = this.getChineseUnicode();
        result = result * 59 + ($chineseUnicode == null ? 43 : $chineseUnicode.hashCode());
        ICaptchaStore $captchaStore = this.getCaptchaStore();
        result = result * 59 + ($captchaStore == null ? 43 : $captchaStore.hashCode());
        result = result * 59 + (this.isIgnoreCase() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AbstractCaptcha(gif=" + this.isGif() + ", font=" + this.getFont() + ", rgbArr=" + Arrays.deepToString((Object[])this.getRgbArr()) + ", interfere=" + this.getInterfere() + ", interfereColor=" + this.getInterfereColor() + ", color=" + this.getColor() + ", length=" + this.getLength() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", suffix=" + this.getSuffix() + ", randomType=" + (Object)((Object)this.getRandomType()) + ", chineseUnicode=" + this.getChineseUnicode() + ", captchaStore=" + this.getCaptchaStore() + ", ignoreCase=" + this.isIgnoreCase() + ")";
    }
}

