/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.captcha;

import com.baomidou.kisso.captcha.AbstractCaptcha;
import com.baomidou.kisso.captcha.GifEncoder;
import com.baomidou.kisso.common.util.RandomUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageCaptcha
extends AbstractCaptcha {
    private static ImageCaptcha IMAGE_CAPTCHA;

    public static synchronized ImageCaptcha getInstance() {
        if (null == IMAGE_CAPTCHA) {
            IMAGE_CAPTCHA = new ImageCaptcha();
        }
        return IMAGE_CAPTCHA;
    }

    private ImageCaptcha() {
    }

    @Override
    protected String writeImage(String captcha, OutputStream out) throws IOException {
        if (this.gif) {
            GifEncoder gifEncoder = new GifEncoder();
            gifEncoder.start(out);
            gifEncoder.setQuality(180);
            gifEncoder.setDelay(100);
            gifEncoder.setRepeat(0);
            for (int i = 0; i < this.length; ++i) {
                gifEncoder.addFrame(this.graphicsImage(captcha, i));
            }
            gifEncoder.finish();
        } else {
            ImageIO.write((RenderedImage)this.graphicsImage(captcha, 1), this.suffix, out);
        }
        out.flush();
        return captcha;
    }

    private BufferedImage graphicsImage(String code, int flag) {
        BufferedImage bi = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.width, this.height);
        g.setFont(this.font);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.interfere > 0) {
            for (int i = 0; i < this.interfere; ++i) {
                g.setColor(null == this.interfereColor ? RandomUtil.getColor(this.rgbArr) : this.interfereColor);
                g.setStroke(new BasicStroke(1.1f + RandomUtil.RANDOM.nextFloat() / 2.0f, 0, 2));
                int x1 = this.num(-10, this.width - 10);
                int y1 = this.num(5, this.height - 5);
                int x2 = this.num(10, this.width + 10);
                int y2 = this.num(2, this.height - 2);
                g.drawLine(x1, y1, x2, y2);
                g.setColor(null == this.interfereColor ? RandomUtil.getColor(this.rgbArr) : this.interfereColor);
                g.drawOval(this.num(this.width), this.num(this.height), 3 + this.num(15), 3 + this.num(15));
            }
        }
        int h = this.height - (this.height - this.font.getSize() >> 1);
        int w = this.width / this.length;
        for (int i = 0; i < this.length; ++i) {
            g.setColor(null == this.color ? RandomUtil.getColor(this.rgbArr) : this.color);
            g.setComposite(AlphaComposite.getInstance(3, this.gif ? this.getAlpha(i, flag) : 0.75f));
            g.drawString(String.valueOf(code.charAt(i)), this.width - (this.length - i) * w + (w - this.font.getSize()) + 1, h - 3);
        }
        return bi;
    }

    private float getAlpha(int i, int j) {
        int num = i + j;
        float r = 1.0f / (float)(this.length - 1);
        float s = (float)this.length * r;
        return num >= this.length ? (float)num * r - s : (float)num * r;
    }
}

