/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common;

import com.baomidou.kisso.common.util.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class IpHelper {
    private static final Logger logger = Logger.getLogger("IpHelper");
    public static String LOCAL_IP;
    public static String HOST_NAME;

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) && (ip = request.getRemoteAddr()).equals("127.0.0.1")) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                logger.severe("IpHelper error." + e.getMessage());
            }
        }
        if (ip != null && ip.length() > 15 && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }

    public static boolean isLocalIp(String ip) {
        if (StringUtils.isNotEmpty(ip)) {
            try {
                InetAddress[] ias;
                InetAddress inetAddress = InetAddress.getLocalHost();
                for (InetAddress ia : ias = InetAddress.getAllByName(inetAddress.getHostName())) {
                    if (!ip.equals(ia.getHostAddress())) continue;
                    return true;
                }
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String ip = "";
        try {
            InetAddress inetAddr = InetAddress.getLocalHost();
            HOST_NAME = inetAddr.getHostName();
            byte[] addr = inetAddr.getAddress();
            for (int i = 0; i < addr.length; ++i) {
                if (i > 0) {
                    ip = ip + ".";
                }
                ip = ip + (addr[i] & 0xFF);
            }
        }
        catch (UnknownHostException e) {
            ip = "unknown";
            logger.severe(e.getMessage());
        }
        finally {
            LOCAL_IP = ip;
        }
    }
}

