/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.security;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.common.RsaKeyHelper;
import com.baomidou.kisso.exception.KissoException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.FileCopyUtils;

public class JwtHelper {
    public static String signCompact(JwtBuilder jwtBuilder) {
        SSOConfig config = SSOConfig.getInstance();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forName((String)config.getSignAlgorithm());
        if ("RSA".equals(signatureAlgorithm.getFamilyName())) {
            try {
                ClassPathResource resource = new ClassPathResource(config.getRsaKeystore());
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(resource.getInputStream(), config.getRsaStorepass().toCharArray());
                Key key = keystore.getKey(config.getRsaAlias(), config.getRsaKeypass().toCharArray());
                return jwtBuilder.signWith(signatureAlgorithm, key).compact();
            }
            catch (Exception e) {
                throw new KissoException("signCompact error.", e);
            }
        }
        return jwtBuilder.signWith(signatureAlgorithm, config.getSignkey()).compact();
    }

    public static JwtParser verifyParser() {
        try {
            SSOConfig config = SSOConfig.getInstance();
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forName((String)config.getSignAlgorithm());
            if ("RSA".equals(signatureAlgorithm.getFamilyName())) {
                ClassPathResource resource = new ClassPathResource(config.getRsaCertstore());
                String publicKey = new String(FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream()));
                return Jwts.parser().setSigningKey((Key)RsaKeyHelper.parsePublicKey(publicKey));
            }
            return Jwts.parser().setSigningKey(config.getSignkey());
        }
        catch (Exception e) {
            throw new KissoException("verifyParser error.", e);
        }
    }
}

