/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.activerecord;

import com.baomidou.mybatisplus.enums.SqlMethod;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.SqlHelper;
import com.baomidou.mybatisplus.mapper.SqlRunner;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.springframework.transaction.annotation.Transactional;

public abstract class Model<T extends Model>
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Transactional
    public boolean insert() {
        return SqlHelper.retBool((Integer)this.sqlSession().insert(this.sqlStatement(SqlMethod.INSERT_ONE), (Object)this));
    }

    @Transactional
    public boolean insertAllColumn() {
        return SqlHelper.retBool((Integer)this.sqlSession().insert(this.sqlStatement(SqlMethod.INSERT_ONE_ALL_COLUMN), (Object)this));
    }

    @Transactional
    public boolean insertOrUpdate() {
        if (StringUtils.checkValNull((Object)this.pkVal())) {
            return this.insert();
        }
        return this.updateById() || this.insert();
    }

    @Transactional
    public boolean deleteById(Serializable id) {
        return SqlHelper.retBool((Integer)this.sqlSession().delete(this.sqlStatement(SqlMethod.DELETE_BY_ID), (Object)id));
    }

    @Transactional
    public boolean deleteById() {
        if (StringUtils.checkValNull((Object)this.pkVal())) {
            throw new MybatisPlusException("deleteById primaryKey is null.");
        }
        return this.deleteById(this.pkVal());
    }

    @Transactional
    public boolean delete(String whereClause, Object ... args) {
        return this.delete(Condition.create().where(whereClause, args));
    }

    @Transactional
    public boolean delete(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>();
        map.put("ew", wrapper);
        return SqlHelper.retBool((Integer)this.sqlSession().delete(this.sqlStatement(SqlMethod.DELETE), map));
    }

    @Transactional
    public boolean updateById() {
        if (StringUtils.checkValNull((Object)this.pkVal())) {
            throw new MybatisPlusException("updateById primaryKey is null.");
        }
        HashMap<String, Model> map = new HashMap<String, Model>();
        map.put("et", this);
        return SqlHelper.retBool((Integer)this.sqlSession().update(this.sqlStatement(SqlMethod.UPDATE_BY_ID), map));
    }

    @Transactional
    public boolean updateAllColumnById() {
        if (StringUtils.checkValNull((Object)this.pkVal())) {
            throw new MybatisPlusException("updateAllColumnById primaryKey is null.");
        }
        HashMap<String, Model> map = new HashMap<String, Model>();
        map.put("et", this);
        return SqlHelper.retBool((Integer)this.sqlSession().update(this.sqlStatement(SqlMethod.UPDATE_ALL_COLUMN_BY_ID), map));
    }

    @Transactional
    public boolean update(String whereClause, Object ... args) {
        return this.update(Condition.create().where(whereClause, args));
    }

    @Transactional
    public boolean update(Wrapper wrapper) {
        HashMap<String, Model<T>> map = new HashMap<String, Model<T>>();
        map.put("et", this);
        map.put("ew", (Model<T>)wrapper);
        return SqlHelper.retBool((Integer)this.sqlSession().update(this.sqlStatement(SqlMethod.UPDATE), map));
    }

    public List<T> selectAll() {
        return this.sqlSession().selectList(this.sqlStatement(SqlMethod.SELECT_LIST));
    }

    public T selectById(Serializable id) {
        return (T)((Model)this.sqlSession().selectOne(this.sqlStatement(SqlMethod.SELECT_BY_ID), (Object)id));
    }

    public T selectById() {
        if (StringUtils.checkValNull((Object)this.pkVal())) {
            throw new MybatisPlusException("selectById primaryKey is null.");
        }
        return this.selectById(this.pkVal());
    }

    public List<T> selectList(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>();
        map.put("ew", wrapper);
        return this.sqlSession().selectList(this.sqlStatement(SqlMethod.SELECT_LIST), map);
    }

    public List<T> selectList(String whereClause, Object ... args) {
        return this.selectList(Condition.create().where(whereClause, args));
    }

    public T selectOne(Wrapper wrapper) {
        return (T)((Model)SqlHelper.getObject(this.selectList(wrapper)));
    }

    public T selectOne(String whereClause, Object ... args) {
        return this.selectOne(Condition.create().where(whereClause, args));
    }

    public Page<T> selectPage(Page<T> page, Wrapper<T> wrapper) {
        HashMap<String, Wrapper<T>> map = new HashMap<String, Wrapper<T>>();
        SqlHelper.fillWrapper(page, wrapper);
        map.put("ew", wrapper);
        List tl = this.sqlSession().selectList(this.sqlStatement(SqlMethod.SELECT_PAGE), map, page);
        page.setRecords(tl);
        return page;
    }

    public Page<T> selectPage(Page<T> page, String whereClause, Object ... args) {
        return this.selectPage(page, Condition.create().where(whereClause, args));
    }

    public int selectCount(String whereClause, Object ... args) {
        return this.selectCount(Condition.create().where(whereClause, args));
    }

    public int selectCount(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>();
        map.put("ew", wrapper);
        return SqlHelper.retCount((Integer)((Integer)this.sqlSession().selectOne(this.sqlStatement(SqlMethod.SELECT_COUNT), map)));
    }

    public SqlRunner sql() {
        return new SqlRunner(this.getClass());
    }

    protected SqlSession sqlSession() {
        return SqlHelper.sqlSession(this.getClass());
    }

    protected String sqlStatement(SqlMethod sqlMethod) {
        return this.sqlStatement(sqlMethod.getMethod());
    }

    protected String sqlStatement(String sqlMethod) {
        return SqlHelper.table(this.getClass()).getSqlStatement(sqlMethod);
    }

    protected abstract Serializable pkVal();
}

