/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination.dialects;

import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;

public class DB2Dialect
implements IDialect {
    private static String getRowNumber(String originalSql) {
        StringBuilder rownumber = new StringBuilder(50).append("rownumber() over(");
        int orderByIndex = originalSql.toLowerCase().indexOf("order by");
        if (orderByIndex > 0 && !DB2Dialect.hasDistinct(originalSql)) {
            rownumber.append(originalSql.substring(orderByIndex));
        }
        rownumber.append(") as rownumber_,");
        return rownumber.toString();
    }

    private static boolean hasDistinct(String originalSql) {
        return originalSql.toLowerCase().contains("select distinct");
    }

    @Override
    public String buildPaginationSql(String originalSql, long offset, long limit) {
        int startOfSelect = originalSql.toLowerCase().indexOf("select");
        StringBuilder pagingSelect = new StringBuilder(originalSql.length() + 100).append(originalSql, 0, startOfSelect).append("select * from ( select ").append(DB2Dialect.getRowNumber(originalSql));
        if (DB2Dialect.hasDistinct(originalSql)) {
            pagingSelect.append(" row_.* from ( ").append(originalSql.substring(startOfSelect)).append(" ) as row_");
        } else {
            pagingSelect.append(originalSql.substring(startOfSelect + 6));
        }
        pagingSelect.append(" ) as temp_ where rownumber_ ");
        if (offset > 0L) {
            String endString = offset + "+" + limit;
            pagingSelect.append(" fetch first ").append(endString).append(" rows only) as temp_ where rownumber_ ").append("> ").append(offset);
        } else {
            pagingSelect.append(" fetch first ").append(limit).append(" rows only) as temp_ ");
        }
        return pagingSelect.toString();
    }
}

