/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.querys.DbQueryDecorator;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import com.baomidou.mybatisplus.generator.jdbc.DatabaseMetaDataWrapper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IDatabaseQuery {
    protected final ConfigBuilder configBuilder;
    protected final DataSourceConfig dataSourceConfig;

    public IDatabaseQuery(@NotNull ConfigBuilder configBuilder) {
        this.configBuilder = configBuilder;
        this.dataSourceConfig = configBuilder.getDataSourceConfig();
    }

    @NotNull
    public ConfigBuilder getConfigBuilder() {
        return this.configBuilder;
    }

    @NotNull
    public DataSourceConfig getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    @NotNull
    public abstract List<TableInfo> queryTables();

    public static class DefaultDatabaseQuery
    extends IDatabaseQuery {
        private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDatabaseQuery.class);
        private final StrategyConfig strategyConfig;
        private final GlobalConfig globalConfig;
        private final DbQueryDecorator dbQuery;

        public DefaultDatabaseQuery(@NotNull ConfigBuilder configBuilder) {
            super(configBuilder);
            this.strategyConfig = configBuilder.getStrategyConfig();
            this.dbQuery = new DbQueryDecorator(this.dataSourceConfig, this.strategyConfig);
            this.globalConfig = configBuilder.getGlobalConfig();
        }

        @Override
        @NotNull
        public List<TableInfo> queryTables() {
            boolean isInclude = this.strategyConfig.getInclude().size() > 0;
            boolean isExclude = this.strategyConfig.getExclude().size() > 0;
            ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
            ArrayList includeTableList = new ArrayList();
            ArrayList excludeTableList = new ArrayList();
            try {
                Object notExistTables;
                this.dbQuery.execute(this.dbQuery.tablesSql(), result -> {
                    String tableName = result.getStringResult(this.dbQuery.tableName());
                    if (StringUtils.isNotBlank((CharSequence)tableName)) {
                        TableInfo tableInfo = new TableInfo(this.configBuilder, tableName);
                        String tableComment = result.getTableComment();
                        if (!this.strategyConfig.isSkipView() || !"VIEW".equals(tableComment)) {
                            tableInfo.setComment(tableComment);
                            if (isInclude && this.strategyConfig.matchIncludeTable(tableName)) {
                                includeTableList.add(tableInfo);
                            } else if (isExclude && this.strategyConfig.matchExcludeTable(tableName)) {
                                excludeTableList.add(tableInfo);
                            }
                            tableList.add(tableInfo);
                        }
                    }
                });
                if (isExclude || isInclude) {
                    notExistTables = new HashSet<String>(isExclude ? this.strategyConfig.getExclude() : this.strategyConfig.getInclude()).stream().filter(s -> !ConfigBuilder.matcherRegTable(s)).collect(Collectors.toMap(String::toLowerCase, s -> s, (o, n) -> n));
                    for (TableInfo tabInfo : tableList) {
                        if (notExistTables.isEmpty()) break;
                        notExistTables.remove(tabInfo.getName().toLowerCase());
                    }
                    if (notExistTables.size() > 0) {
                        LOGGER.warn("\u8868[{}]\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01\uff01\uff01", (Object)String.join((CharSequence)",", notExistTables.values()));
                    }
                    if (isExclude) {
                        tableList.removeAll(excludeTableList);
                    } else {
                        tableList.clear();
                        tableList.addAll(includeTableList);
                    }
                }
                tableList.forEach(this::convertTableFields);
                notExistTables = tableList;
                return notExistTables;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.dbQuery.closeConnection();
            }
        }

        private void convertTableFields(@NotNull TableInfo tableInfo) {
            DbType dbType = this.dataSourceConfig.getDbType();
            String tableName = tableInfo.getName();
            try {
                HashMap<String, DatabaseMetaDataWrapper.ColumnsInfo> columnsMetaInfoMap = new HashMap<String, DatabaseMetaDataWrapper.ColumnsInfo>();
                Map<String, DatabaseMetaDataWrapper.ColumnsInfo> columnsInfo = new DatabaseMetaDataWrapper(this.dbQuery.getConnection()).getColumnsInfo(null, this.dataSourceConfig.getSchemaName(), tableName);
                if (columnsInfo != null && !columnsInfo.isEmpty()) {
                    columnsMetaInfoMap.putAll(columnsInfo);
                }
                String tableFieldsSql = this.dbQuery.tableFieldsSql(tableName);
                HashSet h2PkColumns = new HashSet();
                if (DbType.H2 == dbType) {
                    this.dbQuery.execute(String.format("select * from INFORMATION_SCHEMA.INDEXES WHERE TABLE_NAME = '%s'", tableName), result -> {
                        String primaryKey = result.getStringResult(this.dbQuery.fieldKey());
                        if (Boolean.parseBoolean(primaryKey)) {
                            h2PkColumns.add(result.getStringResult(this.dbQuery.fieldName()));
                        }
                    });
                }
                Entity entity = this.strategyConfig.entity();
                this.dbQuery.execute(tableFieldsSql, result -> {
                    boolean isId;
                    String columnName = result.getStringResult(this.dbQuery.fieldName());
                    TableField field = new TableField(this.configBuilder, columnName);
                    boolean bl = isId = DbType.H2 == dbType ? h2PkColumns.contains(columnName) : result.isPrimaryKey();
                    if (isId) {
                        field.primaryKey(this.dbQuery.isKeyIdentity(result.getResultSet()));
                        tableInfo.setHavePrimaryKey(true);
                        if (field.isKeyIdentityFlag() && entity.getIdType() != null) {
                            LOGGER.warn("\u5f53\u524d\u8868[{}]\u7684\u4e3b\u952e\u4e3a\u81ea\u589e\u4e3b\u952e\uff0c\u4f1a\u5bfc\u81f4\u5168\u5c40\u4e3b\u952e\u7684ID\u7c7b\u578b\u8bbe\u7f6e\u5931\u6548!", (Object)tableName);
                        }
                    }
                    field.setColumnName(columnName).setType(result.getStringResult(this.dbQuery.fieldType())).setComment(result.getFiledComment()).setCustomMap(this.dbQuery.getCustomFields(result.getResultSet()));
                    String propertyName = entity.getNameConvert().propertyNameConvert(field);
                    IColumnType columnType = this.dataSourceConfig.getTypeConvert().processTypeConvert(this.globalConfig, field);
                    field.setPropertyName(propertyName, columnType);
                    field.setMetaInfo(new TableField.MetaInfo((DatabaseMetaDataWrapper.ColumnsInfo)columnsMetaInfoMap.get(columnName.toLowerCase())));
                    tableInfo.addField(field);
                });
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            tableInfo.processTable();
        }
    }
}

