/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins;

import com.baomidou.mybatisplus.enums.DBType;
import com.baomidou.mybatisplus.parser.AbstractSqlParser;
import com.baomidou.mybatisplus.parser.SqlInfo;
import com.baomidou.mybatisplus.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.plugins.pagination.DialectFactory;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.baomidou.mybatisplus.toolkit.JdbcUtils;
import com.baomidou.mybatisplus.toolkit.PluginUtils;
import com.baomidou.mybatisplus.toolkit.SqlUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.sql.Connection;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class CachePaginationInterceptor
extends PaginationInterceptor
implements Interceptor {
    private boolean overflowCurrent = false;
    private AbstractSqlParser sqlParser;
    private String dialectClazz;

    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        if (target instanceof StatementHandler) {
            StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget(invocation.getTarget());
            MetaObject metaStatementHandler = SystemMetaObject.forObject((Object)statementHandler);
            RowBounds rowBounds = (RowBounds)metaStatementHandler.getValue("delegate.rowBounds");
            if (rowBounds == null || rowBounds == RowBounds.DEFAULT) {
                return invocation.proceed();
            }
            BoundSql boundSql = (BoundSql)metaStatementHandler.getValue("delegate.boundSql");
            String originalSql = boundSql.getSql();
            Connection connection = (Connection)invocation.getArgs()[0];
            DBType dbType = JdbcUtils.getDbType(connection.getMetaData().getURL());
            if (rowBounds instanceof Pagination) {
                String tempSql;
                int orderByIndex;
                Pagination page = (Pagination)rowBounds;
                boolean orderBy = true;
                if (page.isSearchCount() && (orderByIndex = (tempSql = originalSql.replaceAll("(?i)ORDER[\\s]+BY", "ORDER BY")).toUpperCase().lastIndexOf("ORDER BY")) <= -1) {
                    orderBy = false;
                }
                String buildSql = SqlUtils.concatOrderBy(originalSql, page, orderBy);
                originalSql = DialectFactory.buildPaginationSql(page, buildSql, dbType, this.dialectClazz);
            } else {
                originalSql = DialectFactory.buildPaginationSql(rowBounds, originalSql, dbType, this.dialectClazz);
            }
            metaStatementHandler.setValue("delegate.boundSql.sql", (Object)originalSql);
            metaStatementHandler.setValue("delegate.rowBounds.offset", (Object)0);
            metaStatementHandler.setValue("delegate.rowBounds.limit", (Object)Integer.MAX_VALUE);
        } else {
            Pagination page;
            RowBounds rowBounds = (RowBounds)invocation.getArgs()[2];
            if (rowBounds == null || rowBounds == RowBounds.DEFAULT) {
                return invocation.proceed();
            }
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            Executor executor = (Executor)invocation.getTarget();
            Connection connection = executor.getTransaction().getConnection();
            Object parameterObject = invocation.getArgs()[1];
            BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
            String originalSql = boundSql.getSql();
            if (rowBounds instanceof Pagination && (page = (Pagination)rowBounds).isSearchCount()) {
                SqlInfo sqlInfo = SqlUtils.getCountOptimize(this.sqlParser, originalSql);
                super.queryTotal(this.overflowCurrent, sqlInfo.getSql(), mappedStatement, boundSql, page, connection);
                if (page.getTotal() <= 0) {
                    return invocation.proceed();
                }
            }
        }
        return invocation.proceed();
    }

    @Override
    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    @Override
    public void setProperties(Properties prop) {
        String dialectClazz = prop.getProperty("dialectClazz");
        if (StringUtils.isNotEmpty(dialectClazz)) {
            this.dialectClazz = dialectClazz;
        }
    }

    @Override
    public void setSqlParser(AbstractSqlParser sqlParser) {
        this.sqlParser = sqlParser;
    }

    @Override
    public void setOverflowCurrent(boolean overflowCurrent) {
        this.overflowCurrent = overflowCurrent;
    }
}

