/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.soa;

import java.util.HashMap;
import java.util.Map;
import org.frameworkset.soa.PluginFactory;
import org.frameworkset.soa.PreSerial;
import org.frameworkset.soa.Serial;
import org.frameworkset.spi.DefaultApplicationContext;
import org.frameworkset.spi.assemble.Pro;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialFactory {
    private static Logger log = LoggerFactory.getLogger(SerialFactory.class);
    private Map<String, MagicClass> magicclassesByName = new HashMap<String, MagicClass>();
    private Map<String, MagicClass> magicclassesByMagicNumber = new HashMap<String, MagicClass>();
    private Map<String, MagicClass> defaultPlugins = new HashMap<String, MagicClass>();
    private Map<String, MagicClass> defaultmagicclassesByMagicNumber = new HashMap<String, MagicClass>();
    private static PluginFactory hibernatePluginFactory;
    private static String[] defaultPluginNames;
    private String[] defaultIgnoreExceptionNames = new String[]{"org.hibernate.LazyInitializationException"};
    private String[] ignoreExceptionNames;
    private static SerialFactory serialFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SerialFactory getSerialFactory() {
        if (serialFactory != null) {
            return serialFactory;
        }
        Class<SerialFactory> clazz = SerialFactory.class;
        synchronized (SerialFactory.class) {
            if (serialFactory == null) {
                SerialFactory serialFactory = new SerialFactory();
                serialFactory.initDefaultPlugins();
                serialFactory.init();
                SerialFactory.serialFactory = serialFactory;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return serialFactory;
        }
    }

    public void init() {
        DefaultApplicationContext context = DefaultApplicationContext.getApplicationContext("org/frameworkset/soa/serialconf.xml");
        for (String magicClasss : context.getPropertyKeys()) {
            Pro magic;
            if (!magicClasss.equals("ignoreExceptions")) {
                magic = context.getProBean(magicClasss);
                String magicNumber = magic.getStringExtendAttribute("magic");
                String serial = magic.getStringExtendAttribute("serial");
                String preserial = magic.getStringExtendAttribute("preserial");
                MagicClass MagicClass2 = new MagicClass();
                MagicClass2.setMagicclass(magicClasss);
                MagicClass2.setSerial(serial);
                MagicClass2.setMagicnumber(magicNumber);
                MagicClass2.setPreserial(preserial);
                this.magicclassesByName.put(magicClasss, MagicClass2);
                this.magicclassesByMagicNumber.put(magicNumber, MagicClass2);
                continue;
            }
            magic = context.getProBean(magicClasss);
            String ignoreExceptions = (String)magic.getValue();
            if (ignoreExceptions == null || ignoreExceptions.trim().length() <= 0) continue;
            ignoreExceptions = ignoreExceptions.trim();
            this.ignoreExceptionNames = ignoreExceptions.split("\n");
            for (int i = 0; i < this.ignoreExceptionNames.length; ++i) {
                this.ignoreExceptionNames[i] = this.ignoreExceptionNames[i].trim();
            }
        }
    }

    private MagicClass buildMagicClass(String preclazz, boolean debugInfo) {
        MagicClass magicClass;
        block6: {
            magicClass = null;
            try {
                PreSerial preSerial = (PreSerial)Class.forName(preclazz).newInstance();
                magicClass = new MagicClass();
                magicClass.setPreserial(preclazz);
                magicClass.setPreserialObject(preSerial);
                magicClass.setMagicclass(preSerial.getClazz());
                magicClass.setMagicnumber(preSerial.getClazz());
                this.defaultmagicclassesByMagicNumber.put(preSerial.getClazz(), magicClass);
                this.defaultPlugins.put(preSerial.getClazz(), magicClass);
            }
            catch (InstantiationException e) {
                if (debugInfo && log.isDebugEnabled()) {
                    log.debug("buildMagicClass [" + preclazz + "] InstantiationException:" + e.getMessage());
                }
            }
            catch (IllegalAccessException e) {
                if (debugInfo && log.isDebugEnabled()) {
                    log.debug("buildMagicClass [" + preclazz + "] IllegalAccessException:" + e.getMessage());
                }
            }
            catch (ClassNotFoundException e) {
                if (!debugInfo || !log.isDebugEnabled()) break block6;
                log.debug("buildMagicClass [" + preclazz + "] ClassNotFoundException:" + e.getMessage());
            }
        }
        return magicClass;
    }

    public void initDefaultPlugins() {
        for (String clazz : defaultPluginNames) {
            this.buildMagicClass(clazz, true);
        }
        if (hibernatePluginFactory != null && hibernatePluginFactory.getPlugins() != null) {
            for (String clazz : hibernatePluginFactory.getPlugins()) {
                this.buildMagicClass(clazz, false);
            }
        }
    }

    public String getMagicNumber(String className) {
        MagicClass magicClass = this.magicclassesByName.get(className);
        return magicClass.magicnumber;
    }

    public MagicClass getMagicClassByMagicNumber(String magicnumber) {
        MagicClass magicClass = this.magicclassesByMagicNumber.get(magicnumber);
        if (magicClass == null) {
            magicClass = this.defaultmagicclassesByMagicNumber.get(magicnumber);
        }
        return magicClass;
    }

    public MagicClass getMagicClass(String magicclassName) {
        MagicClass magicClass = this.magicclassesByName.get(magicclassName);
        if (magicClass == null) {
            magicClass = this.defaultPlugins.get(magicclassName);
        }
        return magicClass;
    }

    public MagicClass getMagicClass(Class magicclass) {
        String magicclassName = magicclass.getName();
        return this.getMagicClass(magicclassName);
    }

    public boolean isIgnoreException(Throwable e) {
        String name = e.getClass().getName();
        for (String iname : this.defaultIgnoreExceptionNames) {
            if (!name.equals(iname)) continue;
            return true;
        }
        if (this.ignoreExceptionNames != null) {
            for (String iname : this.ignoreExceptionNames) {
                if (!name.equals(iname)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        try {
            Class<?> hibernatePluginFactoryClass = Class.forName("org.frameworkset.hibernate.serial.HibernatePluginFactory");
            hibernatePluginFactory = (PluginFactory)hibernatePluginFactoryClass.newInstance();
        }
        catch (ClassNotFoundException hibernatePluginFactoryClass) {
        }
        catch (Throwable e) {
            log.debug("Init HibernatePluginFactory failed:", e);
        }
        defaultPluginNames = new String[]{"org.frameworkset.soa.plugin.UnmodifiableRandomAccessListPreSerial", "org.frameworkset.soa.plugin.SublistPreSerial", "org.frameworkset.soa.plugin.UnmodifiableCollectionPreSerial", "org.frameworkset.soa.plugin.UnmodifiableListPreSerial", "org.frameworkset.soa.plugin.UnmodifiableMapPreSerial", "org.frameworkset.soa.plugin.UnmodifiableSetPreSerial", "org.frameworkset.soa.plugin.UnmodifiableSortedMapPreSerial", "org.frameworkset.soa.plugin.UnmodifiableSortedSetPreSerial"};
    }

    public static class MagicClass {
        private String magicnumber;
        private String magicclass;
        private String serial;
        private Serial serailObject;
        private String preserial;
        private PreSerial preserialObject;

        public Serial getSerailObject() {
            if (this.serial == null) {
                return null;
            }
            if (this.serailObject == null) {
                try {
                    this.serailObject = (Serial)Class.forName(this.serial).newInstance();
                }
                catch (InstantiationException e) {
                    log.warn("", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.warn("", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.warn("", (Throwable)e);
                }
            }
            return this.serailObject;
        }

        public String getMagicnumber() {
            return this.magicnumber;
        }

        public void setMagicnumber(String magicnumber) {
            this.magicnumber = magicnumber;
        }

        public String getMagicclass() {
            return this.magicclass;
        }

        public void setMagicclass(String magicclass) {
            this.magicclass = magicclass;
        }

        public String getSerial() {
            return this.serial;
        }

        public void setSerial(String serial) {
            this.serial = serial;
        }

        public String getPreserial() {
            return this.preserial;
        }

        public PreSerial getPreserialObject() {
            if (this.preserial == null) {
                return null;
            }
            if (this.preserialObject == null) {
                try {
                    this.preserialObject = (PreSerial)Class.forName(this.preserial).newInstance();
                }
                catch (InstantiationException e) {
                    log.warn("", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.warn("", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.warn("", (Throwable)e);
                }
            }
            return this.preserialObject;
        }

        public void setPreserial(String preserial) {
            this.preserial = preserial;
        }

        public void setPreserialObject(PreSerial preserialObject) {
            this.preserialObject = preserialObject;
        }
    }
}

