/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.assemble;

import com.frameworkset.util.ValueObjectUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.frameworkset.spi.CallContext;
import org.frameworkset.spi.assemble.CannotModifyException;
import org.frameworkset.spi.assemble.Context;
import org.frameworkset.spi.assemble.Pro;
import org.frameworkset.spi.assemble.ProList;
import org.frameworkset.spi.assemble.ProSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProArray
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ProArray.class);
    private boolean isfreeze = false;
    private String componentType;
    Pro[] pros;
    List<Pro> pros_temp;
    private Object componentArray;
    private Object lock = new Object();

    public Pro addPro(Pro pro) {
        if (this.pros_temp == null) {
            this.pros_temp = new ArrayList<Pro>();
        }
        this.pros_temp.add(pro);
        return pro;
    }

    public void freeze() {
        this.isfreeze = true;
        if (this.pros_temp != null) {
            this.pros = new Pro[this.pros_temp.size()];
            for (int i = 0; i < this.pros_temp.size(); ++i) {
                this.pros[i] = this.pros_temp.get(i);
            }
            this.pros_temp = null;
        }
    }

    private boolean isFreeze() {
        return this.isfreeze;
    }

    private void modify() {
        if (this.isFreeze()) {
            throw new CannotModifyException();
        }
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public Object getObject(int i, Object defaultValue) {
        Pro value = this.pros[i];
        if (value == null) {
            return defaultValue;
        }
        return value.getObject(defaultValue);
    }

    public int getInt(int i, int defaultValue) {
        Pro value = this.pros[i];
        if (value == null) {
            return defaultValue;
        }
        return value.getInt();
    }

    public Pro getPro(int i) {
        return this.pros[i];
    }

    public boolean getBoolean(int i) {
        Pro value = this.pros[i];
        if (value == null) {
            return false;
        }
        return value.getBoolean();
    }

    public boolean getBoolean(int i, boolean defaultValue) {
        Pro value = this.pros[i];
        if (value == null) {
            return defaultValue;
        }
        boolean value_ = value.getBoolean(defaultValue);
        return value_;
    }

    public String getString(int i) {
        Pro value = this.pros[i];
        if (value == null) {
            return null;
        }
        return value.getString();
    }

    public String getString(int i, String defaultValue) {
        Pro value = this.pros[i];
        if (value == null) {
            return defaultValue;
        }
        return value.getString(defaultValue);
    }

    public ProList getList(int i, ProList defaultValue) {
        Pro value = this.pros[i];
        if (value == null) {
            return defaultValue;
        }
        return value.getList(defaultValue);
    }

    public ProList getList(int i) {
        Pro value = this.pros[i];
        if (value == null) {
            return null;
        }
        return value.getList();
    }

    public ProSet getSet(int i, ProSet defaultValue) {
        Pro value = this.pros[i];
        if (value == null) {
            return defaultValue;
        }
        return value.getSet(defaultValue);
    }

    public ProSet getSet(int i) {
        Pro value = this.pros[i];
        if (value == null) {
            return null;
        }
        return value.getSet();
    }

    public Pro[] getPros() {
        return this.pros;
    }

    public void setPros(Pro[] pros) {
        this.modify();
        this.pros = pros;
    }

    public int size() {
        return this.pros != null ? this.pros.length : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getComponentArray(CallContext callcontext) {
        if (this.getComponentType() == null) {
            return this;
        }
        if (this.componentArray != null) return this.componentArray;
        Object object = this.lock;
        synchronized (object) {
            if (this.componentArray != null) return this.componentArray;
            if (this.componentType.equalsIgnoreCase("bean")) {
                Class enumType = this.pros[0].getBeanClass();
                this.componentArray = Array.newInstance(enumType, this.size());
                int i = 0;
                if (this.pros == null) return this.componentArray;
                Context currentLoopContext = callcontext != null ? callcontext.getLoopContext() : null;
                for (Pro v : this.pros) {
                    try {
                        Array.set(this.componentArray, i, v.getBean(callcontext, true));
                    }
                    finally {
                        if (callcontext != null) {
                            callcontext.setLoopContext(currentLoopContext);
                        }
                    }
                    ++i;
                }
            } else if (this.componentType.equalsIgnoreCase("String") || this.componentType.equalsIgnoreCase("java.lang.String")) {
                this.componentArray = Array.newInstance(String.class, this.size());
                int i = 0;
                if (this.pros == null) return this.componentArray;
                for (Pro v : this.pros) {
                    Array.set(this.componentArray, i, v.getString());
                    ++i;
                }
            } else if (this.componentType.equalsIgnoreCase("Object") || this.componentType.equalsIgnoreCase("java.lang.Object")) {
                this.componentArray = Array.newInstance(Object.class, this.size());
                int i = 0;
                if (this.pros == null) return this.componentArray;
                Context currentLoopContext = callcontext != null ? callcontext.getLoopContext() : null;
                for (Pro v : this.pros) {
                    try {
                        Array.set(this.componentArray, i, v.getBean(callcontext, true));
                    }
                    finally {
                        if (callcontext != null) {
                            callcontext.setLoopContext(currentLoopContext);
                        }
                    }
                    ++i;
                }
            } else if (this.componentType.equalsIgnoreCase("Class")) {
                this.componentArray = Array.newInstance(Class.class, this.size());
                int i = 0;
                if (this.pros == null) return this.componentArray;
                Context currentLoopContext = callcontext != null ? callcontext.getLoopContext() : null;
                for (Pro v : this.pros) {
                    try {
                        Object value = v.getBean(callcontext, true);
                        Array.set(this.componentArray, i, ValueObjectUtil.typeCast((Object)value, Class.class));
                    }
                    finally {
                        if (callcontext != null) {
                            callcontext.setLoopContext(currentLoopContext);
                        }
                    }
                    ++i;
                }
            } else {
                try {
                    this.componentArray = Array.newInstance(ValueObjectUtil.getClass((String)this.componentType), this.size());
                    int i = 0;
                    if (this.pros == null) return this.componentArray;
                    Context currentLoopContext = callcontext != null ? callcontext.getLoopContext() : null;
                    for (Pro v : this.pros) {
                        try {
                            Array.set(this.componentArray, i, v.getBean(callcontext, true));
                        }
                        finally {
                            if (callcontext != null) {
                                callcontext.setLoopContext(currentLoopContext);
                            }
                        }
                        ++i;
                    }
                }
                catch (NegativeArraySizeException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    this.componentArray = this;
                }
                catch (ClassNotFoundException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    this.componentArray = this;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    this.componentArray = this;
                }
            }
            return this.componentArray;
        }
    }
}

