/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.proxy.route;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.spi.remote.http.proxy.HttpAddress;
import org.frameworkset.spi.remote.http.proxy.RoundRobinList;

public class RoutingGroup {
    protected RoundRobinList serversList;
    protected List<HttpAddress> addressList = new ArrayList<HttpAddress>();
    private Map<String, HttpAddress> addressMap = new HashMap<String, HttpAddress>();

    public void addHttpAddress(HttpAddress httpAddress) {
        this.addressList.add(httpAddress);
        this.addressMap.put(httpAddress.getAddress(), httpAddress);
    }

    public HttpAddress get() {
        return this.serversList.getFromRouting();
    }

    public void after() {
        this.serversList = new RoundRobinList(this.addressList);
    }

    public void after(List<HttpAddress> commonGroup) {
        if (commonGroup != null && commonGroup.size() > 0) {
            this.addressList.addAll(commonGroup);
            for (HttpAddress httpAddress : commonGroup) {
                this.addressMap.put(httpAddress.getAddress(), httpAddress);
            }
        }
        this.serversList = new RoundRobinList(this.addressList);
    }

    public String toString() {
        if (this.addressList != null) {
            return this.addressList.toString();
        }
        return "{}";
    }
}

