/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http;

import java.io.IOException;
import org.apache.http.protocol.HttpContext;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.CustomHttpRequestRetryHandler;
import org.frameworkset.spi.remote.http.DefaultHttpRequestRetryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestRetryHandlerHelper
extends org.apache.http.impl.client.DefaultHttpRequestRetryHandler {
    private static Logger logger = LoggerFactory.getLogger(DefaultHttpRequestRetryHandler.class);
    private CustomHttpRequestRetryHandler httpRequestRetryHandler;
    private ClientConfiguration configuration;

    public HttpRequestRetryHandlerHelper(CustomHttpRequestRetryHandler httpRequestRetryHandler, ClientConfiguration configuration) {
        super(configuration.getRetryTime(), false);
        this.httpRequestRetryHandler = httpRequestRetryHandler;
        this.configuration = configuration;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        if (this.httpRequestRetryHandler != null) {
            if (executionCount > this.configuration.getRetryTime()) {
                return false;
            }
            if (this.httpRequestRetryHandler.retryRequest(exception, executionCount, context, this.configuration)) {
                if (this.configuration.getRetryInterval() > 0L) {
                    try {
                        Thread.sleep(this.configuration.getRetryInterval());
                    }
                    catch (InterruptedException e1) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        if (super.retryRequest(exception, executionCount, context)) {
            if (this.configuration.getRetryInterval() > 0L) {
                try {
                    Thread.sleep(this.configuration.getRetryInterval());
                }
                catch (InterruptedException e1) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

