/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http;

import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.frameworkset.spi.remote.http.BaseURLResponseHandler;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.HttpDeleteWithBody;
import org.frameworkset.spi.remote.http.HttpRequestProxy;
import org.frameworkset.spi.remote.http.StringResponseHandler;
import org.frameworkset.spi.remote.http.URLResponseHandler;
import org.frameworkset.spi.remote.http.proxy.HttpProxyRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpRequestProxy.class);
    public static final String HTTP_GET = "get";
    public static final String HTTP_POST = "post";
    public static final String HTTP_DELETE = "delete";
    public static final String HTTP_PUT = "put";
    public static final String HTTP_HEAD = "head";
    public static final String HTTP_TRACE = "trace";
    public static final String HTTP_OPTIONS = "options";
    public static final String HTTP_PATCH = "patch";
    public static final String UTF_8 = "UTF-8";
    private static long retryInterval = -1L;

    public static void startHttpPools(String configFile) {
        ClientConfiguration.startHttpPools(configFile);
    }

    public static void startHttpPoolsFromApollo(String namespaces) {
        ClientConfiguration.startHttpPoolsFromApollo(namespaces);
    }

    public static void startHttpPoolsFromApolloAwaredChange(String namespaces) {
        ClientConfiguration.startHttpPoolsFromApolloAwaredChange(namespaces);
    }

    public static void startHttpPoolsFromApollo(String namespaces, String configChangeListener) {
        ClientConfiguration.startHttpPoolsFromApollo(namespaces, configChangeListener);
    }

    public static void startHttpPools(Map<String, Object> configs) {
        ClientConfiguration.startHttpPools(configs);
    }

    static HttpClient getHttpClient(ClientConfiguration config) throws Exception {
        return config.getHttpClient();
    }

    static String getCookie() {
        return null;
    }

    static String getUserAgent() {
        return null;
    }

    static HttpGet getHttpGet(String url, String cookie, String userAgent, Map<String, String> headers) {
        return HttpRequestUtil.getHttpGet(ClientConfiguration.getDefaultClientConfiguration(), url, cookie, userAgent, headers);
    }

    static HttpGet getHttpGet(ClientConfiguration config, String url, String cookie, String userAgent, Map<String, String> headers) {
        HttpGet httpget = new HttpGet(url);
        RequestConfig requestConfig = config.getRequestConfig();
        httpget.setConfig(requestConfig);
        if (config.getKeepAlive() > 0L) {
            httpget.addHeader("Connection", "Keep-Alive");
        }
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpget.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return httpget;
    }

    static HttpTrace getHttpTrace(ClientConfiguration config, String url, String cookie, String userAgent, Map<String, String> headers) {
        HttpTrace httpget = new HttpTrace(url);
        RequestConfig requestConfig = config.getRequestConfig();
        httpget.setConfig(requestConfig);
        if (config.getKeepAlive() > 0L) {
            httpget.addHeader("Connection", "Keep-Alive");
        }
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpget.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return httpget;
    }

    static HttpOptions getHttpOptions(ClientConfiguration config, String url, String cookie, String userAgent, Map<String, String> headers) {
        HttpOptions httpget = new HttpOptions(url);
        RequestConfig requestConfig = config.getRequestConfig();
        httpget.setConfig(requestConfig);
        if (config.getKeepAlive() > 0L) {
            httpget.addHeader("Connection", "Keep-Alive");
        }
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpget.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return httpget;
    }

    static HttpPatch getHttpPatch(ClientConfiguration config, String url, String cookie, String userAgent, Map<String, String> headers) {
        HttpPatch httpget = new HttpPatch(url);
        RequestConfig requestConfig = config.getRequestConfig();
        httpget.setConfig(requestConfig);
        if (config.getKeepAlive() > 0L) {
            httpget.addHeader("Connection", "Keep-Alive");
        }
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpget.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return httpget;
    }

    static HttpHead getHttpHead(ClientConfiguration config, String url, String cookie, String userAgent, Map<String, String> headers) {
        HttpHead httpHead = new HttpHead(url);
        RequestConfig requestConfig = config.getRequestConfig();
        httpHead.setConfig(requestConfig);
        if (config.getKeepAlive() > 0L) {
            httpHead.addHeader("Connection", "Keep-Alive");
        }
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpHead.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return httpHead;
    }

    static HttpPost getHttpPost(String url, String cookie, String userAgent) {
        return HttpRequestUtil.getHttpPost(ClientConfiguration.getDefaultClientConfiguration(), url, cookie, userAgent, null);
    }

    static HttpPost getHttpPost(ClientConfiguration config, String url, String cookie, String userAgent, Map<String, String> headers) {
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = config.getRequestConfig();
        httpPost.setConfig(requestConfig);
        if (config.getKeepAlive() > 0L) {
            httpPost.addHeader("Connection", "Keep-Alive");
        }
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return httpPost;
    }

    static HttpDelete getHttpDelete(ClientConfiguration config, String url, String cookie, String userAgent, Map<String, String> headers) {
        HttpDelete httpDelete = new HttpDelete(url);
        RequestConfig requestConfig = config.getRequestConfig();
        httpDelete.setConfig(requestConfig);
        if (config.getKeepAlive() > 0L) {
            httpDelete.addHeader("Connection", "Keep-Alive");
        }
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpDelete.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return httpDelete;
    }

    static HttpDeleteWithBody getHttpDeleteWithBody(ClientConfiguration config, String url, String cookie, String userAgent, Map<String, String> headers) {
        HttpDeleteWithBody httpDelete = new HttpDeleteWithBody(url);
        RequestConfig requestConfig = config.getRequestConfig();
        httpDelete.setConfig(requestConfig);
        if (config.getKeepAlive() > 0L) {
            httpDelete.addHeader("Connection", "Keep-Alive");
        }
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpDelete.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return httpDelete;
    }

    static HttpPut getHttpPut(ClientConfiguration config, String url, String cookie, String userAgent, Map<String, String> headers) {
        HttpPut httpPut = new HttpPut(url);
        RequestConfig requestConfig = config.getRequestConfig();
        httpPut.setConfig(requestConfig);
        if (config.getKeepAlive() > 0L) {
            httpPut.addHeader("Connection", "Keep-Alive");
        }
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPut.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return httpPut;
    }

    public static String httpGetforString(String url) throws Exception {
        return HttpRequestUtil.httpGetforString(url, (String)null, (String)null, (Map<String, String>)null);
    }

    public static String httpGetforString(String poolname, String url) throws Exception {
        return HttpRequestUtil.httpGetforString(poolname, url, null, null, null);
    }

    public static <T> T httpGet(String poolname, String url, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpGetforString(poolname, url, null, null, null, responseHandler);
    }

    public static <T> T httpGet(String poolname, String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpGetforString(poolname, url, null, null, headers, responseHandler);
    }

    public static <T> T httpGet(String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpGetforString("default", url, null, null, headers, responseHandler);
    }

    public static String httpGetforString(String url, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpGetforString(url, (String)null, (String)null, headers);
    }

    public static String httpGetforString(String poolname, String url, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpGetforString(poolname, url, null, null, headers);
    }

    public static <T> T httpGetforString(String poolname, String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpGetforString(poolname, url, null, null, headers, responseHandler);
    }

    public static <T> T httpGetforString(String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpGetforString("default", url, null, null, headers, responseHandler);
    }

    public static String httpGetforString(String url, String cookie, String userAgent, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpGetforString("default", url, cookie, userAgent, headers);
    }

    public static String httpGetforString(String poolname, String url, String cookie, String userAgent, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpGetforString(poolname, url, cookie, userAgent, headers, new StringResponseHandler());
    }

    public static <T> T httpGetforString(String poolname, String url, String cookie, String userAgent, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpGet(poolname, url, cookie, userAgent, headers, responseHandler);
    }

    public static <T> T httpGet(String poolname, String url, String cookie, String userAgent, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        HttpClient httpClient = null;
        HttpGet httpGet = null;
        Object responseBody = null;
        ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
        try {
            httpClient = HttpRequestUtil.getHttpClient(config);
            httpGet = HttpRequestUtil.getHttpGet(config, url, cookie, userAgent, headers);
            if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                ((URLResponseHandler)responseHandler).setUrl(url);
            }
            responseBody = httpClient.execute((HttpUriRequest)httpGet, responseHandler);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
            httpClient = null;
        }
        return (T)responseBody;
    }

    public static <T> T httpHead(String poolname, String url, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpHead(poolname, url, null, null, null, responseHandler);
    }

    public static <T> T httpHead(String url, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpHead("default", url, null, null, null, responseHandler);
    }

    public static <T> T httpHead(String poolname, String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpHead(poolname, url, null, null, params, headers, responseHandler);
    }

    public static <T> T httpHead(String poolname, String url, String cookie, String userAgent, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpHead(poolname, url, cookie, userAgent, null, headers, responseHandler);
    }

    public static <T> T httpHead(String poolname, String url, String cookie, String userAgent, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        HttpClient httpClient = null;
        HttpHead httpHead = null;
        Object responseBody = null;
        ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
        try {
            httpClient = HttpRequestUtil.getHttpClient(config);
            httpHead = HttpRequestUtil.getHttpHead(config, url, cookie, userAgent, headers);
            BasicHttpParams httpParams = null;
            if (params != null && params.size() > 0) {
                httpParams = new BasicHttpParams();
                Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
                Object paramPair_ = null;
                int i = 0;
                while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    httpParams.setParameter(entry.getKey(), entry.getValue());
                    ++i;
                }
                httpHead.setParams((HttpParams)httpParams);
            }
            if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                ((URLResponseHandler)responseHandler).setUrl(url);
            }
            responseBody = httpClient.execute((HttpUriRequest)httpHead, responseHandler);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (httpHead != null) {
                httpHead.releaseConnection();
            }
            httpClient = null;
        }
        return (T)responseBody;
    }

    public static String httpPostFileforString(String url, Map<String, Object> params, Map<String, File> files) throws Exception {
        return HttpRequestUtil.httpPostFileforString("default", url, null, null, params, files);
    }

    public static String httpPostFileforString(String poolname, String url, Map<String, Object> params, Map<String, File> files) throws Exception {
        return HttpRequestUtil.httpPostFileforString(poolname, url, null, null, params, files);
    }

    public static String httpPostforString(String url, Map<String, Object> params) throws Exception {
        return HttpRequestUtil.httpPostforString(url, params, (Map<String, String>)null);
    }

    public static <T> T httpPost(String url, Map<String, Object> params, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpPostforString(url, params, (Map<String, String>)null, responseHandler);
    }

    public static String httpPostforString(String url, Map<String, Object> params, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpPostFileforString("default", url, null, null, params, null, headers);
    }

    public static String httpPostforString(String poolName, String url, Map<String, Object> params, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpPostFileforString(poolName, url, null, null, params, null, headers);
    }

    public static <T> T httpPost(String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpPost("default", url, null, null, params, null, headers, responseHandler);
    }

    public static <T> T httpPostforString(String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpPost("default", url, null, null, params, null, headers, responseHandler);
    }

    public static <T> T httpPostforString(String poolName, String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpPost(poolName, url, null, null, params, null, headers, responseHandler);
    }

    public static String httpPostforString(String poolname, String url, Map<String, Object> params) throws Exception {
        return HttpRequestUtil.httpPostFileforString(poolname, url, null, null, params, null);
    }

    public static String httpPostforString(String url) throws Exception {
        return HttpRequestUtil.httpPostforString("default", url);
    }

    public static <T> T httpPost(String url, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpPost("default", url, responseHandler);
    }

    public static String httpPostforString(String poolname, String url) throws Exception {
        return HttpRequestUtil.httpPostFileforString(poolname, url, null, null, null, null);
    }

    public static <T> T httpPost(String poolname, String url, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpPost(poolname, url, null, null, null, null, null, responseHandler);
    }

    public static String httpPostforString(String url, String cookie, String userAgent, Map<String, File> files) throws Exception {
        return HttpRequestUtil.httpPostforString("default", url, cookie, userAgent, files);
    }

    public static String httpPostforString(String poolname, String url, String cookie, String userAgent, Map<String, File> files) throws Exception {
        return HttpRequestUtil.httpPostFileforString(poolname, url, cookie, userAgent, null, files);
    }

    public static String httpPostforString(String url, String cookie, String userAgent, Map<String, Object> params, Map<String, File> files) throws Exception {
        return HttpRequestUtil.httpPostFileforString("default", url, cookie, userAgent, params, files);
    }

    public static String httpPostFileforString(String poolname, String url, String cookie, String userAgent, Map<String, Object> params, Map<String, File> files) throws Exception {
        return HttpRequestUtil.httpPostFileforString(poolname, url, cookie, userAgent, params, files, null);
    }

    public static <T> T httpPost(String poolname, String url, String cookie, String userAgent, Map<String, Object> params, Map<String, File> files, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        int i;
        HttpClient httpClient = null;
        HttpPost httpPost = null;
        HttpEntity httpEntity = null;
        ArrayList<BasicNameValuePair> paramPair = null;
        if (files != null) {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            int length = (params == null ? 0 : params.size()) + (files == null ? 0 : files.size());
            i = 0;
            boolean hasdata = false;
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    multipartEntityBuilder.addTextBody(entry.getKey(), String.valueOf(entry.getValue()), ClientConfiguration.TEXT_PLAIN_UTF_8);
                    hasdata = true;
                }
            }
            if (files != null) {
                for (Map.Entry<String, Object> entry : files.entrySet()) {
                    File f = new File(String.valueOf(entry.getValue()));
                    if (!f.exists()) continue;
                    FileBody file = new FileBody(f);
                    multipartEntityBuilder.addPart(entry.getKey(), (ContentBody)file);
                    hasdata = true;
                }
            }
            if (hasdata) {
                httpEntity = multipartEntityBuilder.build();
            }
        } else if (params != null && params.size() > 0) {
            paramPair = new ArrayList<BasicNameValuePair>();
            Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
            BasicNameValuePair paramPair_ = null;
            i = 0;
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                paramPair_ = new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue()));
                paramPair.add(paramPair_);
                ++i;
            }
        }
        Object responseBody = null;
        ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
        try {
            httpClient = HttpRequestUtil.getHttpClient(config);
            httpPost = HttpRequestUtil.getHttpPost(config, url, cookie, userAgent, headers);
            if (httpEntity != null) {
                httpPost.setEntity(httpEntity);
            } else if (paramPair != null && paramPair.size() > 0) {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramPair, Consts.UTF_8);
                httpPost.setEntity((HttpEntity)entity);
            }
            if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                ((URLResponseHandler)responseHandler).setUrl(url);
            }
            responseBody = httpClient.execute((HttpUriRequest)httpPost, responseHandler);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            httpClient = null;
        }
        return (T)responseBody;
    }

    public static String httpPutforString(String poolname, String url, String cookie, String userAgent, Map<String, Object> params, Map<String, File> files, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpPut(poolname, url, cookie, userAgent, params, files, headers, new StringResponseHandler());
    }

    public static String httpPutforString(String url, Map<String, Object> params, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpPut("default", url, null, null, params, null, headers, new StringResponseHandler());
    }

    public static <T> T httpPutforString(String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpPut("default", url, null, null, params, null, headers, responseHandler);
    }

    public static String httpPutforString(String poolname, String url, Map<String, Object> params, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpPut(poolname, url, null, null, params, null, headers, new StringResponseHandler());
    }

    public static <T> T httpPutforString(String poolname, String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpPut(poolname, url, null, null, params, null, headers, responseHandler);
    }

    public static <T> T httpPut(String url, String cookie, String userAgent, Map<String, Object> params, Map<String, File> files, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpPut("default", url, cookie, userAgent, params, files, headers, responseHandler);
    }

    public static <T> T httpPut(String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpPut(url, null, null, params, null, headers, responseHandler);
    }

    public static <T> T httpPut(String url, Map<String, Object> params, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpPut(url, null, null, params, null, null, responseHandler);
    }

    public static <T> T httpPut(String url, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpPut(url, null, null, null, null, null, responseHandler);
    }

    public static <T> T httpPut(String poolname, String url, String cookie, String userAgent, Map<String, Object> params, Map<String, File> files, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        int i;
        HttpClient httpClient = null;
        HttpPut httpPut = null;
        HttpEntity httpEntity = null;
        ArrayList<BasicNameValuePair> paramPair = null;
        if (files != null) {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            int length = (params == null ? 0 : params.size()) + (files == null ? 0 : files.size());
            i = 0;
            boolean hasdata = false;
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    multipartEntityBuilder.addTextBody(entry.getKey(), String.valueOf(entry.getValue()), ClientConfiguration.TEXT_PLAIN_UTF_8);
                    hasdata = true;
                }
            }
            if (files != null) {
                for (Map.Entry<String, Object> entry : files.entrySet()) {
                    File f = new File(String.valueOf(entry.getValue()));
                    if (!f.exists()) continue;
                    FileBody file = new FileBody(f);
                    multipartEntityBuilder.addPart(entry.getKey(), (ContentBody)file);
                    hasdata = true;
                }
            }
            if (hasdata) {
                httpEntity = multipartEntityBuilder.build();
            }
        } else if (params != null && params.size() > 0) {
            paramPair = new ArrayList<BasicNameValuePair>();
            Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
            BasicNameValuePair paramPair_ = null;
            i = 0;
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                paramPair_ = new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue()));
                paramPair.add(paramPair_);
                ++i;
            }
        }
        Object responseBody = null;
        ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
        try {
            httpClient = HttpRequestUtil.getHttpClient(config);
            httpPut = HttpRequestUtil.getHttpPut(config, url, cookie, userAgent, headers);
            if (httpEntity != null) {
                httpPut.setEntity(httpEntity);
            } else if (paramPair != null && paramPair.size() > 0) {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramPair, Consts.UTF_8);
                httpPut.setEntity((HttpEntity)entity);
            }
            if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                ((URLResponseHandler)responseHandler).setUrl(url);
            }
            responseBody = httpClient.execute((HttpUriRequest)httpPut, responseHandler);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (httpPut != null) {
                httpPut.releaseConnection();
            }
            httpClient = null;
        }
        return (T)responseBody;
    }

    public static String httpPostFileforString(String poolname, String url, String cookie, String userAgent, Map<String, Object> params, Map<String, File> files, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpPost(poolname, url, cookie, userAgent, params, files, headers, new StringResponseHandler());
    }

    public static String httpDelete(String poolname, String url) throws Exception {
        return HttpRequestUtil.httpDelete(poolname, url, (String)null, (String)null, (Map<String, Object>)null, (Map<String, String>)null);
    }

    public static String httpDelete(String url) throws Exception {
        return HttpRequestUtil.httpDelete("default", url, (String)null, (String)null, (Map<String, Object>)null, (Map<String, String>)null);
    }

    public static String httpDeleteWithbody(String url, String requestBody) throws Exception {
        return HttpRequestUtil.httpDelete("default", url, requestBody, null, null, null, null);
    }

    public static String httpDelete(String url, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpDelete("default", url, (String)null, (String)null, (Map<String, Object>)null, headers);
    }

    public static String httpDelete(String url, String requestBody, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpDelete("default", url, requestBody, null, null, null, headers);
    }

    public static String httpDeleteWithbody(String url, String requestBody, Map<String, Object> params, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpDelete("default", url, requestBody, null, null, params, headers);
    }

    public static String httpDelete(String url, Map<String, Object> params, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpDelete("default", url, (String)null, (String)null, params, headers);
    }

    public static <T> T httpDelete(String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpDelete("default", url, null, null, null, params, headers, responseHandler);
    }

    public static <T> T httpDeleteWithBody(String url, String requestBody, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpDelete("default", url, requestBody, null, null, params, headers, responseHandler);
    }

    public static String httpDelete(String poolname, String url, Map<String, Object> params, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpDelete(poolname, url, (String)null, (String)null, params, headers);
    }

    public static String httpDelete(String poolname, String url, String requestBody, Map<String, Object> params, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpDelete(poolname, url, requestBody, null, null, params, headers);
    }

    public static <T> T httpDelete(String poolname, String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpDelete(poolname, url, null, null, null, params, headers, responseHandler);
    }

    public static <T> T httpDelete(String poolname, String url, String requestBody, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.httpDelete(poolname, url, requestBody, null, null, params, headers, responseHandler);
    }

    public static String httpDelete(String poolname, String url, String cookie, String userAgent, Map<String, Object> params, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpDelete(poolname, url, null, cookie, userAgent, params, headers, new StringResponseHandler());
    }

    public static String httpDelete(String poolname, String url, String requestBody, String cookie, String userAgent, Map<String, Object> params, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.httpDelete(poolname, url, requestBody, cookie, userAgent, params, headers, new StringResponseHandler());
    }

    public static <T> T httpDelete(String poolname, String url, String requestBody, String cookie, String userAgent, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        HttpClient httpClient = null;
        HttpDeleteWithBody httpDeleteWithBody = null;
        HttpDelete httpDelete = null;
        Object responseBody = null;
        ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
        StringEntity httpEntity = requestBody == null ? null : new StringEntity(requestBody, ContentType.APPLICATION_JSON);
        try {
            httpClient = HttpRequestUtil.getHttpClient(config);
            BasicHttpParams httpParams = null;
            if (params != null && params.size() > 0) {
                httpParams = new BasicHttpParams();
                Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
                Object paramPair_ = null;
                int i = 0;
                while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    httpParams.setParameter(entry.getKey(), entry.getValue());
                    ++i;
                }
            }
            if (httpEntity != null) {
                httpDeleteWithBody = HttpRequestUtil.getHttpDeleteWithBody(config, url, cookie, userAgent, headers);
                httpDeleteWithBody.setEntity((HttpEntity)httpEntity);
                if (httpParams != null) {
                    httpDeleteWithBody.setParams((HttpParams)httpParams);
                }
                if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                    ((URLResponseHandler)responseHandler).setUrl(url);
                }
                responseBody = httpClient.execute((HttpUriRequest)httpDeleteWithBody, responseHandler);
            } else {
                httpDelete = HttpRequestUtil.getHttpDelete(config, url, cookie, userAgent, headers);
                if (httpParams != null) {
                    httpDelete.setParams((HttpParams)httpParams);
                }
                if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                    ((URLResponseHandler)responseHandler).setUrl(url);
                }
                responseBody = httpClient.execute((HttpUriRequest)httpDelete, responseHandler);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (httpDelete != null) {
                httpDelete.releaseConnection();
            }
            httpClient = null;
        }
        return (T)responseBody;
    }

    public static String sendStringBody(String poolname, String requestBody, String url, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.sendBody(poolname, requestBody, url, headers, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
    }

    public static String sendJsonBody(String poolname, String requestBody, String url) throws Exception {
        return HttpRequestUtil.sendBody(poolname, requestBody, url, null, ContentType.APPLICATION_JSON);
    }

    public static String object2json(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            return (String)data;
        }
        return SimpleStringUtil.object2json((Object)data);
    }

    public static String sendJsonBody(String poolname, Object requestBody, String url) throws Exception {
        return HttpRequestUtil.sendBody(poolname, HttpRequestUtil.object2json(requestBody), url, null, ContentType.APPLICATION_JSON);
    }

    public static String sendStringBody(String poolname, String requestBody, String url) throws Exception {
        return HttpRequestUtil.sendBody(poolname, requestBody, url, null, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
    }

    public static String sendJsonBody(String poolname, Object requestBody, String url, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.sendBody(poolname, HttpRequestUtil.object2json(requestBody), url, headers, ContentType.APPLICATION_JSON);
    }

    public static String sendJsonBody(String poolname, String requestBody, String url, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.sendBody(poolname, requestBody, url, headers, ContentType.APPLICATION_JSON);
    }

    public static String sendStringBody(String requestBody, String url, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.sendBody("default", requestBody, url, headers, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
    }

    public static String sendJsonBody(String requestBody, String url) throws Exception {
        return HttpRequestUtil.sendBody("default", requestBody, url, null, ContentType.APPLICATION_JSON);
    }

    public static String sendJsonBody(Object requestBody, String url) throws Exception {
        return HttpRequestUtil.sendBody("default", HttpRequestUtil.object2json(requestBody), url, null, ContentType.APPLICATION_JSON);
    }

    public static String sendStringBody(String requestBody, String url) throws Exception {
        return HttpRequestUtil.sendBody("default", requestBody, url, null, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
    }

    public static String sendStringBody(String requestBody, String url, String mimeType, Charset charSet) throws Exception {
        return HttpRequestUtil.sendBody("default", requestBody, url, null, ContentType.create((String)mimeType, (Charset)charSet));
    }

    public static String sendJsonBody(String requestBody, String url, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.sendBody("default", requestBody, url, headers, ContentType.APPLICATION_JSON);
    }

    public static <T> T sendJsonBody(String requestBody, String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.sendBody("default", requestBody, url, headers, ContentType.APPLICATION_JSON, responseHandler);
    }

    public static <T> T sendJsonBody(String poolname, String requestBody, String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.sendBody(poolname, requestBody, url, headers, ContentType.APPLICATION_JSON, responseHandler);
    }

    public static <T> T sendBody(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType, ResponseHandler<T> responseHandler) throws Exception {
        HttpClient httpClient = null;
        HttpPost httpPost = null;
        StringEntity httpEntity = new StringEntity(requestBody, contentType);
        ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
        Object responseBody = null;
        try {
            httpClient = HttpRequestUtil.getHttpClient(config);
            httpPost = HttpRequestUtil.getHttpPost(config, url, "", "", headers);
            if (httpEntity != null) {
                httpPost.setEntity((HttpEntity)httpEntity);
            }
            if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                ((URLResponseHandler)responseHandler).setUrl(url);
            }
            responseBody = httpClient.execute((HttpUriRequest)httpPost, responseHandler);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            httpClient = null;
        }
        return (T)responseBody;
    }

    private static HttpRequestBase getHttpEntityEnclosingRequestBase(String action, ClientConfiguration config, String url, Map<String, String> headers) {
        if (action.equals(HTTP_POST)) {
            return HttpRequestUtil.getHttpPost(config, url, null, null, headers);
        }
        if (action.equals(HTTP_GET)) {
            return HttpRequestUtil.getHttpGet(config, url, null, null, headers);
        }
        if (action.equals(HTTP_PUT)) {
            return HttpRequestUtil.getHttpPut(config, url, null, null, headers);
        }
        if (action.equals(HTTP_DELETE)) {
            return HttpRequestUtil.getHttpDelete(config, url, null, null, headers);
        }
        if (action.equals(HTTP_HEAD)) {
            return HttpRequestUtil.getHttpHead(config, url, null, null, headers);
        }
        if (action.equals(HTTP_TRACE)) {
            return HttpRequestUtil.getHttpTrace(config, url, null, null, headers);
        }
        if (action.equals(HTTP_OPTIONS)) {
            return HttpRequestUtil.getHttpOptions(config, url, null, null, headers);
        }
        if (action.equals(HTTP_PATCH)) {
            return HttpRequestUtil.getHttpPatch(config, url, null, null, headers);
        }
        throw new IllegalArgumentException("not support http action:" + action);
    }

    public static <T> T sendBody(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType, ResponseHandler<T> responseHandler, String action) throws Exception {
        HttpClient httpClient = null;
        HttpEntityEnclosingRequestBase httpPost = null;
        StringEntity httpEntity = requestBody != null ? new StringEntity(requestBody, contentType) : null;
        ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
        Object responseBody = null;
        try {
            httpClient = HttpRequestUtil.getHttpClient(config);
            httpPost = (HttpEntityEnclosingRequestBase)HttpRequestUtil.getHttpEntityEnclosingRequestBase(action, config, url, headers);
            if (httpEntity != null) {
                httpPost.setEntity((HttpEntity)httpEntity);
            }
            if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                ((URLResponseHandler)responseHandler).setUrl(url);
            }
            responseBody = httpClient.execute((HttpUriRequest)httpPost, responseHandler);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            httpClient = null;
        }
        return (T)responseBody;
    }

    public static String sendBody(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType) throws Exception {
        return HttpRequestUtil.sendBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("SendBody Request url:" + this.url + ",status:" + status);
                    }
                    throw new HttpProxyRequestException(EntityUtils.toString((HttpEntity)entity));
                }
                throw new HttpProxyRequestException("SendBody request url:" + this.url + ",Unexpected response status: " + status);
            }
        });
    }

    public static <T> T putBody(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType, ResponseHandler<T> responseHandler) throws Exception {
        HttpClient httpClient = null;
        HttpPut httpPost = null;
        StringEntity httpEntity = new StringEntity(requestBody, contentType);
        ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
        Object responseBody = null;
        try {
            httpClient = HttpRequestUtil.getHttpClient(config);
            httpPost = HttpRequestUtil.getHttpPut(config, url, "", "", headers);
            if (httpEntity != null) {
                httpPost.setEntity((HttpEntity)httpEntity);
            }
            if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                ((URLResponseHandler)responseHandler).setUrl(url);
            }
            responseBody = httpClient.execute((HttpUriRequest)httpPost, responseHandler);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            httpClient = null;
        }
        return (T)responseBody;
    }

    public static String putBody(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType) throws Exception {
        return HttpRequestUtil.putBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Put Body Request url:" + this.url + ",status:" + status);
                    }
                    throw new HttpProxyRequestException(EntityUtils.toString((HttpEntity)entity));
                }
                throw new HttpProxyRequestException("PutBody request url:" + this.url + ",Unexpected response status: " + status);
            }
        });
    }

    public static <T> T putBody(String requestBody, String url, Map<String, String> headers, ContentType contentType, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.putBody("default", requestBody, url, headers, contentType, responseHandler);
    }

    public static String putBody(String requestBody, String url, Map<String, String> headers, ContentType contentType) throws Exception {
        return HttpRequestUtil.putBody("default", requestBody, url, headers, contentType);
    }

    public static <T> T putJson(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.putJson(poolname, requestBody, url, headers, ContentType.APPLICATION_JSON, responseHandler);
    }

    public static String putJson(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType) throws Exception {
        return HttpRequestUtil.putJson(poolname, requestBody, url, headers, ContentType.APPLICATION_JSON);
    }

    public static <T> T putJson(String requestBody, String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.putBody("default", requestBody, url, headers, ContentType.APPLICATION_JSON, responseHandler);
    }

    public static <T> T putJson(String poolName, String requestBody, String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws Exception {
        return HttpRequestUtil.putBody(poolName, requestBody, url, headers, ContentType.APPLICATION_JSON, responseHandler);
    }

    public static String putJson(String requestBody, String url, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.putBody("default", requestBody, url, headers, ContentType.APPLICATION_JSON);
    }

    public static String putJson(String poolName, String requestBody, String url, Map<String, String> headers) throws Exception {
        return HttpRequestUtil.putBody(poolName, requestBody, url, headers, ContentType.APPLICATION_JSON);
    }
}

