/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.proxy;

import java.util.List;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.HttpHost;
import org.frameworkset.spi.remote.http.proxy.DefaultHttpHostDiscover;
import org.frameworkset.spi.remote.http.proxy.HttpHostDiscover;
import org.frameworkset.spi.remote.http.proxy.HttpServiceHosts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpProxyUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void changeRouting(String poolName, String newCurrentRounte) {
        if (newCurrentRounte == null) {
            return;
        }
        if (poolName == null) {
            poolName = "default";
        }
        try {
            ClientConfiguration clientConfiguration = ClientConfiguration.getClientConfiguration(poolName);
            if (clientConfiguration == null) return;
            HttpHostDiscover httpHostDiscover = null;
            HttpServiceHosts httpServiceHosts = clientConfiguration.getHttpServiceHosts();
            httpHostDiscover = httpServiceHosts.getHostDiscover();
            if (httpHostDiscover == null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Registry default HttpHostDiscover to httppool[{}]", (Object)poolName);
                }
                Class<HttpProxyUtil> clazz = HttpProxyUtil.class;
                // MONITORENTER : org.frameworkset.spi.remote.http.proxy.HttpProxyUtil.class
                httpHostDiscover = httpServiceHosts.getHostDiscover();
                if (httpHostDiscover == null) {
                    httpHostDiscover = new DefaultHttpHostDiscover();
                    httpHostDiscover.setHttpServiceHosts(httpServiceHosts);
                    httpServiceHosts.setHostDiscover(httpHostDiscover);
                }
                // MONITOREXIT : clazz
            }
            if (httpHostDiscover == null) return;
            httpHostDiscover.changeRouting(newCurrentRounte);
            return;
        }
        catch (Exception e) {
            if (!logger.isInfoEnabled()) return;
            logger.info("Change Routing " + poolName + ", new routing[" + newCurrentRounte + "]  failed:", (Throwable)e);
        }
    }

    public static void handleDiscoverHosts(String poolName, List<HttpHost> hosts) {
        HttpProxyUtil.handleDiscoverHosts(poolName, hosts, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void handleDiscoverHosts(String poolName, List<HttpHost> hosts, String newCurrentRounte) {
        if (poolName == null) {
            poolName = "default";
        }
        try {
            ClientConfiguration clientConfiguration = ClientConfiguration.getClientConfiguration(poolName);
            if (clientConfiguration == null) return;
            HttpHostDiscover httpHostDiscover = null;
            HttpServiceHosts httpServiceHosts = clientConfiguration.getHttpServiceHosts();
            if (httpServiceHosts == null) return;
            httpHostDiscover = httpServiceHosts.getHostDiscover();
            if (httpHostDiscover == null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Registry default HttpHostDiscover to httppool[{}]", (Object)poolName);
                }
                Class<HttpProxyUtil> clazz = HttpProxyUtil.class;
                // MONITORENTER : org.frameworkset.spi.remote.http.proxy.HttpProxyUtil.class
                httpHostDiscover = httpServiceHosts.getHostDiscover();
                if (httpHostDiscover == null) {
                    httpHostDiscover = new DefaultHttpHostDiscover();
                    httpHostDiscover.setHttpServiceHosts(httpServiceHosts);
                    httpServiceHosts.setHostDiscover(httpHostDiscover);
                }
                // MONITOREXIT : clazz
            }
            if (httpHostDiscover == null) return;
            if (hosts == null || hosts.size() == 0) {
                Boolean handleNullOrEmptyHostsByDiscovery = httpHostDiscover.handleNullOrEmptyHostsByDiscovery();
                if (handleNullOrEmptyHostsByDiscovery == null) {
                    handleNullOrEmptyHostsByDiscovery = httpServiceHosts.getHandleNullOrEmptyHostsByDiscovery();
                }
                if (handleNullOrEmptyHostsByDiscovery == null || !handleNullOrEmptyHostsByDiscovery.booleanValue()) {
                    if (!logger.isInfoEnabled()) return;
                    logger.info("Discovery " + httpServiceHosts.getClientConfiguration().getBeanName() + " servers : ignore with httpHosts == null || httpHosts.size() == 0");
                    return;
                }
            }
            httpHostDiscover.handleDiscoverHosts(hosts, newCurrentRounte);
            return;
        }
        catch (Exception e) {
            if (!logger.isInfoEnabled()) return;
            StringBuilder message = new StringBuilder();
            if (newCurrentRounte != null) {
                message.append("Change Routing ").append(poolName).append(", new routing[").append(newCurrentRounte).append("] and ");
            }
            message.append("Discovery ").append(poolName).append(" servers failed:");
            logger.info(message.toString(), (Throwable)e);
        }
    }
}

