/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import com.frameworkset.util.ResourceInitial;
import com.frameworkset.util.UUIDResource;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonThread
extends Thread {
    private static Logger log = LoggerFactory.getLogger(DaemonThread.class);
    private long refresh_interval = 5000L;
    private Map<String, FileBean> files = new HashMap<String, FileBean>();
    private boolean started = false;
    private boolean stopped = false;
    public static Boolean isWindow = null;
    private Object lock = new Object();

    public DaemonThread(String fileName, ResourceInitial init) {
        this(fileName, 5000L, init);
    }

    public DaemonThread(long refresh_interval, String name) {
        super(name);
        this.refresh_interval = refresh_interval;
        this.setDaemon(true);
    }

    public void addFile(String fileName, ResourceInitial init) {
        block4: {
            if (this.stopped || fileName == null) {
                return;
            }
            try {
                URL confURL;
                File file = new File(fileName);
                if (!file.exists() && (confURL = ResourceInitial.class.getClassLoader().getResource(fileName)) != null) {
                    file = new File(confURL.getPath());
                }
                this.addFile(file, fileName, init);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error("addFile file to monitor Thread failed,fileName:" + fileName, (Throwable)e);
            }
        }
    }

    private FileBean containFile(File file, String fileName) {
        if (this.files == null || this.files.size() <= 0) {
            return null;
        }
        if (file == null) {
            return null;
        }
        FileBean f = this.files.get(file.getAbsolutePath());
        if (f == null) {
            return null;
        }
        if (f.isRemoveflag()) {
            f.setRemoveflag(false);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File file, String fileName, ResourceInitial init) {
        block11: {
            if (this.stopped || file == null) {
                return;
            }
            if (!file.exists()) {
                if (log.isInfoEnabled()) {
                    log.info(fileName + "@" + file.getAbsolutePath() + " \u5bf9\u5e94\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u4fee\u6539\u68c0\u6d4b.");
                }
                return;
            }
            try {
                Object object = this.lock;
                synchronized (object) {
                    FileBean f = this.containFile(file, fileName);
                    if (f == null) {
                        this.files.put(file.getAbsolutePath(), new FileBean(file, new WrapperResourceInit(init, fileName)));
                    } else {
                        f.addResourceInit(new WrapperResourceInit(init, fileName));
                    }
                    if (log.isInfoEnabled()) {
                        log.info("Add file " + fileName + "@" + file.getAbsolutePath() + " to monitor thread that moniting changed files.");
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block11;
                log.error("Add file " + fileName + "@" + file.getAbsolutePath() + " to monitor thread that moniting changed files failed:", (Throwable)e);
            }
        }
    }

    public static final String getOS() {
        String osname = System.getProperty("os.name");
        return osname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isWindows() {
        if (isWindow != null) {
            return isWindow;
        }
        Class<DaemonThread> clazz = DaemonThread.class;
        synchronized (DaemonThread.class) {
            if (isWindow != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return isWindow;
            }
            isWindow = DaemonThread.getOS().startsWith("Windows");
            // ** MonitorExit[var0] (shouldn't be in output)
            return isWindow;
        }
    }

    public void addFile(File file, ResourceInitial init) {
        if (this.stopped || file == null) {
            return;
        }
        String fileName = file.getAbsolutePath();
        this.addFile(file, fileName, init);
    }

    public void addFile(URL fileURL, String fileName, ResourceInitial init) {
        block9: {
            if (this.stopped) {
                return;
            }
            if (fileName == null) {
                log.info("Ignore addFile Null file to change monitor Thread:fileName:" + fileName + ",fileURL:" + fileURL);
                return;
            }
            try {
                File file = new File(fileName);
                if (!file.exists() && fileURL != null) {
                    int idx;
                    String fileUrl = fileURL.getPath();
                    if (log.isInfoEnabled()) {
                        log.info("Use out package file URL to monitor: " + fileUrl);
                    }
                    if (!(file = new File(fileUrl)).exists() && (idx = fileUrl.indexOf("!")) > 0) {
                        if ((idx = (fileUrl = fileUrl.substring(0, idx)).indexOf("file:")) == -1) {
                            idx = fileUrl.indexOf("file:");
                        }
                        if (idx >= 0) {
                            fileUrl = DaemonThread.isWindows() ? fileUrl.substring(idx + 6) : fileUrl.substring(idx + 5);
                        }
                        file = new File(fileUrl);
                    }
                }
                this.addFile(file, fileName, init);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error("addFile file to monitor Thread failed,fileName:" + fileName + ",fileURL:" + fileURL, (Throwable)e);
            }
        }
    }

    public void removeFile(String filepath) {
        URL confURL;
        File file = new File(filepath);
        if (!file.exists() && (confURL = ResourceInitial.class.getClassLoader().getResource(filepath)) != null) {
            file = new File(confURL.getPath());
        }
        this.removeFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(File file) {
        Object object = this.lock;
        synchronized (object) {
            if (this.files == null || this.files.size() <= 0) {
                return;
            }
            if (file == null) {
                return;
            }
            FileBean f = this.files.get(file.getAbsolutePath());
            if (f != null) {
                f.setRemoveflag(true);
                if (log.isInfoEnabled()) {
                    log.info("marked  file " + file.getAbsolutePath() + " to be removed from monitor thread that moniting changed files.");
                }
            }
        }
    }

    public DaemonThread(String fileName, long refresh_interval, ResourceInitial init) {
        super(fileName);
        URL confURL;
        this.refresh_interval = refresh_interval > 0L ? refresh_interval : 10000L;
        File file = new File(fileName);
        if (!file.exists() && (confURL = ResourceInitial.class.getClassLoader().getResource(fileName)) != null) {
            file = new File(confURL.getPath());
        }
        if (!file.exists()) {
            if (log.isInfoEnabled()) {
                log.info(file.getAbsolutePath() + " \u5bf9\u5e94\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u4fee\u6539\u68c0\u6d4b.");
            }
            return;
        }
        this.files.put(file.getAbsolutePath(), new FileBean(file, new WrapperResourceInit(init, file.getAbsolutePath())));
        if (log.isInfoEnabled()) {
            log.info("Add file " + file.getAbsolutePath() + " to monitor thread that moniting changed files.");
        }
        this.setDaemon(true);
    }

    public DaemonThread(File file, ResourceInitial init) {
        this.files.put(file.getAbsolutePath(), new FileBean(file, new WrapperResourceInit(init, file.getAbsolutePath())));
        if (log.isInfoEnabled()) {
            log.info("Add file " + file.getAbsolutePath() + " to monitor thread that moniting changed files.");
        }
        this.setDaemon(true);
    }

    public boolean started() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (log.isInfoEnabled()) {
            log.info("Start check files is changed or not.if some files is changed,the resources of these files will be refreshed use ResourceInit interface.");
        }
        this.started = true;
        block11: while (!this.stopped) {
            try {
                DaemonThread.sleep(this.refresh_interval);
            }
            catch (InterruptedException ex) {
                break;
            }
            if (this.files == null || this.files.size() == 0) {
                if (!log.isTraceEnabled()) continue;
                String tname = this.getName() != null ? this.getName() : "null";
                log.trace("Thread[" + tname + "] Ignore Monitor change Files : No file to be monitor.");
                continue;
            }
            ArrayList<FileBean> changedFiles = new ArrayList<FileBean>();
            Iterator iterator = this.lock;
            synchronized (iterator) {
                block18: {
                    try {
                        Iterator<Map.Entry<String, FileBean>> entries = this.files.entrySet().iterator();
                        while (entries.hasNext() && !this.stopped) {
                            Map.Entry<String, FileBean> entry = entries.next();
                            FileBean f = entry.getValue();
                            if (f.isRemoveflag()) continue;
                            try {
                                String filePath;
                                if (log.isTraceEnabled()) {
                                    filePath = f.getFile() != null ? f.getFile().getAbsolutePath() : "";
                                    log.trace("Thread[" + this.getName() + "] Check file[" + filePath + "] .");
                                }
                                if (!f.checkChanged()) continue;
                                if (log.isInfoEnabled()) {
                                    filePath = f.getFile() != null ? f.getFile().getAbsolutePath() : "";
                                    log.info("Thread[" + this.getName() + "] Monitor file[" + filePath + "] changed.");
                                }
                                changedFiles.add(f);
                            }
                            catch (Exception e) {
                                if (!log.isInfoEnabled()) continue;
                                String filePath = f.getFile() != null ? f.getFile().getAbsolutePath() : "null";
                                String tname = this.getName() != null ? this.getName() : "null";
                                log.info("Thread[" + tname + "] Monitor changed file[" + filePath + "] exception:", (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!log.isInfoEnabled()) break block18;
                        log.info("Thread[" + this.getName() + "] Monitor changed files exception:", (Throwable)e);
                    }
                }
            }
            if (changedFiles.size() <= 0) continue;
            for (FileBean f : changedFiles) {
                if (this.stopped) continue block11;
                try {
                    f.reinit();
                }
                catch (Exception e) {
                    if (!log.isInfoEnabled()) continue;
                    String filePath = f.getFile() != null ? f.getFile().getAbsolutePath() : "null";
                    String tname = this.getName() != null ? this.getName() : "null";
                    log.info("Thread[" + tname + "] Reinit Monitor changed file[" + filePath + "] exception:", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.files != null) {
                this.files.clear();
            }
            this.lock.notifyAll();
        }
    }

    static class FileBean {
        private boolean removeflag = false;
        private File file;
        private long oldModifiedTime;
        private List<WrapperResourceInit> inits;

        public FileBean(File file, WrapperResourceInit init) {
            this.file = file;
            this.inits = new ArrayList<WrapperResourceInit>();
            this.inits.add(init);
            this.oldModifiedTime = file.lastModified();
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public long getOldModifiedTime() {
            return this.oldModifiedTime;
        }

        public void setOldModifiedTime(long oldModifiedTime) {
            this.oldModifiedTime = oldModifiedTime;
        }

        public boolean checkChanged() {
            if (this.file == null) {
                return false;
            }
            boolean exist = this.file.exists();
            if (!exist) {
                return false;
            }
            long lastModifiedTime = this.file.lastModified();
            return this.oldModifiedTime != lastModifiedTime;
        }

        public synchronized void reinit() {
            long length;
            long lastModifiedTime;
            if (log.isInfoEnabled()) {
                log.info("Reload resources in changed file\uff1a" + this.file.getAbsolutePath());
            }
            if ((lastModifiedTime = this.file.lastModified()) == this.oldModifiedTime) {
                return;
            }
            long last = length = this.file.length();
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                length = this.file.length();
                if (last == length) {
                    lastModifiedTime = this.file.lastModified();
                    break;
                }
                last = length;
            }
            this.oldModifiedTime = lastModifiedTime;
            for (int i = 0; this.inits != null && i < this.inits.size(); ++i) {
                WrapperResourceInit init = this.inits.get(i);
                try {
                    init.reinit();
                    if (!log.isInfoEnabled()) continue;
                    log.info("Reload changed resource file " + init.getUUID() + "@" + this.file.getAbsolutePath() + " sucessed.");
                    continue;
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error("Reload changed resource  file " + init.getUUID() + "@" + this.file.getAbsolutePath() + " failed:", (Throwable)e);
                }
            }
        }

        public boolean isRemoveflag() {
            return this.removeflag;
        }

        public void setRemoveflag(boolean removeflag) {
            this.removeflag = removeflag;
        }

        public void addResourceInit(WrapperResourceInit init) {
            if (!this.contain(init)) {
                this.inits.add(init);
            }
        }

        private boolean contain(ResourceInitial init) {
            if (init instanceof UUIDResource) {
                String uuid = ((UUIDResource)((Object)init)).getUUID();
                for (int i = 0; i < this.inits.size(); ++i) {
                    ResourceInitial initOld = this.inits.get(i);
                    if (!(initOld instanceof UUIDResource) || !((UUIDResource)((Object)initOld)).getUUID().equals(uuid)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    static class WrapperResourceInit
    implements ResourceInitial,
    UUIDResource {
        private ResourceInitial resourceInitial;
        private String fileName;

        public WrapperResourceInit(ResourceInitial resourceInitial, String fileName) {
            this.resourceInitial = resourceInitial;
            this.fileName = fileName;
        }

        @Override
        public void reinit() {
            this.resourceInitial.reinit();
        }

        @Override
        public String getUUID() {
            if (this.resourceInitial instanceof UUIDResource) {
                return ((UUIDResource)((Object)this.resourceInitial)).getUUID();
            }
            return this.fileName;
        }
    }
}

