/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.frameworkset.util.DataFormatUtil;

public class StringUtil {
    public static final String COMMA = ",";
    public static final String BLANK = "";

    public static String[] split(String s) {
        return StringUtil.split(s, COMMA);
    }

    public static String[] split(String s, String delimiter) {
        return s.split(delimiter);
    }

    public static String getRealPath(HttpServletRequest request, String path) {
        String contextPath = request.getContextPath();
        if (path == null) {
            return null;
        }
        if (path.startsWith("/") && !path.startsWith(contextPath + "/")) {
            return contextPath + path;
        }
        return path;
    }

    public static boolean containKey(String[] values, String key) {
        if (values == null || key == null) {
            return false;
        }
        boolean contain = false;
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(key)) continue;
            contain = true;
            break;
        }
        return contain;
    }

    public static String getFormatDate(Date date, String formate) {
        SimpleDateFormat dateFormat = DataFormatUtil.getSimpleDateFormat((String)formate);
        if (date == null) {
            return null;
        }
        return dateFormat.format(date);
    }

    public static Date stringToDate(String date) {
        if (date == null || date.trim().equals(BLANK)) {
            return null;
        }
        date = date.replace('-', '/');
        SimpleDateFormat format = new SimpleDateFormat();
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            return new Date(date);
        }
    }

    public static String getFileName(String path) {
        int index = path.lastIndexOf(47);
        String fileName = BLANK;
        if (index == -1) {
            index = path.lastIndexOf(92);
        }
        fileName = path.substring(index + 1);
        return fileName;
    }

    public static String getFileName(String prefix, String extension) throws UnsupportedEncodingException {
        String fileName = URLEncoder.encode(prefix, "UTF-8");
        int limit = 150 - extension.length();
        if (fileName.length() > limit) {
            fileName = URLEncoder.encode(prefix.substring(0, Math.min(prefix.length(), limit / 9)), "UTF-8");
        }
        return fileName + extension;
    }
}

