/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.frameworkset.util.BaseSimpleStringUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.frameworkset.json.DefaultJsonTypeReference;
import org.frameworkset.json.JacksonObjectMapperWrapper;
import org.frameworkset.json.JsonTypeReference;
import org.frameworkset.soa.BBossStringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStringUtil
extends BaseSimpleStringUtil {
    protected static final Logger logger = LoggerFactory.getLogger(SimpleStringUtil.class);
    private static JacksonObjectMapperWrapper objectMapper = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initJacksonObjectMapperWrapper() {
        if (objectMapper != null) return;
        Class<SimpleStringUtil> clazz = SimpleStringUtil.class;
        synchronized (SimpleStringUtil.class) {
            if (objectMapper != null) return;
            objectMapper = new JacksonObjectMapperWrapper();
            objectMapper.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static JacksonObjectMapperWrapper getJacksonObjectMapper() {
        SimpleStringUtil.initJacksonObjectMapperWrapper();
        return objectMapper;
    }

    public static String[] split(String s) {
        return SimpleStringUtil.split(s, ",");
    }

    public static String[] split(String s, String delimiter) {
        return SimpleStringUtil.split(s, delimiter, true);
    }

    public static String replaceAll(String val, String str1, String str2) {
        return SimpleStringUtil.replaceAll(val, str1, str2, true);
    }

    public static String replaceFirst(String val, String str1, String str2) {
        return SimpleStringUtil.replaceFirst(val, str1, str2, true);
    }

    public static String replaceFirst(String val, String str1, String str2, boolean CASE_INSENSITIVE) {
        String patternStr = str1;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = CASE_INSENSITIVE ? compiler.compile(patternStr, 0) : compiler.compile(patternStr, 1);
            Perl5Matcher matcher = new Perl5Matcher();
            return Util.substitute((PatternMatcher)matcher, (Pattern)pattern, (Substitution)new StringSubstitution(str2), (String)val);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return val;
        }
    }

    public static String replaceAll(String val, String str1, String str2, boolean CASE_INSENSITIVE) {
        String patternStr = str1;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = CASE_INSENSITIVE ? compiler.compile(patternStr, 0) : compiler.compile(patternStr, 1);
            Perl5Matcher matcher = new Perl5Matcher();
            return Util.substitute((PatternMatcher)matcher, (Pattern)pattern, (Substitution)new StringSubstitution(str2), (String)val, (int)-1);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return val;
        }
    }

    public static String replaceAll(String val, String str1, String str2, int mask) {
        String patternStr = str1;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, mask);
            Perl5Matcher matcher = new Perl5Matcher();
            return Util.substitute((PatternMatcher)matcher, (Pattern)pattern, (Substitution)new StringSubstitution(str2), (String)val, (int)-1);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return val;
        }
    }

    public static String[] split(String val, String token, boolean CASE_INSENSITIVE) {
        String patternStr = token;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = CASE_INSENSITIVE ? compiler.compile(patternStr, 0) : compiler.compile(patternStr, 1);
            Perl5Matcher matcher = new Perl5Matcher();
            ArrayList list = new ArrayList();
            SimpleStringUtil.split(list, (PatternMatcher)matcher, pattern, val, 0);
            String[] rets = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                rets[i] = (String)list.get(i);
            }
            return rets;
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return new String[]{val};
        }
    }

    public static String[] split(String val, String token, int mask) {
        String patternStr = token;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, mask);
            Perl5Matcher matcher = new Perl5Matcher();
            ArrayList list = new ArrayList();
            SimpleStringUtil.split(list, (PatternMatcher)matcher, pattern, val, 0);
            String[] rets = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                rets[i] = (String)list.get(i);
            }
            return rets;
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return new String[]{val};
        }
    }

    private static void split(Collection results, PatternMatcher matcher, Pattern pattern, String input, int limit) {
        PatternMatcherInput pinput = new PatternMatcherInput(input);
        int beginOffset = 0;
        while (--limit != 0 && matcher.contains(pinput, pattern)) {
            MatchResult currentResult = matcher.getMatch();
            results.add(input.substring(beginOffset, currentResult.beginOffset(0)));
            beginOffset = currentResult.endOffset(0);
        }
        results.add(input.substring(beginOffset, input.length()));
    }

    public static void main(String[] args) {
        int maxlength = 16;
        String replace = "...";
        String outStr = "2010\u5e7402\u670804\u65e512\u65f6\u8bb8\uff0c\u4f55\u91d1\u7476\uff08\u5973\u30011987\u5e7406\u670818\u65e5\u751f\u3001\u8eab\u4efd\u8bc1\uff1a430981198706184686\u3001\u6e56\u5357\u7701\u6c85\u6c5f\u5e02\u6c85\u6c5f\u5e02\u5357\u5927\u81b3\u9547\u5eb7\u5b81\u6751\u5341\u4e8c\u6751\u6c11\u7ec424\u53f7\uff09\u62a5\u8b66\uff1a\u5176\u7ecf\u8425\u7684\u76ca\u9633\u5e02\u7535\u4fe1\u5bf9\u9762\u7684\u6674\u5929\u670d\u88c5\u5e97\u88ab\u76d7\u4e86\u3002\u63a5\u8b66\u540e\u6211\u6240\u6c11\u8b66\u7acb\u5373\u8d76\u81f3\u73b0\u573a\u4e86\u89e3\u7cfb\uff0c\u4eca\u65e5\u4e2d\u534812\u65f6\u8bb8\u4f55\u91d1\u7476\u4e0e\u6bcd\u4eb2\u9ec4\u5fd7\u5143\u5728\u5e97\u5185\u505a\u751f\u610f\uff0c\u6709\u4e24\u7537\u5b50\u8fdb\u5165\u5e97\u5185\uff0c\u5176\u4e2d\u4e00\u7537\u5b50\u4ee5\u642c\u5e97\u5185\u7684\u8bd5\u8863\u955c\u51fa\u53bb\u5438\u5f15\u6ce8\u610f\u529b\u3002\u53e6\u4e00\u7537\u5b50\u5c31\u8fdb\u884c\u76d7\u7a83\uff0c\u76d7\u53d6\u4e86\u5176\u5e97\u5185\u6536\u94f6\u53f0\u62bd\u5c49\u5185700\u5143\u4eba\u6c11\u5e01";
        System.out.println(SimpleStringUtil.getHandleString(maxlength, replace, false, false, outStr));
        outStr = "2010\u5e7402\u670807\u65e511\u65f6\u8bb8\uff0c\u5468\u7075\u9896\u62a5\u8b66\uff1a\u57282\u8def\u516c\u4ea4\u8f66\u4e0a\u88ab\u6252\u7a83\uff0c\u5e76\u6293\u83b7\u4e00\u540d\u5acc\u7591\u4eba\u3002\u6c11\u8b66\u51fa\u8b66\u540e\uff0c\u7ecf\u8c03\u67e5\uff0c\u5468\u7075\u9896\u4e8e\u5f53\u65e510\u65f640\u5206\u8bb8\u57502\u8def\u8f66\u5230\u6865\u5357\uff0c\u9014\u4e2d\u88ab\u4e8c\u540d\u7537\u5b50\u6252\u7a83\u73b0\u91d13100\u5143\u3002\u4e00\u540d\u88ab\u5f53\u573a\u6293\u83b7\uff0c\u53e6\u4e00\u540d\u5df2\u9003\u8d70\u3002 ";
        System.out.println(SimpleStringUtil.getHandleString(maxlength, replace, false, false, outStr));
    }

    public static String HTMLEncode(String text) {
        if (SimpleStringUtil.isEmpty((String)text)) {
            return text;
        }
        text = SimpleStringUtil.replaceAll(text, "&", "&amp;");
        text = SimpleStringUtil.replaceAll(text, "\"", "&quot;");
        text = SimpleStringUtil.replaceAll(text, "<", "&lt;");
        text = SimpleStringUtil.replaceAll(text, ">", "&gt;");
        text = SimpleStringUtil.replaceAll(text, "'", "&#146;");
        text = SimpleStringUtil.replaceAll(text, "\\ ", "&nbsp;");
        text = SimpleStringUtil.replaceAll(text, "\n", "<br>");
        text = SimpleStringUtil.replaceAll(text, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        return text;
    }

    public static String HTMLNoBREncode(String text) {
        if (SimpleStringUtil.isEmpty((String)text)) {
            return text;
        }
        text = SimpleStringUtil.replaceAll(text, "&", "&amp;");
        text = SimpleStringUtil.replaceAll(text, "\"", "&quot;");
        text = SimpleStringUtil.replaceAll(text, "<", "&lt;");
        text = SimpleStringUtil.replaceAll(text, ">", "&gt;");
        text = SimpleStringUtil.replaceAll(text, "'", "&#146;");
        text = SimpleStringUtil.replaceAll(text, "\\ ", "&nbsp;");
        return text;
    }

    public static String HTMLEncodej(String text) {
        if (SimpleStringUtil.isEmpty((String)text)) {
            return text;
        }
        text = SimpleStringUtil.replaceAll(text, "&amp;", "&");
        text = SimpleStringUtil.replaceAll(text, "&quot;", "\"");
        text = SimpleStringUtil.replaceAll(text, "&lt;", "<");
        text = SimpleStringUtil.replaceAll(text, "&gt;", ">");
        text = SimpleStringUtil.replaceAll(text, "&#146;", "'");
        text = SimpleStringUtil.replaceAll(text, "&nbsp;", "\\ ");
        text = SimpleStringUtil.replaceAll(text, "<br>", "\n");
        text = SimpleStringUtil.replaceAll(text, "&nbsp;&nbsp;&nbsp;&nbsp;", "\t");
        return text;
    }

    public static String HTMLNoBREncodej(String text) {
        if (SimpleStringUtil.isEmpty((String)text)) {
            return text;
        }
        text = SimpleStringUtil.replaceAll(text, "&amp;", "&");
        text = SimpleStringUtil.replaceAll(text, "&quot;", "\"");
        text = SimpleStringUtil.replaceAll(text, "&lt;", "<");
        text = SimpleStringUtil.replaceAll(text, "&gt;", ">");
        text = SimpleStringUtil.replaceAll(text, "&#146;", "'");
        text = SimpleStringUtil.replaceAll(text, "&nbsp;", "\\ ");
        return text;
    }

    public static String getHandleString(int maxlength, String replace, boolean htmlencode, boolean htmldecode, String outStr) {
        if (maxlength > 0 && outStr != null && outStr.length() > maxlength) {
            outStr = outStr.substring(0, maxlength);
            if (replace != null) {
                outStr = outStr + replace;
            }
        }
        if (htmlencode) {
            return SimpleStringUtil.HTMLNoBREncode(outStr);
        }
        if (htmldecode) {
            return SimpleStringUtil.HTMLNoBREncodej(outStr);
        }
        return outStr;
    }

    public static <T> T json2Object(String jsonString, Class<T> toclass, boolean ALLOW_SINGLE_QUOTES) {
        return SimpleStringUtil.getJacksonObjectMapper().json2Object(jsonString, toclass, ALLOW_SINGLE_QUOTES);
    }

    public static <T> T json2ObjectWithType(String jsonString, JsonTypeReference<T> ref) {
        return SimpleStringUtil.json2ObjectWithType(jsonString, ref, true);
    }

    public static <T> List<T> json2ListObject(String jsonString, Class<T> beanType) {
        DefaultJsonTypeReference ref = new DefaultJsonTypeReference((Type)SimpleStringUtil.getJacksonObjectMapper().getJavaType(List.class, beanType));
        return (List)SimpleStringUtil.json2ObjectWithType(jsonString, ref, true);
    }

    public static <T> Set<T> json2LSetObject(String jsonString, Class<T> beanType) {
        DefaultJsonTypeReference ref = new DefaultJsonTypeReference((Type)SimpleStringUtil.getJacksonObjectMapper().getJavaType(Set.class, beanType));
        return (Set)SimpleStringUtil.json2ObjectWithType(jsonString, ref, true);
    }

    public static <T> T[] json2LArrayObject(String jsonString, Class<T> beanType) {
        DefaultJsonTypeReference ref = new DefaultJsonTypeReference((Type)SimpleStringUtil.getJacksonObjectMapper().getObjectMapper().getTypeFactory().constructArrayType(beanType));
        return (Object[])SimpleStringUtil.json2ObjectWithType(jsonString, ref, true);
    }

    public static ObjectMapper getObjectMapper() {
        return SimpleStringUtil.getJacksonObjectMapper().getObjectMapper();
    }

    public static <K, T> Map<K, T> json2LHashObject(String jsonString, Class<K> keyType, Class<T> beanType) {
        DefaultJsonTypeReference ref = new DefaultJsonTypeReference((Type)SimpleStringUtil.getJacksonObjectMapper().getJavaMapType(Map.class, keyType, beanType));
        return (Map)SimpleStringUtil.json2ObjectWithType(jsonString, ref, true);
    }

    public static <T> List<T> json2ListObject(InputStream jsonString, Class<T> beanType) {
        DefaultJsonTypeReference ref = new DefaultJsonTypeReference((Type)SimpleStringUtil.getJacksonObjectMapper().getJavaType(List.class, beanType));
        return (List)SimpleStringUtil.json2ObjectWithType(jsonString, ref, true);
    }

    public static <T> Set<T> json2LSetObject(InputStream jsonString, Class<T> beanType) {
        DefaultJsonTypeReference ref = new DefaultJsonTypeReference((Type)SimpleStringUtil.getJacksonObjectMapper().getJavaType(Set.class, beanType));
        return (Set)SimpleStringUtil.json2ObjectWithType(jsonString, ref, true);
    }

    public static <K, T> Map<K, T> json2LHashObject(InputStream jsonString, Class<K> keyType, Class<T> beanType) {
        DefaultJsonTypeReference ref = new DefaultJsonTypeReference((Type)SimpleStringUtil.getJacksonObjectMapper().getJavaMapType(Map.class, keyType, beanType));
        return (Map)SimpleStringUtil.json2ObjectWithType(jsonString, ref, true);
    }

    public static <T> T[] json2LArrayObject(InputStream jsonString, Class<T> beanType) {
        DefaultJsonTypeReference ref = new DefaultJsonTypeReference((Type)SimpleStringUtil.getJacksonObjectMapper().getObjectMapper().getTypeFactory().constructArrayType(beanType));
        return (Object[])SimpleStringUtil.json2ObjectWithType(jsonString, ref, true);
    }

    public static <T> T json2ObjectWithType(InputStream json, JsonTypeReference<T> ref) {
        return SimpleStringUtil.json2ObjectWithType(json, ref, true);
    }

    public static <T> T json2ObjectWithType(String jsonString, JsonTypeReference<T> ref, boolean ALLOW_SINGLE_QUOTES) {
        return SimpleStringUtil.getJacksonObjectMapper().json2ObjectWithType(jsonString, ref, ALLOW_SINGLE_QUOTES);
    }

    public static <T> T json2ObjectWithType(InputStream json, JsonTypeReference<T> ref, boolean ALLOW_SINGLE_QUOTES) {
        return SimpleStringUtil.getJacksonObjectMapper().json2ObjectWithType(json, ref, ALLOW_SINGLE_QUOTES);
    }

    public static <T> T json2Object(String jsonString, Class<T> toclass) {
        return SimpleStringUtil.getJacksonObjectMapper().json2Object(jsonString, toclass, true);
    }

    public static <T> T json2Object(InputStream jsonString, Class<T> toclass) {
        return SimpleStringUtil.getJacksonObjectMapper().json2Object(jsonString, toclass, true);
    }

    public static String object2json(Object object, boolean ALLOW_SINGLE_QUOTES) {
        return SimpleStringUtil.getJacksonObjectMapper().object2json(object, ALLOW_SINGLE_QUOTES);
    }

    public static String object2json(Object object) {
        return SimpleStringUtil.object2json(object, true);
    }

    public static void object2json(Object object, Writer writer, boolean ALLOW_SINGLE_QUOTES) {
        SimpleStringUtil.getJacksonObjectMapper().object2json(object, writer, ALLOW_SINGLE_QUOTES);
    }

    public static void object2json(Object object, Writer writer) {
        SimpleStringUtil.getJacksonObjectMapper().object2json(object, writer, true);
    }

    public static void object2json(Object object, StringBuilder builder) {
        BBossStringWriter writer = new BBossStringWriter(builder);
        SimpleStringUtil.getJacksonObjectMapper().object2json(object, (Writer)writer, true);
    }

    public static void object2json(Object object, OutputStream writer, boolean ALLOW_SINGLE_QUOTES) {
        SimpleStringUtil.getJacksonObjectMapper().object2json(object, writer, ALLOW_SINGLE_QUOTES);
    }

    public static void object2json(Object object, OutputStream writer) {
        SimpleStringUtil.getJacksonObjectMapper().object2json(object, writer, true);
    }

    public static void object2json(Object object, File writer, boolean ALLOW_SINGLE_QUOTES) {
        SimpleStringUtil.getJacksonObjectMapper().object2json(object, writer, ALLOW_SINGLE_QUOTES);
    }

    public static void object2json(Object object, File writer) {
        SimpleStringUtil.getJacksonObjectMapper().object2json(object, writer, true);
    }

    public static byte[] object2jsonAsbyte(Object object, boolean ALLOW_SINGLE_QUOTES) {
        return SimpleStringUtil.getJacksonObjectMapper().object2jsonAsbyte(object, ALLOW_SINGLE_QUOTES);
    }

    public static byte[] object2jsonAsbyte(Object object) {
        return SimpleStringUtil.getJacksonObjectMapper().object2jsonAsbyte(object, true);
    }
}

