/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util;

import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.frameworkset.util.Assert;
import org.frameworkset.util.ClassUtils;

public class ResourceUtils {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_CODE_SOURCE = "code-source";
    public static final String JAR_URL_SEPARATOR = "!/";

    public static boolean isUrl(String resourceLocation) {
        if (resourceLocation == null) {
            return false;
        }
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            return true;
        }
        try {
            new URL(resourceLocation);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static URL getURL(String resourceLocation) throws FileNotFoundException {
        Assert.notNull((Object)resourceLocation, (String)"Resource location must not be null");
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            URL url = ClassUtils.getDefaultClassLoader().getResource(path);
            if (url == null) {
                String description = "class path resource [" + path + "]";
                throw new FileNotFoundException(description + " cannot be resolved to URL because it does not exist");
            }
            return url;
        }
        try {
            return new URL(resourceLocation);
        }
        catch (MalformedURLException ex) {
            try {
                return new File(resourceLocation).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new FileNotFoundException("Resource location [" + resourceLocation + "] is neither a URL not a well-formed file path");
            }
        }
    }

    public static File getFile(String resourceLocation) throws FileNotFoundException {
        Assert.notNull((Object)resourceLocation, (String)"Resource location must not be null");
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            String description = "class path resource [" + path + "]";
            URL url = ClassUtils.getDefaultClassLoader().getResource(path);
            if (url == null) {
                throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system");
            }
            return ResourceUtils.getFile(url, description);
        }
        try {
            return ResourceUtils.getFile(new URL(resourceLocation));
        }
        catch (MalformedURLException ex) {
            return new File(resourceLocation);
        }
    }

    private static ClassLoader getTCL() {
        Method method = null;
        try {
            method = Thread.class.getMethod("getContextClassLoader", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            return (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URL getFileURL(String file) {
        URL confURL = null;
        if (!file.startsWith(FILE_URL_PREFIX)) {
            confURL = ResourceUtils.class.getClassLoader().getResource(file);
            if (confURL == null) {
                confURL = ResourceUtils.class.getClassLoader().getResource("/" + file);
            }
            if (confURL == null) {
                confURL = ResourceUtils.getTCL().getResource(file);
            }
            if (confURL == null) {
                confURL = ResourceUtils.getTCL().getResource("/" + file);
            }
            if (confURL == null) {
                confURL = ClassLoader.getSystemResource(file);
            }
            if (confURL == null) {
                confURL = ClassLoader.getSystemResource("/" + file);
            }
            if (confURL == null) {
                throw new NullPointerException(file + " do not exist.");
            }
            return confURL;
        }
        File file_ = new File(file.substring(FILE_URL_PREFIX.length()));
        if (file_.exists()) {
            try {
                return file_.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(file.substring(FILE_URL_PREFIX.length()), e);
            }
        }
        throw new IllegalArgumentException(file.substring(FILE_URL_PREFIX.length()) + " do not exist.");
    }

    public static String getRealPath(String contextPath, String path) {
        contextPath = contextPath.replace('\\', '/');
        if ((path = path.replace('\\', '/')).startsWith("/")) {
            if (!contextPath.endsWith("/")) {
                return contextPath + path;
            }
            return contextPath.substring(0, contextPath.length() - 1) + path;
        }
        if (!contextPath.endsWith("/")) {
            return contextPath + "/" + path;
        }
        return contextPath + path;
    }

    public static URL getFileURL(String baseDir, String file) {
        if (baseDir == null) {
            return ResourceUtils.getFileURL(file);
        }
        file = ResourceUtils.getRealPath(FILE_URL_PREFIX + baseDir, file);
        return ResourceUtils.getFileURL(file);
    }

    public static File getFile(URL resourceUrl) throws FileNotFoundException {
        return ResourceUtils.getFile(resourceUrl, "URL");
    }

    public static File getFile(URL resourceUrl, String description) throws FileNotFoundException {
        Assert.notNull((Object)resourceUrl, (String)"Resource URL must not be null");
        if (!URL_PROTOCOL_FILE.equals(resourceUrl.getProtocol())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + resourceUrl);
        }
        try {
            return new File(ResourceUtils.toURI(resourceUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(resourceUrl.getFile());
        }
    }

    public static File getFile(URI resourceUri) throws FileNotFoundException {
        return ResourceUtils.getFile(resourceUri, "URI");
    }

    public static File getFile(URI resourceUri, String description) throws FileNotFoundException {
        Assert.notNull((Object)resourceUri, (String)"Resource URI must not be null");
        if (!URL_PROTOCOL_FILE.equals(resourceUri.getScheme())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + resourceUri);
        }
        return new File(resourceUri.getSchemeSpecificPart());
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_VFSZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol) || URL_PROTOCOL_CODE_SOURCE.equals(protocol) && url.getPath().indexOf(JAR_URL_SEPARATOR) != -1;
    }

    public static URL extractJarFileURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                if (!jarFile.startsWith("/")) {
                    jarFile = "/" + jarFile;
                }
                return new URL(FILE_URL_PREFIX + jarFile);
            }
        }
        return jarUrl;
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return ResourceUtils.toURI(url.toString());
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(SimpleStringUtil.replace((String)location, (String)" ", (String)"%20"));
    }
}

