/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.daemon;

import com.frameworkset.daemon.WrapperResourceInit;
import com.frameworkset.util.ResourceInitial;
import com.frameworkset.util.UUIDResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceNameSpace
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(ResourceNameSpace.class);
    private List<WrapperResourceInit> resourceInitList;
    private String nameSpace;
    private long modifyTimestamp;

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public long getModifyTimestamp() {
        return this.modifyTimestamp;
    }

    public void setModifyTimestamp(long modifyTimestamp) {
        this.modifyTimestamp = modifyTimestamp;
    }

    public abstract long getLastModifyTimestamp();

    public void addResourceInit(WrapperResourceInit wrapperResourceInit) {
        if (this.resourceInitList == null) {
            this.resourceInitList = new ArrayList<WrapperResourceInit>();
        }
        if (!this.contain(wrapperResourceInit)) {
            this.resourceInitList.add(wrapperResourceInit);
        }
    }

    private boolean contain(ResourceInitial init) {
        if (init instanceof UUIDResource) {
            String uuid = ((UUIDResource)((Object)init)).getUUID();
            for (int i = 0; i < this.resourceInitList.size(); ++i) {
                ResourceInitial initOld = this.resourceInitList.get(i);
                if (!(initOld instanceof UUIDResource) || !((UUIDResource)((Object)initOld)).getUUID().equals(uuid)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public synchronized void reinit() {
        long lastModifiedTime;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Reload data in changed resource[" + this.nameSpace + "]");
        }
        if ((lastModifiedTime = this.getLastModifyTimestamp()) == this.modifyTimestamp) {
            return;
        }
        this.modifyTimestamp = lastModifiedTime;
        for (int i = 0; this.resourceInitList != null && i < this.resourceInitList.size(); ++i) {
            WrapperResourceInit init = this.resourceInitList.get(i);
            try {
                init.reinit();
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info("Reload data in changed resource[" + this.nameSpace + "] sucessed.");
                continue;
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) continue;
                this.logger.error("Reload data in changed resource[" + this.nameSpace + "] failed:", (Throwable)e);
            }
        }
    }

    public boolean checkChanged() {
        long lastModifiedTime = this.getLastModifyTimestamp();
        return lastModifiedTime != this.modifyTimestamp;
    }
}

