/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.security;

import com.sun.crypto.provider.SunJCE;
import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.frameworkset.security.CoderUtil;

public class DESCipher {
    private static final String DEFAULTKEY = "BBOSSGROUPS";
    private Cipher encryptCipher = null;
    private Cipher decryptCipher = null;
    public static int type_decode = 0;
    public static int type_encode = 1;
    public static int type_all = 2;

    public DESCipher() throws Exception {
        this(DEFAULTKEY, type_all);
    }

    public DESCipher(int type) throws Exception {
        this(DEFAULTKEY, type);
    }

    public DESCipher(String strKey) throws Exception {
        this(strKey, type_all);
    }

    public DESCipher(String strKey, int type) throws Exception {
        Security.addProvider(new SunJCE());
        Key key = this.getKey(strKey.getBytes());
        if (type == type_encode || type == type_all) {
            this.encryptCipher = Cipher.getInstance("DES");
            this.encryptCipher.init(1, key);
        }
        if (type == type_decode || type == type_all) {
            this.decryptCipher = Cipher.getInstance("DES");
            this.decryptCipher.init(2, key);
        }
    }

    public byte[] encrypt(byte[] arrB) throws Exception {
        return this.encryptCipher.doFinal(arrB);
    }

    public String encrypt(String strIn) throws Exception {
        return CoderUtil.byteGrpToHexStr(this.encrypt(strIn.getBytes()));
    }

    public byte[] decrypt(byte[] arrB) throws Exception {
        return this.decryptCipher.doFinal(arrB);
    }

    public String decrypt(String strIn) throws Exception {
        return new String(this.decrypt(CoderUtil.hexStrToByteGrp(strIn)));
    }

    private Key getKey(byte[] arrBTmp) throws Exception {
        byte[] arrB = new byte[8];
        for (int i = 0; i < arrBTmp.length && i < arrB.length; ++i) {
            arrB[i] = arrBTmp[i];
        }
        SecretKeySpec key = new SecretKeySpec(arrB, "DES");
        return key;
    }

    public static void main(String[] args) throws Exception {
        DESCipher dd = new DESCipher("123456789", 2);
        String r = dd.encrypt("bb");
        System.out.println(r);
        System.out.println(dd.decrypt(r));
    }
}

