/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.io;

import org.frameworkset.util.Assert;
import org.frameworkset.util.ClassUtils;
import org.frameworkset.util.io.ClassPathResource;
import org.frameworkset.util.io.Resource;
import org.frameworkset.util.io.ResourceLoader;

public class ClassPathResourceLoader
implements ResourceLoader {
    private ClassLoader classLoader;

    public ClassPathResourceLoader() {
        this.classLoader = ClassUtils.getDefaultClassLoader();
    }

    public ClassPathResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Resource getResource(String location) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        return new ClassPathResource(location, this.classLoader);
    }
}

