/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.io;

import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.frameworkset.util.Assert;
import org.frameworkset.util.io.AbstractResource;
import org.frameworkset.util.io.Resource;

public class FileSystemResource
extends AbstractResource {
    private final File file;
    private final String path;

    public FileSystemResource(File file) {
        Assert.notNull((Object)file, (String)"File must not be null");
        this.file = file;
        this.path = SimpleStringUtil.cleanPath((String)file.getPath());
    }

    public FileSystemResource(String path) {
        Assert.notNull((Object)path, (String)"Path must not be null");
        this.file = new File(path);
        this.path = SimpleStringUtil.cleanPath((String)path);
    }

    public final String getPath() {
        return this.path;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isReadable() {
        return this.file.canRead() && !this.file.isDirectory();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public URL getURL() throws IOException {
        return this.file.toURI().toURL();
    }

    @Override
    public URI getURI() throws IOException {
        return this.file.toURI();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Resource createRelative(String relativePath) {
        String pathToUse = SimpleStringUtil.applyRelativePath((String)this.path, (String)relativePath);
        return new FileSystemResource(pathToUse);
    }

    @Override
    public String getFilename() {
        return this.file.getName();
    }

    public String getDescription() {
        return "file [" + this.file.getAbsolutePath() + "]";
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof FileSystemResource && this.path.equals(((FileSystemResource)obj).path);
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }
}

