/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.schedule.quartz;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.jobflow.schedule.ExternalJobFlowScheduler;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseQuartzDatasynJobFlow
implements Job {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean inited;
    protected ExternalJobFlowScheduler externalJobFlowScheduler;
    private Lock lock = new ReentrantLock();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.lock.lock();
        try {
            if (!this.inited) {
                try {
                    this.buildJobFlow();
                }
                finally {
                    this.inited = true;
                }
            }
            this.externalJobFlowScheduler.execute((Object)context);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void buildJobFlow() {
        this.init();
        ShutdownUtil.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                BaseQuartzDatasynJobFlow.this.destroy();
            }
        });
    }

    public void destroy() {
        if (this.externalJobFlowScheduler != null) {
            this.externalJobFlowScheduler.destroy();
        }
    }

    public abstract void init();
}

