/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.template;

import com.frameworkset.daemon.ResourceNameSpace;
import com.frameworkset.util.DaemonThread;
import com.frameworkset.util.ResourceInitial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.frameworkset.elasticsearch.template.BaseTemplateMeta;
import org.frameworkset.elasticsearch.template.ESServiceProviderManager;
import org.frameworkset.elasticsearch.template.ESUtil;
import org.frameworkset.elasticsearch.template.TemplateContainer;
import org.frameworkset.elasticsearch.template.TemplateMeta;
import org.frameworkset.spi.assemble.AOPValueHandler;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.frameworkset.spi.assemble.ValueContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTemplateContainerImpl
implements TemplateContainer {
    private static Logger logger = LoggerFactory.getLogger(BaseTemplateContainerImpl.class);
    protected String namespace;
    protected Map<String, TemplateMeta> templateMetas;

    public BaseTemplateContainerImpl(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    protected abstract Map<String, TemplateMeta> loadTemplateMetas(String var1);

    private Map<String, TemplateMeta> _loadTemplateMetas(String namespace) {
        final Map<String, TemplateMeta> templateMetaMap = this.loadTemplateMetas(namespace);
        if (templateMetaMap != null && templateMetaMap.size() > 0) {
            Iterator<Map.Entry<String, TemplateMeta>> iterator = templateMetaMap.entrySet().iterator();
            final PropertiesContainer configProperties = new PropertiesContainer();
            final ESServiceProviderManager esServiceProviderManager = new ESServiceProviderManager();
            ValueContainer valueContainer = new ValueContainer(){

                public String getMacroVariableValue(List<String> parentLinks, String text) {
                    BaseTemplateMeta inTemplateMeta = (BaseTemplateMeta)templateMetaMap.get(text);
                    if (inTemplateMeta != null) {
                        if (inTemplateMeta.isParsered()) {
                            return inTemplateMeta.getDslTemplate();
                        }
                        BaseTemplateContainerImpl.this.evalValue(parentLinks, inTemplateMeta, configProperties, (AOPValueHandler)esServiceProviderManager, this);
                        return inTemplateMeta.getDslTemplate();
                    }
                    return null;
                }
            };
            ArrayList<String> parentLinks = null;
            while (iterator.hasNext()) {
                Map.Entry<String, TemplateMeta> templateMetaEntry = iterator.next();
                BaseTemplateMeta templateMeta = (BaseTemplateMeta)templateMetaEntry.getValue();
                if (templateMeta.isParsered()) continue;
                parentLinks = new ArrayList<String>();
                parentLinks.add(templateMeta.getName());
                this.evalValue(parentLinks, templateMeta, configProperties, (AOPValueHandler)esServiceProviderManager, valueContainer);
            }
        }
        return templateMetaMap;
    }

    public void evalValue(List<String> parentLinks, BaseTemplateMeta templateMeta, PropertiesContainer configProperties, AOPValueHandler valueHandler, ValueContainer valueContainer) {
        String value = templateMeta.getDslTemplate();
        if (value != null && !value.equals("")) {
            value = configProperties.escapeValue(value, valueHandler, templateMeta.isEscapeQuoted());
        }
        String resultValue = configProperties.evalValue(parentLinks, value, valueHandler, valueContainer);
        templateMeta.setDslTemplate(resultValue);
        templateMeta.setParsered(true);
    }

    protected abstract long getLastModifyTime(String var1);

    private synchronized void init() {
        if (this.templateMetas == null) {
            this.templateMetas = this._loadTemplateMetas(this.namespace);
            if (this.templateMetas == null) {
                this.templateMetas = new HashMap<String, TemplateMeta>(0);
            }
        }
    }

    @Override
    public Set<String> getTempalteNames() {
        if (this.templateMetas == null) {
            this.init();
        }
        return this.templateMetas.keySet();
    }

    @Override
    public TemplateMeta getProBean(String templateName) {
        if (this.templateMetas == null) {
            this.init();
        }
        return this.templateMetas.get(templateName);
    }

    @Override
    public void destroy(boolean clearContext) {
        if (this.templateMetas != null) {
            this.templateMetas.clear();
        }
    }

    @Override
    public int getPerKeyDSLStructionCacheSize() {
        return 2000;
    }

    @Override
    public boolean isAlwaysCacheDslStruction() {
        return false;
    }

    @Override
    public synchronized void reinit(ESUtil esUtil) {
        try {
            Map<String, TemplateMeta> temp = this._loadTemplateMetas(this.namespace);
            if (temp != null) {
                this.templateMetas = temp;
            } else {
                this.templateMetas.clear();
            }
            esUtil.buildTemplateDatas(this);
        }
        catch (Exception e) {
            logger.warn("reinit namespace" + this.namespace + " failed:", (Throwable)e);
        }
    }

    @Override
    public void monitor(DaemonThread daemonThread, ResourceInitial resourceTempateRefresh) {
        ResourceNameSpace resourceNameSpace = new ResourceNameSpace(){

            public long getLastModifyTimestamp() {
                return BaseTemplateContainerImpl.this.getLastModifyTime(BaseTemplateContainerImpl.this.namespace);
            }
        };
        resourceNameSpace.setNameSpace(this.namespace);
        daemonThread.addResource(resourceNameSpace, resourceTempateRefresh);
    }
}

