/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.SliceRunTask;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ElasticSearchRestClient;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.frameworkset.elasticsearch.client.SliceScroll;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.entity.RestResponse;
import org.frameworkset.elasticsearch.handler.ElasticSearchResponseHandler;
import org.frameworkset.elasticsearch.scroll.HandlerInfo;
import org.frameworkset.elasticsearch.scroll.ParallelSliceScrollResult;
import org.frameworkset.elasticsearch.scroll.ScrollHandler;
import org.frameworkset.elasticsearch.scroll.SliceScrollResult;
import org.frameworkset.elasticsearch.scroll.SliceScrollResultInf;
import org.frameworkset.elasticsearch.scroll.thread.ScrollTask;
import org.frameworkset.elasticsearch.serial.ESInnerHitSerialThreadLocal;
import org.frameworkset.elasticsearch.serial.SerialContext;
import org.frameworkset.elasticsearch.template.ConfigDSLUtil;
import org.frameworkset.elasticsearch.template.ESTemplateHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecuteRequestUtil {
    private static Logger logger = LoggerFactory.getLogger(ExecuteRequestUtil.class);

    public static <T> ESDatas<T> searchScroll(ElasticSearchRestClient client, String scroll, String scrollId, Class<T> type) throws ElasticSearchException {
        if (!client.isV1()) {
            StringBuilder entity = new StringBuilder();
            entity.append("{\"scroll\" : \"").append(scroll).append("\",\"scroll_id\" : \"").append(scrollId).append("\"}");
            RestResponse result = (RestResponse)client.executeRequest("_search/scroll", entity.toString(), new ElasticSearchResponseHandler(type));
            return ResultUtil.buildESDatas(result, type);
        }
        StringBuilder path = new StringBuilder();
        path.append("_search/scroll?scroll=").append(scroll).append("&scroll_id=").append(scrollId);
        RestResponse result = (RestResponse)client.executeHttp(path.toString(), "get", new ElasticSearchResponseHandler(type));
        return ResultUtil.buildESDatas(result, type);
    }

    public static <T> void runSliceScrollTask(List<Future> tasks, ScrollHandler<T> _scrollHandler, ESDatas<T> sliceResponse, HandlerInfo handlerInfo, SliceScrollResultInf<T> sliceScrollResult, ExecutorService executorService) {
        ScrollTask<T> scrollTask = new ScrollTask<T>(_scrollHandler, sliceResponse, handlerInfo, sliceScrollResult);
        tasks.add(executorService.submit(scrollTask));
    }

    public static <T> void _doSliceScroll(ElasticSearchRestClient client, int i, String path, String entity, String scroll, Class<T> type, SliceScrollResultInf<T> sliceScrollResult, boolean parallel) throws Exception {
        ArrayList<Future> tasks;
        block23: {
            tasks = null;
            try {
                if (sliceScrollResult.isBreaked()) {
                    return;
                }
                RestResponse result = (RestResponse)client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
                ESDatas<T> sliceResponse = ResultUtil.buildESDatas(result, type);
                int taskId = 0;
                List sliceDatas = sliceResponse.getDatas();
                String scrollId = sliceResponse.getScrollId();
                ExecutorService executorService = parallel ? client.getScrollQueryExecutorService() : null;
                TreeSet<String> scrollIds = null;
                if (scrollId != null) {
                    scrollIds = new TreeSet<String>();
                    scrollIds.add(scrollId);
                }
                boolean useDefaultHandler = false;
                if (sliceDatas != null && sliceDatas.size() > 0) {
                    tasks = new ArrayList<Future>();
                    ScrollHandler<T> _scrollHandler = sliceScrollResult.getScrollHandler();
                    HandlerInfo handlerInfo = new HandlerInfo();
                    handlerInfo.setTaskId(taskId);
                    handlerInfo.setSliceId(i);
                    Object scrollTask = null;
                    ++taskId;
                    if (_scrollHandler == null) {
                        useDefaultHandler = true;
                        _scrollHandler = sliceScrollResult.setScrollHandler(sliceResponse, handlerInfo);
                        sliceScrollResult.incrementSize(sliceDatas.size());
                    } else {
                        if (parallel) {
                            ExecuteRequestUtil.runSliceScrollTask(tasks, _scrollHandler, sliceResponse, handlerInfo, sliceScrollResult, executorService);
                        } else {
                            _scrollHandler.handle(sliceResponse, handlerInfo);
                            sliceScrollResult.incrementSize(sliceDatas.size());
                        }
                        sliceScrollResult.setSliceResponse(sliceResponse);
                    }
                    ESDatas<T> _sliceResponse = null;
                    List _sliceDatas = null;
                    while (!sliceScrollResult.isBreaked()) {
                        _sliceResponse = ExecuteRequestUtil.searchScroll(client, scroll, scrollId, type);
                        String sliceScrollId = _sliceResponse.getScrollId();
                        if (sliceScrollId != null) {
                            scrollIds.add(sliceScrollId);
                        }
                        if ((_sliceDatas = _sliceResponse.getDatas()) == null || _sliceDatas.size() == 0) break;
                        handlerInfo = new HandlerInfo();
                        handlerInfo.setTaskId(taskId);
                        handlerInfo.setSliceId(i);
                        handlerInfo.setScrollId(scrollId);
                        ++taskId;
                        scrollId = sliceScrollId;
                        if (!useDefaultHandler) {
                            if (parallel) {
                                ExecuteRequestUtil.runSliceScrollTask(tasks, _scrollHandler, _sliceResponse, handlerInfo, sliceScrollResult, executorService);
                                continue;
                            }
                            _scrollHandler.handle(_sliceResponse, handlerInfo);
                            sliceScrollResult.incrementSize(_sliceDatas.size());
                            continue;
                        }
                        _scrollHandler.handle(_sliceResponse, handlerInfo);
                        sliceScrollResult.incrementSize(_sliceDatas.size());
                    }
                }
                if (tasks != null && tasks.size() > 0) {
                    ExecuteRequestUtil.waitTasksComplete(tasks);
                }
                if (scrollIds == null || scrollIds.size() <= 0) break block23;
                try {
                    ExecuteRequestUtil.deleteScrolls(client, scrollIds);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (ElasticSearchException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ElasticSearchException("slice query task[" + i + "] failed:", e);
            }
            finally {
                if (tasks != null && tasks.size() > 0) {
                    ExecuteRequestUtil.waitTasksComplete((List<Future>)tasks);
                }
            }
        }
        if (tasks != null && tasks.size() > 0) {
            ExecuteRequestUtil.waitTasksComplete(tasks);
        }
    }

    public static String deleteScrolls(ElasticSearchRestClient client, List<String> scrollIds) throws ElasticSearchException {
        if (scrollIds == null || scrollIds.size() == 0) {
            return null;
        }
        return ExecuteRequestUtil.deleteScrolls(client, scrollIds.iterator());
    }

    public static String deleteScrolls(ElasticSearchRestClient client, Set<String> scrollIds) throws ElasticSearchException {
        if (scrollIds == null || scrollIds.size() == 0) {
            return null;
        }
        return ExecuteRequestUtil.deleteScrolls(client, scrollIds.iterator());
    }

    public static String deleteScrolls(ElasticSearchRestClient client, String[] scrollIds) throws ElasticSearchException {
        if (scrollIds == null || scrollIds.length == 0) {
            return null;
        }
        if (!client.isV1()) {
            StringBuilder entity = new StringBuilder();
            entity.append("{\"scroll_id\" : [");
            for (int i = 0; i < scrollIds.length; ++i) {
                String scrollId = scrollIds[i];
                if (i > 0) {
                    entity.append(",");
                }
                entity.append("\"").append(scrollId).append("\"");
            }
            entity.append("]}");
            String result = client.executeHttp("_search/scroll", entity.toString(), "delete");
            return result;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Elasticsearch " + client.getEsVersion() + " do not support delete scrollId.");
        }
        return "";
    }

    private static String deleteScrolls(ElasticSearchRestClient client, Iterator<String> scrollIds) throws ElasticSearchException {
        if (!client.isV1()) {
            StringBuilder entity = new StringBuilder();
            entity.append("{\"scroll_id\" : [");
            int i = 0;
            while (scrollIds.hasNext()) {
                String scrollId = scrollIds.next();
                if (i > 0) {
                    entity.append(",");
                }
                ++i;
                entity.append("\"").append(scrollId).append("\"");
            }
            entity.append("]}");
            String result = client.executeHttp("_search/scroll", entity.toString(), "delete");
            return result;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Elasticsearch " + client.getEsVersion() + " do not support delete scrollId.");
        }
        return "";
    }

    public static void waitTasksComplete(List<Future> tasks) {
        Throwable exception = null;
        for (Future future : tasks) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                if (exception == null) {
                    exception = e.getCause();
                }
                logger.error("", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                if (exception != null) continue;
                exception = e;
            }
        }
        tasks.clear();
        if (exception != null) {
            if (exception instanceof ElasticSearchException) {
                throw (ElasticSearchException)exception;
            }
            throw new ElasticSearchException("waitTasksComplete", exception);
        }
    }

    public static <T> ESDatas<T> _scrollSlice(ElasticSearchRestClient client, ConfigDSLUtil configDSLUtil, String path, String dslTemplate, Map params, String scroll, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        long starttime = System.currentTimeMillis();
        Integer mx = (Integer)params.get("sliceMax");
        if (mx == null) {
            throw new ElasticSearchException("Slice parameters exception: must set sliceMax in params!");
        }
        int max = mx;
        String _path = path.indexOf(63) < 0 ? path + "?scroll=" + scroll : path + "&scroll=" + scroll;
        SliceScrollResult<T> sliceScrollResult = new SliceScrollResult<T>();
        if (scrollHandler != null) {
            sliceScrollResult.setScrollHandler(scrollHandler);
        }
        int j = 0;
        while (j < max && !sliceScrollResult.isBreaked()) {
            int i = j++;
            try {
                params.put("sliceId", i);
                ExecuteRequestUtil._doSliceScroll(client, i, _path, ESTemplateHelper.evalTemplate(configDSLUtil, dslTemplate, params), scroll, type, sliceScrollResult, false);
            }
            catch (ElasticSearchException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ElasticSearchException("slice query task[" + i + "] failed:", e);
            }
        }
        if (logger.isDebugEnabled()) {
            long endtime = System.currentTimeMillis();
            logger.debug("Slice scroll query\u8017\u65f6\uff1a" + (endtime - starttime) + ",realTotalSize\uff1a" + sliceScrollResult.getRealTotalSize());
        }
        sliceScrollResult.complete();
        return sliceScrollResult.getSliceResponse();
    }

    public static <T> void runSliceTask(ClientInterface clientInterface, int sliceId, String path, String sliceDsl, String scroll, Class<T> type, ParallelSliceScrollResult sliceScrollResult, ExecutorService executorService, List<Future> tasks, SerialContext serialContext) {
        SliceRunTask<T> sliceRunTask = new SliceRunTask<T>(clientInterface, sliceId, path, sliceDsl, scroll, type, sliceScrollResult, serialContext);
        tasks.add(executorService.submit(sliceRunTask));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ESDatas<T> _slice(ClientInterface clientInterface, String path, ScrollHandler<T> scrollHandler, Class<T> type, int max, String scroll, SliceScroll sliceScroll) throws ElasticSearchException {
        long starttime = System.currentTimeMillis();
        String _path = path.indexOf(63) < 0 ? path + "?scroll=" + scroll : path + "&scroll=" + scroll;
        ExecutorService executorService = clientInterface.getClient().getSliceScrollQueryExecutorService();
        ArrayList<Future> tasks = new ArrayList<Future>();
        ParallelSliceScrollResult<T> sliceScrollResult = new ParallelSliceScrollResult<T>();
        if (scrollHandler != null) {
            sliceScrollResult.setScrollHandler(scrollHandler);
        }
        try {
            SerialContext serialContext = ESInnerHitSerialThreadLocal.buildSerialContext();
            for (int j = 0; j < max; ++j) {
                if (sliceScrollResult.isBreaked()) {
                    break;
                }
                String sliceDsl = sliceScroll.buildSliceDsl(j, max);
                ExecuteRequestUtil.runSliceTask(clientInterface, j, _path, sliceDsl, scroll, type, sliceScrollResult, executorService, tasks, serialContext);
            }
        }
        finally {
            ExecuteRequestUtil.waitTasksComplete(tasks);
        }
        if (logger.isDebugEnabled()) {
            long endtime = System.currentTimeMillis();
            logger.debug("Slice scroll query\u8017\u65f6\uff1a" + (endtime - starttime) + ",realTotalSize\uff1a" + sliceScrollResult.getRealTotalSize());
        }
        sliceScrollResult.complete();
        return sliceScrollResult.getSliceResponse();
    }

    public static <T> ESDatas<T> scrollSliceParallel(ClientInterface clientInterface, final ConfigDSLUtil configDSLUtil, String path, final String dslTemplate, final Map params, String scroll, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        Integer mx = (Integer)params.get("sliceMax");
        if (mx == null) {
            throw new ElasticSearchException("Slice parameters exception: must set sliceMax in params!");
        }
        int max = mx;
        SliceScroll sliceScroll = new SliceScroll(){

            @Override
            public String buildSliceDsl(int sliceId, int max) {
                HashMap<String, Integer> _params = new HashMap<String, Integer>();
                _params.putAll(params);
                _params.put("sliceId", sliceId);
                String sliceDsl = ESTemplateHelper.evalTemplate(configDSLUtil, dslTemplate, _params);
                return sliceDsl;
            }
        };
        return ExecuteRequestUtil._slice(clientInterface, path, scrollHandler, type, max, scroll, sliceScroll);
    }

    public static String _addDocuments(ElasticSearchRestClient client, ConfigDSLUtil configDSLUtil, String indexName, String indexType, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        for (Object bean : beans) {
            ESTemplateHelper.evalBuilkTemplate(configDSLUtil, builder, indexName, indexType, addTemplate, bean, "index", client.isUpper7());
        }
        if (refreshOption == null) {
            return client.executeHttp("_bulk", builder.toString(), "post");
        }
        return client.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
    }

    public static String _updateDocuments(ElasticSearchRestClient client, ConfigDSLUtil configDSLUtil, String indexName, String indexType, String updateTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        for (Object bean : beans) {
            ESTemplateHelper.evalBuilkTemplate(configDSLUtil, builder, indexName, indexType, updateTemplate, bean, "update", client.isUpper7());
        }
        if (refreshOption != null && !refreshOption.equals("")) {
            return client.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
        }
        return client.executeHttp("_bulk", builder.toString(), "post");
    }
}

