/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.util;

import java.util.concurrent.TimeUnit;
import org.frameworkset.elasticsearch.util.TimeWindowSampler;

public class TimeWindowDownSampler
implements TimeWindowSampler {
    private static final long ONE_SECOND = 1000L;
    private static final long FIVE_SECOND = 5000L;
    private static final long TEN_SECOND = 10000L;
    private static final long THREE_MINUTE = 180000L;
    private static final long TWENTY_SECOND = 20000L;
    private static final long THIRTY_SECOND = 30000L;
    private static final long FIFTY_SECOND = 50000L;
    private static final long SIX_MINUTE = 360000L;
    private static final long TEN_MINUTE = 600000L;
    private static final long FIFTY_MINUTE = 3000000L;
    private static final long TWENTY_MINUTE = 1200000L;
    private static final long TWENTY_FIVE_MINUTE = 1500000L;
    private static final long THIRTY_MINUTE = 1800000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = TimeUnit.HOURS.toMillis(1L);
    private static final long SIX_HOURS = TimeUnit.HOURS.toMillis(6L);
    private static final long TWELVE_HOURS = TimeUnit.HOURS.toMillis(12L);
    private static final long ONE_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final long TWO_DAY = TimeUnit.DAYS.toMillis(2L);
    private static final String ONE_SECOND_INTERVAL = "1s";
    private static final String FIVE_SECOND_INTERVAL = "5s";
    private static final String TEN_SECOND_INTERVAL = "10s";
    private static final String TWENTY_SECOND_INTERVAL = "20s";
    private static final String THIRTY_SECOND_INTERVAL = "30s";
    private static final String FIFTY_SECOND_INTERVAL = "50s";
    private static final String ONE_MINUTE_INTERVAL = "1m";
    private static final String THREE_MINUTE_INTERVAL = "3m";
    private static final String SIX_MINUTE_INTERVAL = "6m";
    private static final String TEN_MINUTE_INTERVAL = "10m";
    private static final String FIFTY_MINUTE_INTERVAL = "15m";
    private static final String TWENTY_MINUTE_INTERVAL = "20m";
    private static final String TWENTY_FIVE_MINUTE_INTERVAL = "25m";
    private static final String THIRTY_MINUTE_INTERVAL = "30m";
    private static final String ONE_HOUR_INTERVAL = "1h";
    private static final String SIX_HOURS_INTERVAL = "6h";
    private static final String TWELVE_HOURS_INTERVAL = "12h";
    private static final String ONE_DAY_INTERVAL = "1d";
    private static final String TWO_DAY_INTERVAL = "2d";
    public static final TimeWindowSampler SAMPLER = new TimeWindowDownSampler();

    @Override
    public long getWindowSize(long from, long to) {
        long diff = to - from;
        long size = diff <= ONE_HOUR ? 60000L : (diff <= SIX_HOURS ? 300000L : (diff <= TWELVE_HOURS ? 600000L : (diff <= ONE_DAY ? 1200000L : (diff <= TWO_DAY ? 1800000L : 3600000L))));
        return size;
    }

    @Override
    public String getWindowInterval(long from, long to) {
        long diff = to - from;
        String interval = TEN_SECOND_INTERVAL;
        if (diff <= ONE_HOUR) {
            return interval;
        }
        if (diff <= SIX_HOURS) {
            return THIRTY_SECOND_INTERVAL;
        }
        if (diff <= TWELVE_HOURS) {
            return ONE_MINUTE_INTERVAL;
        }
        if (diff <= ONE_DAY) {
            return SIX_MINUTE_INTERVAL;
        }
        if (diff <= TWO_DAY) {
            return THIRTY_MINUTE_INTERVAL;
        }
        return ONE_HOUR_INTERVAL;
    }
}

