/*
 * Decompiled with CFR 0.152.
 */
package com.blade;

import blade.kit.Assert;
import blade.kit.config.Config;
import blade.kit.config.loader.ConfigLoader;
import blade.kit.reflect.ReflectKit;
import com.blade.Bootstrap;
import com.blade.ioc.Ioc;
import com.blade.ioc.SampleIoc;
import com.blade.loader.BladeConfig;
import com.blade.loader.Configurator;
import com.blade.plugin.Plugin;
import com.blade.route.Route;
import com.blade.route.RouteException;
import com.blade.route.RouteGroup;
import com.blade.route.RouteHandler;
import com.blade.route.Routers;
import com.blade.route.loader.ClassPathRouteLoader;
import com.blade.server.Server;
import com.blade.view.template.JspEngine;
import com.blade.view.template.TemplateEngine;
import com.blade.web.http.HttpMethod;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Blade {
    private boolean isInit = false;
    private boolean isAsyn = false;
    private Bootstrap bootstrap = null;
    private BladeConfig bladeConfig = new BladeConfig();
    private Ioc ioc = new SampleIoc();
    private TemplateEngine templateEngine = null;
    private Routers routers = new Routers();
    private int port = 9000;
    private Server bladeServer;
    private Set<Class<? extends Plugin>> plugins;

    private Blade() {
        this.templateEngine = new JspEngine();
        this.plugins = new HashSet<Class<? extends Plugin>>();
    }

    public static final Blade me() {
        return BladeHolder.ME;
    }

    public void init() {
        if (!this.isInit) {
            this.isInit = true;
        }
    }

    public Server createServer(int port) {
        return new Server(port, this.isAsyn);
    }

    public Routers routers() {
        return this.routers;
    }

    public Ioc ioc() {
        return this.ioc;
    }

    public Blade container(Ioc ioc) {
        Assert.notNull((Object)ioc);
        this.ioc = ioc;
        return this;
    }

    public Blade setAppConf(String confName) {
        Assert.notBlank((CharSequence)confName);
        Config config = ConfigLoader.load((String)confName);
        Configurator.init(this.bladeConfig, config);
        return this;
    }

    public Blade addRoutePackage(String packageName) {
        return this.addRoutePackages(packageName);
    }

    public Blade addRoutePackages(String ... packages) {
        Assert.notNull((Object)packages);
        this.bladeConfig.addRoutePackages(packages);
        return this;
    }

    public Blade basePackage(String basePackage) {
        Assert.notBlank((CharSequence)basePackage);
        this.bladeConfig.setBasePackage(basePackage);
        this.bladeConfig.addIocPackages(basePackage + ".service.*");
        this.bladeConfig.addRoutePackages(basePackage + ".controller");
        this.bladeConfig.setInterceptorPackage(basePackage + ".interceptor");
        return this;
    }

    public Blade interceptor(String packageName) {
        Assert.notBlank((CharSequence)packageName);
        this.bladeConfig.setInterceptorPackage(packageName);
        return this;
    }

    public Blade ioc(String ... packages) {
        Assert.notNull((Object)packages);
        this.bladeConfig.addIocPackages(packages);
        return this;
    }

    public Blade route(String path, Class<?> clazz, String method) {
        this.routers.route(path, clazz, method);
        return this;
    }

    public Blade route(String path, Class<?> clazz, String method, HttpMethod httpMethod) {
        this.routers.route(path, clazz, method, httpMethod);
        return this;
    }

    public Blade routes(List<Route> routes) {
        Assert.notEmpty(routes, (String)"Routes not is empty!", (Object[])new Object[0]);
        this.routers.addRoutes(routes);
        return this;
    }

    public Blade get(String path, RouteHandler handler) {
        this.routers.route(path, handler, HttpMethod.GET);
        return this;
    }

    public Blade post(String path, RouteHandler handler) {
        this.routers.route(path, handler, HttpMethod.POST);
        return this;
    }

    public Blade delete(String path, RouteHandler handler) {
        this.routers.route(path, handler, HttpMethod.DELETE);
        return this;
    }

    public Blade put(String path, RouteHandler handler) {
        this.routers.route(path, handler, HttpMethod.PUT);
        return this;
    }

    public Blade all(String path, RouteHandler handler) {
        this.routers.route(path, handler, HttpMethod.ALL);
        return this;
    }

    public Blade any(String path, RouteHandler handler) {
        this.routers.route(path, handler, HttpMethod.ALL);
        return this;
    }

    public RouteGroup group(String prefix) {
        Assert.notNull((Object)prefix, (String)"Route group prefix not is null");
        return new RouteGroup(this, prefix);
    }

    public Blade before(String path, RouteHandler handler) {
        this.routers.route(path, handler, HttpMethod.BEFORE);
        return this;
    }

    public Blade after(String path, RouteHandler handler) {
        this.routers.route(path, handler, HttpMethod.AFTER);
        return this;
    }

    public Blade viewEngin(TemplateEngine templateEngine) {
        Assert.notNull((Object)templateEngine);
        this.templateEngine = templateEngine;
        return this;
    }

    public Blade staticFolder(String ... folders) {
        Assert.notNull((Object)folders);
        this.bladeConfig.setStaticFolders(folders);
        return this;
    }

    public Blade enableXSS(boolean httpXss) {
        this.bladeConfig.setHttpXss(httpXss);
        return this;
    }

    public Blade app(Bootstrap bootstrap) {
        Assert.notNull((Object)bootstrap);
        this.bootstrap = bootstrap;
        return this;
    }

    public Blade app(Class<? extends Bootstrap> bootstrap) {
        Assert.notNull(bootstrap);
        try {
            this.ioc.addBean(Bootstrap.class.getName(), ReflectKit.newInstance(bootstrap));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public Blade view404(String view404) {
        Assert.notBlank((CharSequence)view404);
        this.bladeConfig.setView404(view404);
        return this;
    }

    public Blade view500(String view500) {
        Assert.notBlank((CharSequence)view500);
        this.bladeConfig.setView500(view500);
        return this;
    }

    public Blade webRoot(String webRoot) {
        Assert.notBlank((CharSequence)webRoot);
        this.bladeConfig.setWebRoot(webRoot);
        return this;
    }

    public Blade isDev(boolean isDev) {
        this.bladeConfig.setDev(isDev);
        return this;
    }

    public Blade listen(int port) {
        this.port = port;
        return this;
    }

    public Blade isAsyn(boolean isAsyn) {
        this.isAsyn = isAsyn;
        return this;
    }

    public void start(String contextPath) {
        try {
            Assert.notBlank((CharSequence)contextPath);
            this.bladeServer = new Server(this.port, this.isAsyn);
            this.bladeServer.start(contextPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        this.start("/");
    }

    public void stop() {
        try {
            this.bladeServer.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void join() throws InterruptedException {
        this.bladeServer.join();
    }

    public BladeConfig config() {
        return this.bladeConfig;
    }

    public String[] routePackages() {
        return this.bladeConfig.getRoutePackages();
    }

    public String[] iocs() {
        return this.bladeConfig.getIocPackages();
    }

    public String interceptorPackage() {
        return this.bladeConfig.getInterceptorPackage();
    }

    public String encoding() {
        return this.bladeConfig.getEncoding();
    }

    public String view404() {
        return this.bladeConfig.getView404();
    }

    public String view500() {
        return this.bladeConfig.getView500();
    }

    public String webRoot() {
        return this.bladeConfig.getWebRoot();
    }

    public boolean isDev() {
        return this.bladeConfig.isDev();
    }

    public Set<String> staticFolder() {
        return this.bladeConfig.getStaticFolders();
    }

    public Bootstrap bootstrap() {
        return this.bootstrap;
    }

    public TemplateEngine templateEngine() {
        return this.templateEngine;
    }

    public boolean enableXSS() {
        return this.bladeConfig.isHttpXss();
    }

    public Blade plugin(Class<? extends Plugin> plugin) {
        Assert.notNull(plugin);
        this.plugins.add(plugin);
        return this;
    }

    public Blade routeConf(String basePackage) {
        return this.routeConf(basePackage, "route.conf");
    }

    public Blade routeConf(String basePackage, String conf) {
        try {
            Assert.notBlank((CharSequence)basePackage);
            Assert.notBlank((CharSequence)conf);
            InputStream ins = Blade.class.getResourceAsStream("/" + conf);
            ClassPathRouteLoader routesLoader = new ClassPathRouteLoader(ins);
            routesLoader.setBasePackage(basePackage);
            List<Route> routes = routesLoader.load();
            this.routers.addRoutes(routes);
        }
        catch (RouteException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return this;
    }

    public boolean isInit() {
        return this.isInit;
    }

    public boolean httpCache() {
        return this.bladeConfig.isHttpCache();
    }

    public Set<Class<? extends Plugin>> plugins() {
        return this.plugins;
    }

    static final class BladeHolder {
        private static final Blade ME = new Blade();

        BladeHolder() {
        }
    }
}

