/*
 * Decompiled with CFR 0.152.
 */
package com.blade.ioc;

import blade.kit.CollectionKit;
import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import blade.kit.resource.ClassPathClassReader;
import blade.kit.resource.ClassReader;
import com.blade.Blade;
import com.blade.Bootstrap;
import com.blade.ioc.Ioc;
import com.blade.ioc.annotation.Component;
import com.blade.plugin.Plugin;
import com.blade.route.Route;
import com.blade.route.RouteHandler;
import com.blade.route.Routers;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IocApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(IocApplication.class);
    private Ioc ioc = null;
    private ClassReader classReader = null;
    private String[] iocs;
    private Bootstrap bootstrap;
    private List<Plugin> plugins = null;
    private Set<Class<? extends Plugin>> pluginTypes;
    private Blade blade;

    public IocApplication(Blade blade) {
        this.blade = blade;
        this.classReader = new ClassPathClassReader();
        this.plugins = CollectionKit.newArrayList();
        this.pluginTypes = blade.plugins();
        this.ioc = blade.ioc();
        this.iocs = blade.iocs();
        this.bootstrap = blade.bootstrap();
    }

    public void init() {
        Collection<Route> routesList;
        Map<String, Route> interceptors;
        Collection<Route> routesList2;
        if (null == this.ioc.getBean(Bootstrap.class)) {
            this.ioc.addBean(this.bootstrap);
        }
        if (null != this.iocs && this.iocs.length > 0) {
            for (String packageName : this.iocs) {
                this.registerBean(packageName);
            }
        }
        for (Class clazz : this.pluginTypes) {
            this.ioc.addBean(clazz);
            Plugin plugin = (Plugin)this.ioc.getBean(clazz);
            this.plugins.add(plugin);
        }
        Routers routers = this.blade.routers();
        Map<String, Route> map = routers.getRoutes();
        if (CollectionKit.isNotEmpty(map) && CollectionKit.isNotEmpty(routesList2 = map.values())) {
            for (Route route : routesList2) {
                Class<?> type = route.getTargetType();
                if (null == type || null != route.getTarget() || type == RouteHandler.class || null != this.ioc.getBean(type)) continue;
                this.ioc.addBean(type);
            }
        }
        if (CollectionKit.isNotEmpty(interceptors = routers.getInterceptors()) && CollectionKit.isNotEmpty(routesList = interceptors.values())) {
            for (Route route : routesList) {
                Class<?> type = route.getTargetType();
                if (null == type || null != route.getTarget() || type == RouteHandler.class || null != this.ioc.getBean(type)) continue;
                this.ioc.addBean(type);
            }
        }
        LOGGER.info("Add Object: {}", new Object[]{this.ioc.getBeans()});
    }

    private void registerBean(String packageName) {
        boolean recursive = false;
        if (packageName.endsWith(".*")) {
            packageName = packageName.substring(0, packageName.length() - 2);
            recursive = true;
        }
        Set classes = this.classReader.getClass(packageName, recursive);
        for (Class clazz : classes) {
            Component component = clazz.getAnnotation(Component.class);
            if (null == component) continue;
            this.ioc.addBean(clazz);
        }
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public void destroy() {
        this.ioc.clearAll();
        for (Plugin plugin : this.plugins) {
            plugin.destroy();
        }
    }
}

