/*
 * Decompiled with CFR 0.152.
 */
package com.blade.ioc;

import blade.kit.reflect.ClassDefine;
import com.blade.ioc.BeanDefine;
import com.blade.ioc.Ioc;
import com.blade.ioc.annotation.InjectWith;
import com.blade.ioc.injector.FieldInjector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IocKit {
    public static List<FieldInjector> getInjectFields(Ioc ioc, ClassDefine classDefine) {
        ArrayList<FieldInjector> injectors = new ArrayList<FieldInjector>(8);
        for (Field field : classDefine.getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                InjectWith with = annotation.annotationType().getAnnotation(InjectWith.class);
                if (with == null) continue;
                injectors.add(new FieldInjector(ioc, field));
            }
        }
        if (injectors.size() == 0) {
            return Collections.emptyList();
        }
        return injectors;
    }

    public static Object getBean(Ioc ioc, BeanDefine beanDefine) {
        ClassDefine classDefine = ClassDefine.create(beanDefine.getType());
        List<FieldInjector> fieldInjectors = IocKit.getInjectFields(ioc, classDefine);
        Object bean = beanDefine.getBean();
        for (FieldInjector fieldInjector : fieldInjectors) {
            fieldInjector.injection(bean);
        }
        return bean;
    }
}

