/*
 * Decompiled with CFR 0.152.
 */
package com.blade.ioc;

import blade.kit.Assert;
import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import com.blade.ioc.BeanDefine;
import com.blade.ioc.Ioc;
import com.blade.ioc.IocKit;
import com.blade.ioc.loader.IocLoader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SampleIoc
implements Ioc {
    private static final Logger LOGGER = LoggerFactory.getLogger(Ioc.class);
    private final Map<String, BeanDefine> pool = new HashMap<String, BeanDefine>();

    @Override
    public void load(IocLoader loader) {
        loader.load(this);
    }

    @Override
    public void addBean(Object bean) {
        Assert.notNull((Object)bean);
        this.addBean(bean.getClass().getName(), bean);
    }

    public void addBean(Class<?> beanClass, Object bean) {
        Assert.notNull(beanClass);
        this.addBean(beanClass.getName(), bean);
    }

    @Override
    public void addBean(String name, Object bean) {
        Assert.notNull((Object)bean);
        BeanDefine beanDefine = new BeanDefine(bean);
        this.addBean(name, beanDefine);
        Class<?>[] interfaces = beanDefine.getType().getInterfaces();
        if (interfaces.length > 0) {
            for (Class<?> interfaceClazz : interfaces) {
                this.addBean(interfaceClazz.getName(), beanDefine);
            }
        }
    }

    @Override
    public void setBean(Class<?> type, Object proxyBean) {
        Assert.notNull((Object)proxyBean);
        BeanDefine beanDefine = this.pool.get(type.getName());
        if (beanDefine != null) {
            beanDefine.setBean(proxyBean);
        } else {
            beanDefine = new BeanDefine(proxyBean, type);
        }
        this.pool.put(type.getName(), beanDefine);
    }

    public void addBean(String name, BeanDefine beanDefine) {
        Assert.notNull((Object)name);
        Assert.notNull((Object)beanDefine);
        LOGGER.debug("addBean: {}", new Object[]{name});
        if (this.pool.put(name, beanDefine) != null) {
            LOGGER.warn("Duplicated Bean: {}", new Object[]{name});
        }
    }

    @Override
    public void addBean(Class<?> type) {
        this.addBean(type, true);
    }

    public void addBean(Class<?> type, boolean singleton) {
        Assert.notNull(type);
        this.addBean(type.getName(), type, singleton);
    }

    public void addBean(String name, Class<?> beanClass, boolean singleton) {
        Class<?>[] interfaces;
        Assert.notNull((Object)name);
        Assert.notNull(beanClass);
        Assert.isFalse((boolean)beanClass.isInterface(), (String)"Must not be interface: %s", (Object[])new Object[]{beanClass.getName()});
        Assert.isFalse((boolean)Modifier.isAbstract(beanClass.getModifiers()), (String)"Must not be abstract class: %s", (Object[])new Object[]{beanClass.getName()});
        LOGGER.debug("addBean: {} = {}", new Object[]{name, beanClass.getName()});
        BeanDefine beanDefine = this.getBeanDefine(beanClass, singleton);
        if (this.pool.put(name, beanDefine) != null) {
            LOGGER.warn("Duplicated Bean: {}", new Object[]{name});
        }
        if ((interfaces = beanClass.getInterfaces()).length > 0) {
            for (Class<?> interfaceClazz : interfaces) {
                if (null != this.getBean(interfaceClazz)) break;
                this.addBean(interfaceClazz.getName(), beanDefine);
            }
        }
    }

    private BeanDefine getBeanDefine(Class<?> beanClass, boolean singleton) {
        try {
            Object object = beanClass.newInstance();
            return new BeanDefine(object, beanClass, singleton);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public <T> T getBean(Class<T> type) {
        Object bean = this.getBean(type.getName());
        return type.cast(bean);
    }

    @Override
    public Object getBean(String name) {
        BeanDefine beanDefine = this.pool.get(name);
        if (beanDefine == null) {
            return null;
        }
        return IocKit.getBean(this, beanDefine);
    }

    @Override
    public List<Object> getBeans() {
        Set<String> beanNames = this.getBeanNames();
        ArrayList<Object> beans = new ArrayList<Object>(beanNames.size());
        for (String beanName : beanNames) {
            Object bean = this.getBean(beanName);
            if (null == bean) continue;
            beans.add(bean);
        }
        return beans;
    }

    @Override
    public Set<String> getBeanNames() {
        return this.pool.keySet();
    }

    @Override
    public void clearAll() {
        this.pool.clear();
    }
}

