/*
 * Decompiled with CFR 0.152.
 */
package com.blade.loader;

import blade.kit.Assert;
import blade.kit.StringKit;
import blade.kit.config.Config;
import com.blade.loader.BladeConfig;

public final class Configurator {
    public static void init(BladeConfig bladeConfig, Config config) {
        Assert.notNull((Object)bladeConfig);
        Assert.notNull((Object)config);
        Boolean dev = config.getBoolean("blade.dev");
        Boolean httpCache = config.getBoolean("blade.http.cache");
        Boolean httpXss = config.getBoolean("blade.http.xss");
        String httpEncoding = config.getString("blade.http.encoding");
        String httpFilters = config.getString("blade.http.filters");
        String basePackage = config.getString("blade.basepackage");
        if (null != dev) {
            bladeConfig.setDev(dev);
        }
        if (null != httpCache) {
            bladeConfig.setHttpCache(httpCache);
        }
        if (StringKit.isNotBlank((String)httpEncoding)) {
            bladeConfig.setEncoding(httpEncoding);
        }
        if (null != httpXss) {
            bladeConfig.setHttpXss(httpXss);
        }
        if (StringKit.isNotBlank((String)httpFilters)) {
            bladeConfig.setStaticFolders(httpFilters.split(","));
        }
        if (StringKit.isNotBlank((String)basePackage)) {
            bladeConfig.setBasePackage(basePackage);
            bladeConfig.addIocPackages(basePackage + ".service.*");
            bladeConfig.addRoutePackages(basePackage + ".controller");
            bladeConfig.setInterceptorPackage(basePackage + ".interceptor");
        }
    }
}

