/*
 * Decompiled with CFR 0.152.
 */
package com.blade.route;

import blade.kit.CollectionKit;
import blade.kit.StringKit;
import blade.kit.reflect.ReflectKit;
import blade.kit.resource.ClassPathClassReader;
import blade.kit.resource.ClassReader;
import com.blade.Blade;
import com.blade.interceptor.Interceptor;
import com.blade.interceptor.annotation.Intercept;
import com.blade.route.Routers;
import com.blade.route.annotation.Path;
import com.blade.route.annotation.Route;
import com.blade.web.http.HttpMethod;
import com.blade.web.http.Request;
import com.blade.web.http.Response;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;

public class RouteBuilder {
    private ClassReader classReader;
    private Routers routers;
    private String[] routePackages;
    private String interceptorPackage;

    public RouteBuilder(Blade blade) {
        this.routers = blade.routers();
        this.routePackages = blade.routePackages();
        this.interceptorPackage = blade.interceptorPackage();
        this.classReader = new ClassPathClassReader();
    }

    public void building() {
        if (null != this.routePackages && this.routePackages.length > 0) {
            this.buildRoute(this.routePackages);
        }
        if (StringKit.isNotBlank((String)this.interceptorPackage)) {
            this.buildInterceptor(this.interceptorPackage);
        }
    }

    private void buildInterceptor(String ... interceptorPackages) {
        Set classes = null;
        for (String packageName : interceptorPackages) {
            classes = this.classReader.getClass(packageName, Interceptor.class, false);
            if (!CollectionKit.isNotEmpty((Collection)classes)) continue;
            for (Class interceptorClazz : classes) {
                this.parseInterceptor(interceptorClazz);
            }
        }
    }

    private void buildRoute(String ... routePackages) {
        Set classes = null;
        for (String packageName : routePackages) {
            classes = this.classReader.getClassByAnnotation(packageName, Path.class, true);
            if (!CollectionKit.isNotEmpty((Collection)classes)) continue;
            for (Class pathClazz : classes) {
                this.parseRouter(pathClazz);
            }
        }
    }

    private void parseInterceptor(Class<?> interceptor) {
        boolean hasInterface = ReflectKit.hasInterface(interceptor, Interceptor.class);
        if (null == interceptor || !hasInterface) {
            return;
        }
        Intercept intercept = interceptor.getAnnotation(Intercept.class);
        String partten = "/.*";
        if (null != intercept) {
            partten = intercept.value();
        }
        try {
            Method before = interceptor.getMethod("before", Request.class, Response.class);
            Method after = interceptor.getMethod("after", Request.class, Response.class);
            this.buildInterceptor(partten, interceptor, before, HttpMethod.BEFORE);
            this.buildInterceptor(partten, interceptor, after, HttpMethod.AFTER);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private void parseRouter(Class<?> router) {
        Method[] methods = router.getMethods();
        if (null == methods || methods.length == 0) {
            return;
        }
        String nameSpace = router.getAnnotation(Path.class).value();
        String suffix = router.getAnnotation(Path.class).suffix();
        for (Method method : methods) {
            Route mapping = method.getAnnotation(Route.class);
            if (null == mapping) continue;
            String path = this.getRoutePath(mapping.value(), nameSpace, suffix);
            HttpMethod methodType = mapping.method();
            this.buildRoute(router, method, path, methodType);
            String[] paths = mapping.values();
            if (null == paths || paths.length <= 0) continue;
            for (String value : paths) {
                String pathV = this.getRoutePath(value, nameSpace, suffix);
                this.buildRoute(router, method, pathV, methodType);
            }
        }
    }

    private String getRoutePath(String value, String nameSpace, String suffix) {
        String path = value.startsWith("/") ? value : "/" + value;
        path = nameSpace + path;
        path = path.replaceAll("[/]+", "/");
        path = path.length() > 1 && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        path = path + suffix;
        return path;
    }

    private void buildRoute(Class<?> clazz, Method execMethod, String path, HttpMethod method) {
        this.routers.buildRoute(path, clazz, execMethod, method);
    }

    private void buildInterceptor(String path, Class<?> clazz, Method execMethod, HttpMethod method) {
        this.routers.buildRoute(path, clazz, execMethod, method);
    }
}

