/*
 * Decompiled with CFR 0.152.
 */
package com.blade.route;

import com.blade.route.Route;
import com.blade.route.Routers;
import com.blade.web.http.HttpMethod;
import com.blade.web.http.Path;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RouteMatcher {
    private Map<String, Route> routes = null;
    private Map<String, Route> interceptors = null;
    private Set<String> routeKeys = null;
    private List<Route> interceptorRoutes = new ArrayList<Route>();

    public RouteMatcher(Routers routers) {
        this.routes = routers.getRoutes();
        this.interceptors = routers.getInterceptors();
        this.routeKeys = this.routes.keySet();
        Collection<Route> inters = this.interceptors.values();
        if (null != inters && inters.size() > 0) {
            this.interceptorRoutes.addAll(inters);
        }
    }

    public Route getRoute(String httpMethod, String path) {
        String cleanPath = this.parsePath(path);
        String routeKey = path + "#" + httpMethod.toUpperCase();
        Route route = this.routes.get(routeKey);
        if (null != route) {
            return route;
        }
        route = this.routes.get(path + "#ALL");
        if (null != route) {
            return route;
        }
        ArrayList<Route> matchRoutes = new ArrayList<Route>();
        for (String key : this.routeKeys) {
            String[] keyArr = key.split("#");
            HttpMethod routeMethod = HttpMethod.valueOf(keyArr[1]);
            if (!this.matchesPath(keyArr[0], cleanPath) || routeMethod != HttpMethod.ALL && HttpMethod.valueOf(httpMethod) != routeMethod) continue;
            route = this.routes.get(key);
            matchRoutes.add(route);
        }
        this.giveMatch(path, matchRoutes);
        return matchRoutes.size() > 0 ? (Route)matchRoutes.get(0) : null;
    }

    public List<Route> getBefore(String path) {
        ArrayList<Route> befores = new ArrayList<Route>();
        String cleanPath = this.parsePath(path);
        for (Route route : this.interceptorRoutes) {
            if (!this.matchesPath(route.getPath(), cleanPath) || route.getHttpMethod() != HttpMethod.BEFORE) continue;
            befores.add(route);
        }
        this.giveMatch(path, befores);
        return befores;
    }

    public List<Route> getAfter(String path) {
        ArrayList<Route> afters = new ArrayList<Route>();
        String cleanPath = this.parsePath(path);
        for (Route route : this.interceptorRoutes) {
            if (!this.matchesPath(route.getPath(), cleanPath) || route.getHttpMethod() != HttpMethod.AFTER) continue;
            afters.add(route);
        }
        this.giveMatch(path, afters);
        return afters;
    }

    private void giveMatch(final String uri, List<Route> routes) {
        Collections.sort(routes, new Comparator<Route>(){

            @Override
            public int compare(Route o1, Route o2) {
                if (o2.getPath().equals(uri)) {
                    return o2.getPath().indexOf(uri);
                }
                return -1;
            }
        });
    }

    private boolean matchesPath(String routePath, String pathToMatch) {
        routePath = routePath.replaceAll(":(\\w+)", "([^#/?]+)");
        return pathToMatch.matches("(?i)" + routePath);
    }

    private String parsePath(String path) {
        path = Path.fixPath(path);
        try {
            URI uri = new URI(path);
            return uri.getPath();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

