/*
 * Decompiled with CFR 0.152.
 */
package com.blade.route;

import blade.kit.Assert;
import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import com.blade.route.Route;
import com.blade.route.RouteHandler;
import com.blade.web.http.HttpMethod;
import com.blade.web.http.Request;
import com.blade.web.http.Response;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Routers {
    private Logger LOGGER = LoggerFactory.getLogger(Routers.class);
    private Map<String, Route> routes = new HashMap<String, Route>();
    private Map<String, Route> interceptors = new HashMap<String, Route>();
    private static final String METHOD_NAME = "handle";

    public Map<String, Route> getRoutes() {
        return this.routes;
    }

    public Map<String, Route> getInterceptors() {
        return this.interceptors;
    }

    public void addRoute(Route route) {
        String path = route.getPath();
        HttpMethod httpMethod = route.getHttpMethod();
        String key = path + "#" + httpMethod.toString();
        if (null != this.routes.get(key)) {
            this.LOGGER.warn("\tRoute {} -> {} has exist", new Object[]{path, httpMethod.toString()});
        }
        if (httpMethod == HttpMethod.BEFORE || httpMethod == HttpMethod.AFTER) {
            if (null != this.interceptors.get(key)) {
                this.LOGGER.warn("\tInterceptor {} -> {} has exist", new Object[]{path, httpMethod.toString()});
            }
            this.interceptors.put(key, route);
            this.LOGGER.debug("Add Interceptor: {}", new Object[]{route});
        } else {
            this.routes.put(key, route);
            this.LOGGER.debug("Add Route: {}", new Object[]{route});
        }
    }

    public void addRoutes(List<Route> routes) {
        Assert.notNull(routes);
        for (Route route : routes) {
            this.addRoute(route);
        }
    }

    public void addRoute(HttpMethod httpMethod, String path, RouteHandler handler, String methodName) throws NoSuchMethodException {
        Class<?> handleType = handler.getClass();
        Method method = handleType.getMethod(methodName, Request.class, Response.class);
        this.addRoute(httpMethod, path, handler, RouteHandler.class, method);
    }

    public void addRoute(HttpMethod httpMethod, String path, Object controller, Class<?> controllerType, Method method) {
        Assert.notNull((Object)((Object)httpMethod));
        Assert.notBlank((CharSequence)path);
        Assert.notNull((Object)method);
        String key = path + "#" + httpMethod.toString();
        if (null != this.routes.get(key)) {
            this.LOGGER.warn("\tRoute {} -> {} has exist", new Object[]{path, httpMethod.toString()});
        }
        Route route = new Route(httpMethod, path, controller, controllerType, method);
        if (httpMethod == HttpMethod.BEFORE || httpMethod == HttpMethod.AFTER) {
            if (null != this.interceptors.get(key)) {
                this.LOGGER.warn("\tInterceptor {} -> {} has exist", new Object[]{path, httpMethod.toString()});
            }
            this.interceptors.put(key, route);
            this.LOGGER.info("Add Interceptor: {}", new Object[]{route});
        } else {
            this.routes.put(key, route);
            this.LOGGER.info("Add Route: {}", new Object[]{route});
        }
    }

    public void route(String path, RouteHandler handler, HttpMethod httpMethod) {
        try {
            this.addRoute(httpMethod, path, handler, METHOD_NAME);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void route(String[] paths, RouteHandler handler, HttpMethod httpMethod) {
        for (String path : paths) {
            this.route(path, handler, httpMethod);
        }
    }

    public void route(String path, Object target, String methodName) {
        try {
            Assert.notNull((Object)path, (String)"Route path not is null!");
            Assert.notNull((Object)target, (String)"Target Controller not is null!");
            Assert.notNull((Object)methodName, (String)"Method name not is null");
            Method method = target.getClass().getMethod(methodName, Request.class, Response.class);
            this.addRoute(HttpMethod.ALL, path, target, target.getClass(), method);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public void route(String path, Class<?> clazz, String methodName) {
        Assert.notNull((Object)path, (String)"Route path not is null!");
        Assert.notNull(clazz, (String)"Class Type not is null!");
        Assert.notNull((Object)methodName, (String)"Method name not is null");
        HttpMethod httpMethod = HttpMethod.ALL;
        if (methodName.indexOf(":") != -1) {
            String[] methodArr = methodName.split(":");
            httpMethod = HttpMethod.valueOf(methodArr[0].toUpperCase());
            methodName = methodArr[1];
        }
        try {
            Method method = clazz.getMethod(methodName, Request.class, Response.class);
            this.addRoute(httpMethod, path, null, clazz, method);
        }
        catch (NoSuchMethodException e) {
            try {
                Method method = clazz.getMethod(methodName, Response.class, Request.class);
                this.addRoute(httpMethod, path, null, clazz, method);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public void route(String path, Class<?> clazz, String methodName, HttpMethod httpMethod) {
        try {
            Assert.notNull((Object)path, (String)"Route path not is null!");
            Assert.notNull(clazz, (String)"Class Type not is null!");
            Assert.notNull((Object)methodName, (String)"Method name not is null");
            Assert.notNull((Object)((Object)httpMethod), (String)"Request Method not is null");
            Method method = clazz.getMethod(methodName, Request.class, Response.class);
            this.addRoute(httpMethod, path, null, clazz, method);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public void buildRoute(String path, Class<?> clazz, Method method, HttpMethod httpMethod) {
        this.addRoute(httpMethod, path, null, clazz, method);
    }
}

