/*
 * Decompiled with CFR 0.152.
 */
package com.blade.route.loader;

import blade.kit.IOKit;
import com.blade.route.Route;
import com.blade.route.RouteException;
import com.blade.route.loader.ClassPathControllerLoader;
import com.blade.route.loader.ControllerLoader;
import com.blade.route.loader.RouteLoader;
import com.blade.web.http.HttpMethod;
import com.blade.web.http.Request;
import com.blade.web.http.Response;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class AbstractFileRouteLoader
implements RouteLoader {
    private ControllerLoader controllerLoader = new ClassPathControllerLoader();

    protected abstract InputStream getInputStream() throws Exception;

    @Override
    public List<Route> load() throws ParseException, RouteException {
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
        }
        catch (Exception e) {
            throw new RouteException("Loading the route config file error: " + e.getMessage(), e);
        }
        try {
            return this.load(inputStream);
        }
        catch (IOException e) {
            throw new RouteException("Loading the route config file error: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Route> load(InputStream inputStream) throws ParseException, IOException {
        int line = 0;
        ArrayList<Route> routes = new ArrayList<Route>();
        BufferedReader in = null;
        try {
            String input;
            in = new BufferedReader(new InputStreamReader(inputStream));
            while ((input = in.readLine()) != null) {
                ++line;
                if ((input = input.trim()).equals("") || input.startsWith(".")) continue;
                Route route = this.parse(input, line);
                routes.add(route);
            }
        }
        catch (Throwable throwable) {
            IOKit.closeQuietly(in);
            throw throwable;
        }
        IOKit.closeQuietly((Closeable)in);
        return routes;
    }

    private Route parse(String input, int line) throws ParseException {
        StringTokenizer st = new StringTokenizer(input, " \t");
        if (st.countTokens() != 3) {
            throw new ParseException("Unrecognized format", line);
        }
        String httpMethod = this.validateHttpMethod(st.nextToken().trim(), line);
        String path = this.validatePath(st.nextToken().trim(), line);
        String controllerAndMethod = this.validateControllerAndMethod(st.nextToken().trim(), line);
        int hashPos = controllerAndMethod.indexOf(".");
        String controllerName = controllerAndMethod.substring(0, hashPos);
        String controllerMethod = controllerAndMethod.substring(hashPos + 1);
        return this.buildRoute(httpMethod, path, controllerName, controllerMethod);
    }

    private String validateHttpMethod(String httpMethod, int line) throws ParseException {
        if (!(httpMethod.equalsIgnoreCase("GET") || httpMethod.equalsIgnoreCase("POST") || httpMethod.equalsIgnoreCase("PUT") || httpMethod.equalsIgnoreCase("DELETE"))) {
            throw new ParseException("Unrecognized HTTP method: " + httpMethod, line);
        }
        return httpMethod;
    }

    private String validatePath(String path, int line) throws ParseException {
        if (!path.startsWith("/")) {
            throw new ParseException("Path must start with '/'", line);
        }
        boolean openedKey = false;
        for (int i = 0; i < path.length(); ++i) {
            boolean validChar = this.isValidCharForPath(path.charAt(i), openedKey);
            if (!validChar) {
                throw new ParseException(path, i);
            }
            if (path.charAt(i) == '{') {
                openedKey = true;
            }
            if (path.charAt(i) != '}') continue;
            openedKey = false;
        }
        return path;
    }

    private boolean isValidCharForPath(char c, boolean openedKey) {
        char[] invalidChars;
        for (char invalidChar : invalidChars = new char[]{'?', '.', ' '}) {
            if (c != invalidChar) continue;
            return false;
        }
        if (openedKey) {
            char[] moreInvalidChars;
            for (char invalidChar : moreInvalidChars = new char[]{'/', '{'}) {
                if (c != invalidChar) continue;
                return false;
            }
        }
        return true;
    }

    private String validateControllerAndMethod(String beanAndMethod, int line) throws ParseException {
        int hashPos = beanAndMethod.indexOf(".");
        if (hashPos == -1) {
            throw new ParseException("Unrecognized format for '" + beanAndMethod + "'", line);
        }
        return beanAndMethod;
    }

    private Route buildRoute(String httpMethod, String path, String controllerName, String methodName) throws RouteException {
        Object controller = this.controllerLoader.load(controllerName);
        Class<?> controllerType = controller.getClass();
        Method method = this.getMethod(controllerType, methodName);
        return new Route(HttpMethod.valueOf(httpMethod.toUpperCase()), path, controller, controllerType, method);
    }

    private Method getMethod(Class<?> controllerType, String methodName) throws RouteException {
        try {
            return controllerType.getMethod(methodName, Request.class, Response.class);
        }
        catch (Exception e) {
            throw new RouteException(e);
        }
    }

    public void setBasePackage(String basePackage) {
        this.controllerLoader = new ClassPathControllerLoader(basePackage);
    }

    public ControllerLoader getControllerLoader() {
        return this.controllerLoader;
    }

    public void setControllerLoader(ControllerLoader controllerLoader) {
        this.controllerLoader = controllerLoader;
    }
}

