/*
 * Decompiled with CFR 0.152.
 */
package com.blade.view.handle;

import blade.kit.json.JSONHelper;
import blade.kit.json.JSONValue;
import blade.kit.reflect.ConvertKit;
import blade.kit.reflect.ReflectKit;
import com.blade.ioc.Ioc;
import com.blade.route.Route;
import com.blade.view.template.ModelAndView;
import com.blade.web.DispatchKit;
import com.blade.web.http.Request;
import com.blade.web.http.Response;
import java.lang.reflect.Method;

public class RouteViewHandler {
    private Ioc ioc;

    public RouteViewHandler(Ioc ioc) {
        this.ioc = ioc;
    }

    public Object[] getArgs(Request request, Response response, Class<?>[] params) {
        int len = params.length;
        Object[] args = new Object[len];
        for (int i = 0; i < len; ++i) {
            Class<?> paramTypeClazz = params[i];
            if (paramTypeClazz.getName().equals(Request.class.getName())) {
                args[i] = request;
            }
            if (!paramTypeClazz.getName().equals(Response.class.getName())) continue;
            args[i] = response;
        }
        return args;
    }

    public void handle(Request request, Response response, Route route) {
        Method actionMethod = route.getAction();
        Object target = route.getTarget();
        int len = actionMethod.getParameterTypes().length;
        actionMethod.setAccessible(true);
        try {
            Object returnParam = null;
            if (len > 0) {
                Object[] args = this.getArgs(request, response, actionMethod.getParameterTypes());
                returnParam = ReflectKit.invokeMehod((Object)target, (Method)actionMethod, (Object[])args);
            } else {
                returnParam = ReflectKit.invokeMehod((Object)target, (Method)actionMethod, (Object[])new Object[0]);
            }
            if (null != returnParam) {
                Class<?> returnType = returnParam.getClass();
                if (returnType == String.class) {
                    response.text(returnParam.toString());
                } else if (returnType == ModelAndView.class) {
                    ModelAndView modelAndView = (ModelAndView)returnParam;
                    response.render(modelAndView);
                } else if (ConvertKit.isBasicType(returnType)) {
                    response.text(returnParam.toString());
                } else {
                    JSONValue jsonValue = JSONHelper.objectAsJsonValue((Object)returnParam);
                    String json = jsonValue.toString();
                    response.json(json);
                }
            }
        }
        catch (Exception e) {
            request.abort();
            DispatchKit.printError(e, 500, response.raw());
        }
    }

    public boolean intercept(Request request, Response response, Route route) {
        Method actionMethod = route.getAction();
        Object target = route.getTarget();
        if (null == target) {
            Class<?> clazz = route.getAction().getDeclaringClass();
            target = this.ioc.getBean(clazz);
            route.setTarget(target);
        }
        int len = actionMethod.getParameterTypes().length;
        actionMethod.setAccessible(true);
        try {
            Class<?> returnType;
            Object returnParam = null;
            if (len > 0) {
                Object[] args = this.getArgs(request, response, actionMethod.getParameterTypes());
                returnParam = ReflectKit.invokeMehod((Object)target, (Method)actionMethod, (Object[])args);
            } else {
                returnParam = ReflectKit.invokeMehod((Object)target, (Method)actionMethod, (Object[])new Object[0]);
            }
            if (null != returnParam && ((returnType = returnParam.getClass()) == Boolean.class || returnType == Boolean.TYPE)) {
                return (Boolean)returnParam;
            }
            return true;
        }
        catch (Exception e) {
            request.abort();
            DispatchKit.printError(e, 500, response.raw());
            return false;
        }
    }
}

