/*
 * Decompiled with CFR 0.152.
 */
package com.blade.view.template;

import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import com.blade.context.BladeWebContext;
import com.blade.view.template.ModelAndView;
import com.blade.view.template.TemplateEngine;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class JspEngine
implements TemplateEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(JspEngine.class);
    private String viewPath = "/WEB-INF/";

    public JspEngine() {
    }

    public JspEngine(String viewPath) {
        this.viewPath = viewPath;
    }

    @Override
    public void render(ModelAndView modelAndView, Writer writer) {
        HttpServletRequest servletRequest = BladeWebContext.request().raw();
        HttpServletResponse servletResponse = BladeWebContext.response().raw();
        try {
            Map<String, Object> model = modelAndView.getModel();
            String realPath = this.viewPath + modelAndView.getView();
            if (null != model && !model.isEmpty()) {
                Set<String> keys = model.keySet();
                for (String key : keys) {
                    servletRequest.setAttribute(key, model.get(key));
                }
            }
            servletRequest.getRequestDispatcher(realPath).forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        catch (ServletException e) {
            e.printStackTrace();
            LOGGER.error("", (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("", (Throwable)e);
        }
    }
}

