/*
 * Decompiled with CFR 0.152.
 */
package com.blade.web;

import blade.kit.FileKit;
import blade.kit.StreamKit;
import com.blade.Blade;
import com.blade.web.http.HttpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;

public class DispatchKit {
    private static boolean isDev = Blade.me().isDev();
    private static final String HTML = "<!DOCTYPE html><html><head><meta charset='utf-8'><title>Blade Framework Error Page</title><style type='text/css'>*{margin:0;padding:0}.info{margin:0;padding:10px;color:#000;background-color:#f8edc2;height:60px;line-height:60px;border-bottom:5px solid #761226}.isa_error{margin:0;padding:10px;font-size:14px;font-weight:bold;background-color:#e0c9db;border-bottom:1px solid #000}.version{color:green;font-size:16px;font-weight:bold;padding:10px}</style></head><body><div class='info'><h3>%s</h3></div><div class='isa_error'><pre>";
    private static final String END = "</pre></div><div class='version'>Blade-1.6.0M1\uff08<a href='http://bladejava.com' target='_blank'>Blade Framework</a>\uff09 </div></body></html>";

    public static File getWebroot(ServletContext sc) {
        String dir = sc.getRealPath("/");
        if (dir == null) {
            try {
                URL url = sc.getResource("/");
                if (url == null || !"file".equals(url.getProtocol())) {
                    throw new IllegalStateException("Can't get webroot dir, url = " + url);
                }
                dir = URLDecoder.decode(url.getFile(), "utf-8");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return new File(dir);
    }

    public static void setNoCache(HttpServletResponse response) {
        response.setHeader("Buffer", "false");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 1L);
        response.setHeader("Cache-Control", "no-cache, no-store, max-age=0");
    }

    public static void setFileDownloadHeader(HttpServletResponse response, String fileName, String contentType) {
        if (contentType == null) {
            contentType = "application/x-download";
        }
        response.setContentType(contentType);
        try {
            String encodedfileName = new String(fileName.getBytes(), "ISO8859-1");
            response.setHeader("Content-Disposition", "attachment; filename=" + encodedfileName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void printError(Throwable err, int code, HttpServletResponse response) {
        err.printStackTrace();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(baos);
            if (isDev) {
                writer.println(String.format(HTML, err.getClass() + " : " + err.getMessage()));
                writer.println();
                err.printStackTrace(writer);
                writer.println(END);
            } else if (code == 404) {
                writer.write(err.getMessage());
            } else {
                writer.write("<html><head><title>500 Internal Error</title></head><body bgcolor=\"white\"><center><h1>500 Internal Error</h1></center><hr><center>blade 1.6.0M1</center></body></html>");
            }
            writer.close();
            response.setStatus(code);
            ByteArrayInputStream body = new ByteArrayInputStream(baos.toByteArray());
            DispatchKit.print(body, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void print(InputStream body, OutputStream out) throws IOException {
        StreamKit.io((InputStream)body, (OutputStream)out, (boolean)true, (boolean)true);
    }

    public static void printStatic(String uri, String realpath, HttpServletResponse httpResponse) {
        try {
            File file = new File(realpath);
            if (FileKit.exist((File)file)) {
                FileInputStream in = new FileInputStream(file);
                DispatchKit.print(in, (OutputStream)httpResponse.getOutputStream());
            } else {
                HttpException httpException = new HttpException(404, uri + " not found");
                DispatchKit.printError(httpException, 404, httpResponse);
            }
        }
        catch (FileNotFoundException e) {
            DispatchKit.printError(e, 404, httpResponse);
        }
        catch (IOException e) {
            DispatchKit.printError(e, 500, httpResponse);
        }
    }
}

