/*
 * Decompiled with CFR 0.152.
 */
package com.blade.web;

import blade.kit.StringKit;
import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import com.blade.Blade;
import com.blade.context.BladeWebContext;
import com.blade.ioc.Ioc;
import com.blade.route.Route;
import com.blade.route.RouteHandler;
import com.blade.route.RouteMatcher;
import com.blade.route.Routers;
import com.blade.view.handle.RouteViewHandler;
import com.blade.view.template.ModelAndView;
import com.blade.web.DispatchKit;
import com.blade.web.StaticFileFilter;
import com.blade.web.http.Path;
import com.blade.web.http.Request;
import com.blade.web.http.Response;
import com.blade.web.http.wrapper.ServletRequest;
import com.blade.web.http.wrapper.ServletResponse;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DispatcherHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DispatcherHandler.class);
    private Ioc ioc;
    private Blade blade;
    private ServletContext servletContext;
    private RouteMatcher routeMatcher;
    private StaticFileFilter staticFileFilter;
    private RouteViewHandler routeViewHandler;

    public DispatcherHandler(ServletContext servletContext, Routers routers) {
        this.servletContext = servletContext;
        this.blade = Blade.me();
        this.ioc = this.blade.ioc();
        this.routeMatcher = new RouteMatcher(routers);
        this.staticFileFilter = new StaticFileFilter(this.blade.staticFolder());
        this.routeViewHandler = new RouteViewHandler(this.ioc);
    }

    public void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        ServletResponse response = null;
        String method = httpRequest.getMethod();
        String uri = Path.getRelativePath(httpRequest.getRequestURI(), this.servletContext.getContextPath());
        if (this.staticFileFilter.isStatic(uri)) {
            LOGGER.debug("Request : {}\t{}", new Object[]{method, uri});
            String realpath = httpRequest.getServletContext().getRealPath(uri);
            DispatchKit.printStatic(uri, realpath, httpResponse);
            return;
        }
        LOGGER.info("Request : {}\t{}", new Object[]{method, uri});
        try {
            ServletRequest request = new ServletRequest(httpRequest);
            response = new ServletResponse(httpResponse, this.blade.templateEngine());
            BladeWebContext.setContext(this.servletContext, request, response);
            Route route = this.routeMatcher.getRoute(method, uri);
            if (route != null) {
                request.setRoute(route);
                List<Route> befores = this.routeMatcher.getBefore(uri);
                boolean result = this.invokeInterceptor(request, response, befores);
                if (result) {
                    this.routeHandle(request, response, route);
                    if (!request.isAbort()) {
                        List<Route> afters = this.routeMatcher.getAfter(uri);
                        this.invokeInterceptor(request, response, afters);
                    }
                }
            } else {
                this.render404(response, uri);
            }
            return;
        }
        catch (Exception e) {
            DispatchKit.printError(e, 500, httpResponse);
            return;
        }
    }

    private void render404(Response response, String uri) {
        String view404 = this.blade.view404();
        if (StringKit.isNotBlank((String)view404)) {
            ModelAndView modelAndView = new ModelAndView(view404);
            modelAndView.add("viewName", uri);
            response.render(modelAndView);
        } else {
            response.status(404);
            response.html(String.format("<html><head><title>404 Not Found</title></head><body bgcolor=\"white\"><center><h1>[ %s ] Not Found</h1></center><hr><center>blade 1.6.0M1</center></body></html>", uri));
        }
    }

    private boolean invokeInterceptor(Request request, Response response, List<Route> interceptors) {
        for (Route route : interceptors) {
            boolean flag = this.routeViewHandler.intercept(request, response, route);
            if (flag) continue;
            return false;
        }
        return true;
    }

    private void routeHandle(Request request, Response response, Route route) {
        Object target = route.getTarget();
        if (null == target) {
            Class<?> clazz = route.getAction().getDeclaringClass();
            target = this.ioc.getBean(clazz);
            route.setTarget(target);
        }
        request.initPathParams(route.getPath());
        BladeWebContext.setContext(this.servletContext, request, response);
        if (route.getTargetType() == RouteHandler.class) {
            RouteHandler routeHandler = (RouteHandler)target;
            routeHandler.handle(request, response);
        } else {
            this.routeViewHandler.handle(request, response, route);
        }
    }
}

