/*
 * Decompiled with CFR 0.152.
 */
package com.blade.web.http.wrapper;

import blade.kit.Assert;
import com.blade.context.BladeWebContext;
import com.blade.view.template.ModelAndView;
import com.blade.view.template.TemplateEngine;
import com.blade.web.http.Path;
import com.blade.web.http.Request;
import com.blade.web.http.Response;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class ServletResponse
implements Response {
    private HttpServletResponse response;
    private boolean written = false;
    private TemplateEngine render;

    public ServletResponse(HttpServletResponse response, TemplateEngine render) {
        this.response = response;
        this.render = render;
    }

    @Override
    public HttpServletResponse raw() {
        return this.response;
    }

    @Override
    public int status() {
        return this.response.getStatus();
    }

    @Override
    public Response status(int status) {
        this.response.setStatus(status);
        return this;
    }

    @Override
    public Response badRequest() {
        this.response.setStatus(400);
        return this;
    }

    @Override
    public Response unauthorized() {
        this.response.setStatus(401);
        return this;
    }

    @Override
    public Response notFound() {
        this.response.setStatus(404);
        return this;
    }

    @Override
    public Response conflict() {
        this.response.setStatus(409);
        return this;
    }

    @Override
    public String contentType() {
        return this.response.getContentType();
    }

    @Override
    public Response contentType(String contentType) {
        this.response.setContentType(contentType);
        return this;
    }

    @Override
    public String header(String name) {
        return this.response.getHeader(name);
    }

    @Override
    public Response header(String name, String value) {
        this.response.setHeader(name, value);
        return this;
    }

    @Override
    public Response cookie(Cookie cookie) {
        this.response.addCookie(cookie);
        return this;
    }

    @Override
    public Response cookie(String name, String value) {
        return this.cookie(name, value);
    }

    @Override
    public Response cookie(String name, String value, int maxAge) {
        return this.cookie(name, value, maxAge, false);
    }

    @Override
    public Response cookie(String name, String value, int maxAge, boolean secured) {
        return this.cookie(null, name, value, maxAge, secured);
    }

    @Override
    public Response cookie(String path, String name, String value, int maxAge, boolean secured) {
        Cookie cookie = new Cookie(name, value);
        if (null != path) {
            cookie.setPath(path);
        }
        cookie.setMaxAge(maxAge);
        cookie.setSecure(secured);
        this.response.addCookie(cookie);
        return this;
    }

    @Override
    public Response removeCookie(Cookie cookie) {
        cookie.setMaxAge(0);
        this.response.addCookie(this.map(cookie));
        return this;
    }

    Cookie map(Cookie cookie) {
        Cookie servletCookie = new Cookie(cookie.getName(), cookie.getValue());
        servletCookie.setMaxAge(cookie.getMaxAge());
        if (cookie.getPath() != null) {
            servletCookie.setPath(cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            servletCookie.setDomain(cookie.getDomain());
        }
        servletCookie.setHttpOnly(cookie.isHttpOnly());
        servletCookie.setSecure(cookie.getSecure());
        return servletCookie;
    }

    @Override
    public Response removeCookie(String name) {
        Cookie cookie = new Cookie(name, "");
        cookie.setMaxAge(0);
        this.response.addCookie(cookie);
        return this;
    }

    @Override
    public Response text(String text) {
        try {
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setContentType("text/plain;charset=utf-8");
            this.response.getWriter().print(text);
            this.written = true;
            return this;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Response html(String html) {
        try {
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setContentType("text/html;charset=utf-8");
            PrintWriter out = this.response.getWriter();
            out.print(html);
            out.flush();
            out.close();
            this.written = true;
            return this;
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Response json(String json) {
        Request request = BladeWebContext.request();
        String userAgent = request.userAgent();
        if (userAgent.contains("MSIE")) {
            this.response.setContentType("text/html;charset=utf-8");
        } else {
            this.response.setContentType("application/json;charset=utf-8");
        }
        try {
            this.response.setHeader("Cache-Control", "no-cache");
            PrintWriter out = this.response.getWriter();
            out.print(json);
            out.flush();
            out.close();
            this.written = true;
            return this;
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Response xml(String xml) {
        try {
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setContentType("text/xml;charset=utf-8");
            PrintWriter out = this.response.getWriter();
            out.print(xml);
            out.flush();
            out.close();
            this.written = true;
            return this;
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ServletOutputStream outputStream() throws IOException {
        return this.response.getOutputStream();
    }

    @Override
    public Response render(String view) {
        try {
            Assert.notBlank((CharSequence)view, (String)"view not is null", (Object[])new Object[0]);
            String viewPath = Path.cleanPath(view);
            ModelAndView modelAndView = new ModelAndView(viewPath);
            this.render.render(modelAndView, this.response.getWriter());
            return this;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Response render(ModelAndView modelAndView) {
        try {
            Assert.notNull((Object)modelAndView, (String)"ModelAndView not is null!");
            Assert.notBlank((CharSequence)modelAndView.getView(), (String)"view not is null", (Object[])new Object[0]);
            String viewPath = Path.cleanPath(modelAndView.getView());
            modelAndView.setView(viewPath);
            this.render.render(modelAndView, this.response.getWriter());
            return this;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void redirect(String path) {
        try {
            this.response.sendRedirect(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void go(String path) {
        try {
            String ctx = BladeWebContext.servletContext().getContextPath();
            String location = Path.fixPath(ctx + path);
            this.response.sendRedirect(location);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isWritten() {
        return this.written;
    }
}

