/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import blade.kit.CollectionKit;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanKit {
    public static <T> T mapToBean(Map<String, Object> map, Class<T> clazz) {
        T object = null;
        try {
            PropertyDescriptor[] propertyDescriptors;
            object = clazz.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (!map.containsKey(key)) continue;
                Object value = map.get(key);
                Method setter = property.getWriteMethod();
                setter.invoke(object, value);
            }
        }
        catch (Exception e) {
            System.out.println("map covert to bean error\uff1a" + e);
        }
        return object;
    }

    public static <T> Map<String, Object> beanToMap(T obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method getter;
                Object value;
                String key = property.getName();
                if (key.equals("class") || null == (value = (getter = property.getReadMethod()).invoke(obj, new Object[0]))) continue;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            System.out.println("bean covert to map error\uff1a" + e);
        }
        return map;
    }

    public static <T> List<Map<String, Object>> toListMap(List<T> list) {
        if (null == list || list.size() == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> result = CollectionKit.newArrayList(list.size());
        for (T t : list) {
            Map<String, Object> map = BeanKit.beanToMap(t);
            result.add(map);
        }
        return result;
    }
}

