/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import blade.kit.ExceptionKit;
import blade.kit.StreamKit;
import blade.kit.StringKit;
import blade.kit.SystemKit;
import blade.kit.exception.IllegalPathException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class FileKit {
    private static final char COLON_CHAR = ':';
    private static final String UNC_PREFIX = "//";
    private static final String SLASH = "/";
    private static final char SLASH_CHAR = '/';
    private static final char BACKSLASH_CHAR = '\\';
    public static final String CURRENT_DIR = ".";
    public static final String UP_LEVEL_DIR = "..";
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final String TEMP_FILE_PREFIX = "temp_file_prefix-";
    private static final Pattern schemePrefixPattern = Pattern.compile("(file:/*[a-z]:)|(\\w+://.+?/)|((jar|zip):.+!/)|(\\w+:)", 2);

    public static File toFile(URL url) {
        if (url == null) {
            return null;
        }
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        String path = url.getPath();
        return path != null ? new File(path) : null;
    }

    public static boolean exist(String path) {
        return path == null ? false : new File(path).exists();
    }

    public static boolean exist(File file) {
        return file == null ? false : file.exists();
    }

    public static boolean exist(String directory, String regexp) {
        File file = new File(directory);
        if (!file.exists()) {
            return false;
        }
        String[] fileList = file.list();
        if (fileList == null) {
            return false;
        }
        for (String fileName : fileList) {
            if (!fileName.matches(regexp)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirectory(String path) {
        return path == null ? false : new File(path).isDirectory();
    }

    public static boolean isDirectory(File file) {
        return file == null ? false : file.isDirectory();
    }

    public static boolean isFile(String path) {
        return path == null ? false : new File(path).isDirectory();
    }

    public static boolean isFile(File file) {
        return file == null ? false : file.isDirectory();
    }

    public static File[] listDirSuffixFiles(File dir, final String suffix) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists() || dir.isFile()) {
            return null;
        }
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return StringKit.isEmpty(suffix) ? true : file.getName().endsWith(suffix);
            }
        });
    }

    public static File[] listDirSuffixFiles(String dirPath, final String suffix) {
        if (!FileKit.exist(dirPath)) {
            return null;
        }
        File dir = new File(dirPath);
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return StringKit.isEmpty(suffix) ? true : file.getName().endsWith(suffix);
            }
        });
    }

    public static File[] listDirAllConditionFiles(File dir, final boolean ... conditions) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists() || dir.isFile()) {
            return null;
        }
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (null == conditions || conditions.length == 0) {
                    return true;
                }
                for (boolean condition : conditions) {
                    if (condition) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public static File[] listDirAllConditionFiles(String dirPath, final boolean ... conditions) {
        if (!FileKit.exist(dirPath)) {
            return null;
        }
        File dir = new File(dirPath);
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (null == conditions || conditions.length == 0) {
                    return true;
                }
                for (boolean condition : conditions) {
                    if (condition) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public static File[] listDirAnyConditionFiles(File dir, final boolean ... conditions) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists() || dir.isFile()) {
            return null;
        }
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (null == conditions || conditions.length == 0) {
                    return true;
                }
                for (boolean condition : conditions) {
                    if (!condition) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public static File[] listDirAnyConditionFiles(String dirPath, final boolean ... conditions) {
        if (!FileKit.exist(dirPath)) {
            return null;
        }
        File dir = new File(dirPath);
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (null == conditions || conditions.length == 0) {
                    return true;
                }
                for (boolean condition : conditions) {
                    if (!condition) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public static File file(String filename) {
        if (filename == null) {
            return null;
        }
        return new File(filename);
    }

    public static File file(File parent, String child) {
        if (child == null) {
            return null;
        }
        return new File(parent, child);
    }

    public static byte[] readBytes(String file) throws IOException {
        return FileKit.readBytes(FileKit.file(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) throws IOException {
        byte[] byArray;
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        long length = file.length();
        if (length >= Integer.MAX_VALUE) {
            throw new RuntimeException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)length];
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            randomAccessFile.readFully(bytes);
            byArray = bytes;
        }
        catch (Throwable throwable) {
            StreamKit.close(randomAccessFile);
            throw throwable;
        }
        StreamKit.close(randomAccessFile);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileSize(String fileName) throws IOException {
        FileInputStream fis;
        block4: {
            int n;
            if (StringKit.isBlank(fileName)) {
                return 0;
            }
            File file = new File(fileName);
            fis = null;
            try {
                if (!file.exists()) break block4;
                fis = new FileInputStream(file);
                n = fis.available();
            }
            catch (Throwable throwable) {
                StreamKit.close(fis);
                throw throwable;
            }
            StreamKit.close(fis);
            return n;
        }
        int n = 0;
        StreamKit.close(fis);
        return n;
    }

    public static boolean createFile(String path) throws IOException {
        return FileKit.createFile(path, false);
    }

    public static boolean createFile(String path, boolean override) throws IOException {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        if (file.exists() && !override) {
            return false;
        }
        if (file.isDirectory()) {
            return file.mkdirs();
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        return file.createNewFile();
    }

    public static boolean createDir(String path, boolean override) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        if (file.exists() && !override) {
            return false;
        }
        return file.mkdirs();
    }

    public static boolean createDir(String path) {
        return FileKit.createDir(path, false);
    }

    public static boolean createParentDir(String path) {
        return FileKit.createParentDir(path, false);
    }

    public static boolean createParentDir(File file) {
        return FileKit.createParentDir(file, false);
    }

    public static boolean createParentDir(String path, boolean override) {
        if (path == null) {
            return false;
        }
        return FileKit.createDir(new File(path).getParent(), override);
    }

    public static boolean createParentDir(File file, boolean override) {
        if (file == null) {
            return false;
        }
        return FileKit.createDir(file.getParent(), override);
    }

    public static boolean delete(File file) {
        if (file == null) {
            return false;
        }
        return file.delete();
    }

    public static boolean delete(String path) {
        if (path == null) {
            return false;
        }
        return new File(path).delete();
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileKit.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteDir(String path) {
        if (path == null) {
            return false;
        }
        return FileKit.deleteDir(new File(path));
    }

    public static Date lastModifiedTime(File file) {
        if (!FileKit.exist(file)) {
            return null;
        }
        return new Date(file.lastModified());
    }

    public static Date lastModifiedTime(String path) {
        File file = new File(path);
        if (!FileKit.exist(file)) {
            return null;
        }
        return new Date(file.lastModified());
    }

    public static String normalizeAbsolutePath(String path) throws IllegalPathException {
        return FileKit.normalizePath(path, true, false, false);
    }

    public static String normalizeAbsolutePath(String path, boolean removeTrailingSlash) throws IllegalPathException {
        return FileKit.normalizePath(path, true, false, removeTrailingSlash);
    }

    public static String normalizeWindowsPath(String path) {
        return FileKit.normalizePath(path, true);
    }

    public static String normalizeUnixPath(String path) {
        return FileKit.normalizePath(path, false);
    }

    public static String normalizeRelativePath(String path) throws IllegalPathException {
        return FileKit.normalizePath(path, false, true, false);
    }

    public static String normalizeRelativePath(String path, boolean removeTrailingSlash) throws IllegalPathException {
        return FileKit.normalizePath(path, false, true, removeTrailingSlash);
    }

    public static String normalizePath(String path) throws IllegalPathException {
        return FileKit.normalizePath(path, false, false, false);
    }

    public static String normalizePath(String path, boolean removeTrailingSlash) throws IllegalPathException {
        return FileKit.normalizePath(path, false, false, removeTrailingSlash);
    }

    private static String normalizePath(String path, boolean forceAbsolute, boolean forceRelative, boolean removeTrailingSlash) throws IllegalPathException {
        char[] pathChars = StringKit.trimToEmpty(path).toCharArray();
        int length = pathChars.length;
        boolean startsWithSlash = false;
        boolean endsWithSlash = false;
        if (length > 0) {
            char firstChar = pathChars[0];
            char lastChar = pathChars[length - 1];
            startsWithSlash = firstChar == '/' || firstChar == '\\';
            endsWithSlash = lastChar == '/' || lastChar == '\\';
        }
        StringBuilder buf = new StringBuilder(length);
        boolean isAbsolutePath = forceAbsolute || !forceRelative && startsWithSlash;
        int index = startsWithSlash ? 0 : -1;
        int level = 0;
        if (isAbsolutePath) {
            buf.append(SLASH);
        }
        while (index < length && (index = FileKit.indexOfSlash(pathChars, index + 1, false)) != length) {
            int nextSlashIndex = FileKit.indexOfSlash(pathChars, index, true);
            String element = new String(pathChars, index, nextSlashIndex - index);
            index = nextSlashIndex;
            if (CURRENT_DIR.equals(element)) continue;
            if (UP_LEVEL_DIR.equals(element)) {
                if (level == 0) {
                    if (isAbsolutePath) {
                        throw new IllegalPathException(path);
                    }
                    buf.append("../");
                    continue;
                }
                buf.setLength(pathChars[--level]);
                continue;
            }
            pathChars[level++] = (char)buf.length();
            buf.append(element).append('/');
        }
        if (buf.length() > 0 && (!endsWithSlash || removeTrailingSlash)) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private static int indexOfSlash(char[] chars, int beginIndex, boolean slash) {
        int i;
        for (i = beginIndex; i < chars.length; ++i) {
            char ch = chars[i];
            if (slash ? ch == '/' || ch == '\\' : ch != '/' && ch != '\\') break;
        }
        return i;
    }

    public static String getAbsolutePathBasedOn(String basedir, String path) throws IllegalPathException {
        boolean isAbsolutePath = false;
        if ((path = StringKit.trimToEmpty(path)).length() > 0) {
            char firstChar = path.charAt(0);
            boolean bl = isAbsolutePath = firstChar == '/' || firstChar == '\\';
        }
        if (!isAbsolutePath) {
            path = path.length() > 0 ? StringKit.trimToEmpty(basedir) + SLASH + path : StringKit.trimToEmpty(basedir);
        }
        return FileKit.normalizeAbsolutePath(path);
    }

    public static String getSystemDependentAbsolutePathBasedOn(String basedir, String path) {
        boolean endsWithSlash = (path = StringKit.trimToEmpty(path)).endsWith(SLASH) || path.endsWith("\\");
        File pathFile = new File(path);
        if (pathFile.isAbsolute()) {
            path = pathFile.getAbsolutePath();
        } else {
            File baseFile = new File(basedir = StringKit.trimToEmpty(basedir));
            if (baseFile.isAbsolute()) {
                path = new File(baseFile, path).getAbsolutePath();
            } else {
                throw new IllegalPathException("Basedir is not absolute path: " + basedir);
            }
        }
        if (endsWithSlash) {
            path = path + '/';
        }
        return FileKit.normalizePath(path);
    }

    private static String getSystemDependentPrefix(String path, boolean isWindows) {
        if (isWindows) {
            if (path.startsWith(UNC_PREFIX)) {
                if (path.length() == UNC_PREFIX.length()) {
                    return null;
                }
                int index = path.indexOf(SLASH, UNC_PREFIX.length());
                if (index != -1) {
                    return path.substring(0, index);
                }
                return path;
            }
            if (path.length() > 1 && path.charAt(1) == ':') {
                return path.substring(0, 2).toUpperCase();
            }
        }
        return "";
    }

    public static String getRelativePath(String basedir, String path) throws IllegalPathException {
        int i;
        basedir = FileKit.normalizeAbsolutePath(basedir);
        path = FileKit.getAbsolutePathBasedOn(basedir, path);
        boolean endsWithSlash = path.endsWith(SLASH);
        String[] baseParts = StringKit.split(basedir, '/');
        String[] parts = StringKit.split(path, '/');
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < baseParts.length && i < parts.length && baseParts[i].equals(parts[i]); ++i) {
        }
        if (i < baseParts.length && i < parts.length) {
            for (int j = i; j < baseParts.length; ++j) {
                buf.append(UP_LEVEL_DIR).append('/');
            }
        }
        while (i < parts.length) {
            buf.append(parts[i]);
            if (i < parts.length - 1) {
                buf.append('/');
            }
            ++i;
        }
        if (endsWithSlash && buf.length() > 0 && buf.charAt(buf.length() - 1) != '/') {
            buf.append('/');
        }
        return buf.toString();
    }

    public static String getPathBasedOn(String basedir, String path) {
        return FileKit.getPathBasedOn(basedir, path, SystemKit.getOsInfo().isWindows());
    }

    public static String getWindowsPathBasedOn(String basedir, String path) {
        return FileKit.getPathBasedOn(basedir, path, true);
    }

    public static String getUnixPathBasedOn(String basedir, String path) {
        return FileKit.getPathBasedOn(basedir, path, false);
    }

    private static String getPathBasedOn(String basedir, String path, boolean isWindows) {
        if (path == null) {
            return null;
        }
        path = path.trim();
        String prefix = FileKit.getSystemDependentPrefix(path = path.replace('\\', '/'), isWindows);
        if (prefix == null) {
            return null;
        }
        if (prefix.length() > 0 || path.length() > prefix.length() && path.charAt(prefix.length()) == '/') {
            return FileKit.normalizePath(path, isWindows);
        }
        if (basedir == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(basedir.trim());
        if (basedir.length() > 0 && path.length() > 0 && basedir.charAt(basedir.length() - 1) != '/') {
            builder.append('/');
        }
        builder.append(path);
        return FileKit.normalizePath(builder.toString(), isWindows);
    }

    public static String getWindowsRelativePath(String basedir, String path) {
        return FileKit.getRelativePath(basedir, path, true);
    }

    public static String getUnixRelativePath(String basedir, String path) {
        return FileKit.getRelativePath(basedir, path, false);
    }

    private static String getRelativePath(String basedir, String path, boolean isWindows) {
        int i;
        if ((basedir = FileKit.normalizePath(basedir, isWindows)) == null) {
            return null;
        }
        String basePrefix = FileKit.getSystemDependentPrefix(basedir, isWindows);
        if (basePrefix == null || basePrefix.length() == 0 && !basedir.startsWith(SLASH)) {
            return null;
        }
        if ((path = FileKit.getPathBasedOn(basedir, path, isWindows)) == null) {
            return null;
        }
        String prefix = FileKit.getSystemDependentPrefix(path, isWindows);
        if (!basePrefix.equals(prefix)) {
            return path;
        }
        boolean endsWithSlash = path.endsWith(SLASH);
        String[] baseParts = StringKit.split(basedir.substring(basePrefix.length()), '/');
        String[] parts = StringKit.split(path.substring(prefix.length()), '/');
        StringBuilder builder = new StringBuilder();
        if (isWindows) {
            for (i = 0; i < baseParts.length && i < parts.length && baseParts[i].equalsIgnoreCase(parts[i]); ++i) {
            }
        } else {
            while (i < baseParts.length && i < parts.length && baseParts[i].equals(parts[i])) {
                ++i;
            }
        }
        if (i < baseParts.length && i < parts.length) {
            for (int j = i; j < baseParts.length; ++j) {
                builder.append(UP_LEVEL_DIR).append('/');
            }
        }
        while (i < parts.length) {
            builder.append(parts[i]);
            if (i < parts.length - 1) {
                builder.append('/');
            }
            ++i;
        }
        if (builder.length() == 0) {
            builder.append(CURRENT_DIR);
        }
        String relpath = builder.toString();
        if (endsWithSlash && !relpath.endsWith(SLASH)) {
            relpath = relpath + SLASH;
        }
        return relpath;
    }

    public static String getExtension(String fileName) {
        return FileKit.getExtension(fileName, null, false);
    }

    public static String getExtension(String fileName, boolean toLowerCase) {
        return FileKit.getExtension(fileName, null, toLowerCase);
    }

    public static String getExtension(String fileName, String nullExt) {
        return FileKit.getExtension(fileName, nullExt, false);
    }

    public static String getExtension(String fileName, String nullExt, boolean toLowerCase) {
        if ((fileName = StringKit.trimToNull(fileName)) == null) {
            return null;
        }
        fileName = fileName.replace('\\', '/');
        fileName = fileName.substring(fileName.lastIndexOf(SLASH) + 1);
        int index = fileName.lastIndexOf(CURRENT_DIR);
        String ext = null;
        if (index >= 0) {
            ext = StringKit.trimToNull(fileName.substring(index + 1));
        }
        if (ext == null) {
            return nullExt;
        }
        return toLowerCase ? ext.toLowerCase() : ext;
    }

    public static String normalizeExtension(String ext) {
        if ((ext = StringKit.trimToNull(ext)) != null && (ext = ext.toLowerCase()).startsWith(CURRENT_DIR)) {
            ext = StringKit.trimToNull(ext.substring(1));
        }
        return ext;
    }

    public static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileKit.indexOfLastSeparator(filename);
        return filename.substring(index + 1);
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = FileKit.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static String resolve(String url, String relativePath) {
        url = StringKit.trimToEmpty(url);
        Matcher m = schemePrefixPattern.matcher(url);
        int index = 0;
        if (m.find() && url.charAt((index = m.end()) - 1) == '/') {
            --index;
        }
        return url.substring(0, index) + FileKit.normalizeAbsolutePath(url.substring(index) + "/../" + relativePath);
    }

    public static File getResourcesFile(String resourceName) {
        URL url = FileKit.class.getResource(resourceName);
        if (url == null) {
            return null;
        }
        String filePath = url.getFile();
        return new File(filePath);
    }

    public static File getResourcesFile(URL url) {
        if (url == null) {
            return null;
        }
        String filePath = url.getFile();
        return new File(filePath);
    }

    public static File createAndReturnFile(String filename) throws IOException {
        File file = FileKit.newFile(filename);
        if (file != null && !file.canWrite()) {
            String dirName = file.getPath();
            int i = dirName.lastIndexOf(File.separator);
            if (i > -1) {
                dirName = dirName.substring(0, i);
                File dir = FileKit.newFile(dirName);
                dir.mkdirs();
            }
            file.createNewFile();
        }
        return file;
    }

    public static File newFile(String pathName) throws IOException {
        if (StringKit.isBlank(pathName)) {
            return null;
        }
        return new File(pathName).getCanonicalFile();
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        return FileKit.createTempDirectory(prefix, suffix, (File)null);
    }

    public static File createTempDirectory(String prefix, String suffix, String tempDirName) throws IOException {
        return FileKit.createTempDirectory(prefix, suffix, new File(tempDirName));
    }

    public static File createTempDirectory(String prefix, String suffix, File tempDir) throws IOException {
        File file = FileKit.doCreateTempFile(prefix, suffix, tempDir);
        file.delete();
        file.mkdir();
        return file;
    }

    public static File createTempFile() throws IOException {
        return FileKit.createTempFile(true);
    }

    public static File createTempFile(boolean create) throws IOException {
        return FileKit.createTempFile(TEMP_FILE_PREFIX, ".tmp", (File)null, create);
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileKit.createTempFile(prefix, suffix, (File)null, true);
    }

    public static File createTempFile(String prefix, String suffix, boolean create) throws IOException {
        return FileKit.createTempFile(prefix, suffix, (File)null, create);
    }

    public static File createTempFile(String prefix, String suffix, String tempDirName) throws IOException {
        return FileKit.createTempFile(prefix, suffix, new File(tempDirName), true);
    }

    public static File createTempFile(String prefix, String suffix, File tempDir) throws IOException {
        return FileKit.createTempFile(prefix, suffix, tempDir, true);
    }

    public static File createTempFile(String prefix, String suffix, String tempDirName, boolean create) throws IOException {
        return FileKit.createTempFile(prefix, suffix, new File(tempDirName), create);
    }

    public static File createTempFile(String prefix, String suffix, File tempDir, boolean create) throws IOException {
        if (StringKit.isBlank(prefix)) {
            return null;
        }
        File file = FileKit.doCreateTempFile(prefix, suffix, tempDir);
        file.delete();
        if (create) {
            file.createNewFile();
        }
        return file;
    }

    private static File doCreateTempFile(String prefix, String suffix, File dir) throws IOException {
        int exceptionsCount = 0;
        while (true) {
            try {
                return File.createTempFile(prefix, suffix, dir).getCanonicalFile();
            }
            catch (IOException e) {
                if (++exceptionsCount < 100) continue;
                throw e;
            }
            break;
        }
    }

    public static String getClassFilePath(Class<?> clazz) throws IOException {
        if (clazz == null) {
            return null;
        }
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        String filePath = null;
        try {
            filePath = URLDecoder.decode(url.getPath(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionKit.toRuntimeException(e);
        }
        File file = new File(filePath);
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String sourceFile, String destFile) throws IOException {
        File source = new File(sourceFile);
        if (source.exists()) {
            AbstractInterruptibleChannel inputChannel = null;
            AbstractInterruptibleChannel outputChannel = null;
            try {
                File dest = new File(destFile);
                inputChannel = new FileInputStream(source).getChannel();
                outputChannel = new FileOutputStream(dest).getChannel();
                ((FileChannel)outputChannel).transferFrom((ReadableByteChannel)((Object)inputChannel), 0L, ((FileChannel)inputChannel).size());
            }
            finally {
                inputChannel.close();
                outputChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDir(String oldPath, String newPath) {
        try {
            new File(newPath).mkdirs();
            File a = new File(oldPath);
            String[] file = a.list();
            File temp = null;
            for (int i = 0; i < file.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                if (temp.isFile()) {
                    AbstractInterruptibleChannel inputChannel = null;
                    AbstractInterruptibleChannel outputChannel = null;
                    try {
                        File dest = new File(newPath + SLASH + temp.getName().toString());
                        inputChannel = new FileInputStream(temp).getChannel();
                        outputChannel = new FileOutputStream(dest).getChannel();
                        ((FileChannel)outputChannel).transferFrom((ReadableByteChannel)((Object)inputChannel), 0L, ((FileChannel)inputChannel).size());
                    }
                    finally {
                        inputChannel.close();
                        outputChannel.close();
                    }
                }
                if (!temp.isDirectory()) continue;
                FileKit.copyDir(oldPath + SLASH + file[i], newPath + SLASH + file[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void moveFile(String oldPath, String newPath) throws IOException {
        FileKit.copy(oldPath, newPath);
        FileKit.delete(oldPath);
    }

    public static void moveFolder(String oldPath, String newPath) {
        FileKit.copyDir(oldPath, newPath);
        FileKit.deleteDir(oldPath);
    }

    public static class FileNameAndExtension {
        private final String fileName;
        private final String extension;

        private FileNameAndExtension(String fileName, String extension, boolean extensionToLowerCase) {
            this.fileName = fileName;
            this.extension = extensionToLowerCase ? StringKit.toLowerCase(extension) : extension;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getExtension() {
            return this.extension;
        }

        public String toString() {
            return this.extension == null ? this.fileName : this.fileName + FileKit.CURRENT_DIR + this.extension;
        }
    }
}

