/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import blade.kit.io.ByteArray;
import blade.kit.io.ByteArrayOutputStream;
import blade.kit.io.FastByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public abstract class StreamKit {
    public static void io(InputStream in, OutputStream out) throws IOException {
        StreamKit.io(in, out, -1);
    }

    public static void io(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int amount;
        if (bufferSize == -1) {
            bufferSize = 4096;
        }
        byte[] buffer = new byte[bufferSize];
        while ((amount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amount);
        }
        out.flush();
    }

    public static void io(Reader in, Writer out) throws IOException {
        StreamKit.io(in, out, -1);
    }

    public static void io(Reader in, Writer out, int bufferSize) throws IOException {
        int amount;
        if (bufferSize == -1) {
            bufferSize = 2048;
        }
        char[] buffer = new char[bufferSize];
        while ((amount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amount);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io(InputStream in, OutputStream out, boolean closeIn, boolean closeOut) throws IOException {
        try {
            StreamKit.io(in, out);
        }
        finally {
            if (closeIn) {
                StreamKit.close(in);
            }
            if (closeOut) {
                StreamKit.close(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io(Reader in, Writer out, boolean closeIn, boolean closeOut) throws IOException {
        try {
            StreamKit.io(in, out);
        }
        finally {
            if (closeIn) {
                StreamKit.close(in);
            }
            if (closeOut) {
                StreamKit.close(out);
            }
        }
    }

    public static void io(InputStream in, File dest) throws IOException {
        FileOutputStream out = new FileOutputStream(dest);
        StreamKit.io(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io(InputStream in, File dest, boolean closeIn, boolean closeOut) throws IOException {
        FileOutputStream out = new FileOutputStream(dest);
        try {
            StreamKit.io(in, out);
        }
        finally {
            if (closeIn) {
                StreamKit.close(in);
            }
            if (closeOut) {
                StreamKit.close(out);
            }
        }
    }

    public static void io(InputStream in, String dest) throws IOException {
        FileOutputStream out = new FileOutputStream(dest);
        StreamKit.io(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io(InputStream in, String dest, boolean closeIn, boolean closeOut) throws IOException {
        FileOutputStream out = new FileOutputStream(dest);
        try {
            StreamKit.io(in, out);
        }
        finally {
            if (closeIn) {
                StreamKit.close(in);
            }
            if (closeOut) {
                StreamKit.close(out);
            }
        }
    }

    public static void io(Reader in, File dest) throws IOException {
        FileWriter out = new FileWriter(dest);
        StreamKit.io(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io(Reader in, File dest, boolean closeIn, boolean closeOut) throws IOException {
        FileWriter out = new FileWriter(dest);
        try {
            StreamKit.io(in, out);
        }
        finally {
            if (closeIn) {
                StreamKit.close(in);
            }
            if (closeOut) {
                StreamKit.close(out);
            }
        }
    }

    public static void io(Reader in, String dest) throws IOException {
        FileWriter out = new FileWriter(dest);
        StreamKit.io(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io(Reader in, String dest, boolean closeIn, boolean closeOut) throws IOException {
        FileWriter out = new FileWriter(dest);
        try {
            StreamKit.io(in, out);
        }
        finally {
            if (closeIn) {
                StreamKit.close(in);
            }
            if (closeOut) {
                StreamKit.close(out);
            }
        }
    }

    public static OutputStream synchronizedOutputStream(OutputStream out) {
        return new SynchronizedOutputStream(out);
    }

    public static OutputStream synchronizedOutputStream(OutputStream out, Object lock) {
        return new SynchronizedOutputStream(out, lock);
    }

    public static String readText(InputStream in) throws IOException {
        return StreamKit.readText(in, null, -1);
    }

    public static String readText(InputStream in, String encoding) throws IOException {
        return StreamKit.readText(in, encoding, -1);
    }

    public static String readText(InputStream in, String charset, int bufferSize) throws IOException {
        InputStreamReader reader = charset == null ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return StreamKit.readText((Reader)reader, bufferSize);
    }

    public static String readText(InputStream in, String charset, boolean closeIn) throws IOException {
        InputStreamReader reader = charset == null ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return StreamKit.readText((Reader)reader, closeIn);
    }

    public static String readText(Reader in, boolean closeIn) throws IOException {
        StringWriter out = new StringWriter();
        StreamKit.io(in, out, closeIn, true);
        return out.toString();
    }

    public static String readText(Reader reader) throws IOException {
        return StreamKit.readText(reader, -1);
    }

    public static String readText(Reader reader, int bufferSize) throws IOException {
        StringWriter writer = new StringWriter();
        StreamKit.io(reader, writer, bufferSize);
        return writer.toString();
    }

    public static ByteArray readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamKit.io(in, out);
        return out.toByteArray();
    }

    public static ByteArray readBytes(InputStream in, boolean closeIn) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamKit.io(in, out, closeIn, true);
        return out.toByteArray();
    }

    public static ByteArray readBytes(File file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamKit.io((InputStream)new FileInputStream(file), out);
        return out.toByteArray();
    }

    public static ByteArray readBytes(File file, boolean closeIn) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamKit.io((InputStream)new FileInputStream(file), out, closeIn, true);
        return out.toByteArray();
    }

    public static byte[] readBytesByFast(InputStream in) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        StreamKit.io(in, out);
        return out.toByteArray();
    }

    public static byte[] readBytesByFast(InputStream in, boolean closeIn) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        StreamKit.io(in, out, closeIn, true);
        return out.toByteArray();
    }

    public static void writeText(CharSequence chars, OutputStream out, String charset, boolean closeOut) throws IOException {
        OutputStreamWriter writer = charset == null ? new OutputStreamWriter(out) : new OutputStreamWriter(out, charset);
        StreamKit.writeText(chars, writer, closeOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeText(CharSequence chars, Writer out, boolean closeOut) throws IOException {
        try {
            out.write(chars.toString());
            out.flush();
        }
        finally {
            if (closeOut) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void writeBytes(byte[] bytes, String filePath, boolean closeOut) throws IOException {
        StreamKit.writeBytes(new ByteArray(bytes), (OutputStream)new FileOutputStream(filePath), closeOut);
    }

    public static void writeBytes(byte[] bytes, File file, boolean closeOut) throws IOException {
        StreamKit.writeBytes(new ByteArray(bytes), (OutputStream)new FileOutputStream(file), closeOut);
    }

    public static void writeBytes(byte[] bytes, OutputStream out, boolean closeOut) throws IOException {
        StreamKit.writeBytes(new ByteArray(bytes), out, closeOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(ByteArray bytes, OutputStream out, boolean closeOut) throws IOException {
        try {
            out.write(bytes.getRawBytes(), bytes.getOffset(), bytes.getLength());
            out.flush();
        }
        finally {
            if (closeOut) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void close(Closeable closed) {
        if (closed != null) {
            try {
                closed.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class SynchronizedOutputStream
    extends OutputStream {
        private OutputStream out;
        private Object lock;

        SynchronizedOutputStream(OutputStream out) {
            this(out, out);
        }

        SynchronizedOutputStream(OutputStream out, Object lock) {
            this.out = out;
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int datum) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.out.write(datum);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] data) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.out.write(data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.out.write(data, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.out.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.out.close();
            }
        }
    }
}

