/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import blade.kit.StringKit;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class SystemKit {
    private static final JvmSpecInfo JVM_SPEC_INFO = new JvmSpecInfo();
    private static final JvmInfo JVM_INFO = new JvmInfo();
    private static final JavaSpecInfo JAVA_SPEC_INFO = new JavaSpecInfo();
    private static final JavaInfo JAVA_INFO = new JavaInfo();
    private static final OsInfo OS_INFO = new OsInfo();
    private static final UserInfo USER_INFO = new UserInfo();
    private static final HostInfo HOST_INFO = new HostInfo();
    private static final JavaRuntimeInfo JAVA_RUNTIME_INFO = new JavaRuntimeInfo();

    private SystemKit() {
    }

    public static final JvmSpecInfo getJvmSpecInfo() {
        return JVM_SPEC_INFO;
    }

    public static final JvmInfo getJvmInfo() {
        return JVM_INFO;
    }

    public static final JavaSpecInfo getJavaSpecInfo() {
        return JAVA_SPEC_INFO;
    }

    public static final JavaInfo getJavaInfo() {
        return JAVA_INFO;
    }

    public static final JavaRuntimeInfo getJavaRuntimeInfo() {
        return JAVA_RUNTIME_INFO;
    }

    public static final OsInfo getOsInfo() {
        return OS_INFO;
    }

    public static final UserInfo getUserInfo() {
        return USER_INFO;
    }

    public static final HostInfo getHostInfo() {
        return HOST_INFO;
    }

    public static final void dumpSystemInfo() {
        SystemKit.dumpSystemInfo(new PrintWriter(System.out));
    }

    public static final void dumpSystemInfo(PrintWriter out) {
        out.println("--------------");
        out.println(SystemKit.getJvmSpecInfo());
        out.println("--------------");
        out.println(SystemKit.getJvmInfo());
        out.println("--------------");
        out.println(SystemKit.getJavaSpecInfo());
        out.println("--------------");
        out.println(SystemKit.getJavaInfo());
        out.println("--------------");
        out.println(SystemKit.getJavaRuntimeInfo());
        out.println("--------------");
        out.println(SystemKit.getOsInfo());
        out.println("--------------");
        out.println(SystemKit.getUserInfo());
        out.println("--------------");
        out.println(SystemKit.getHostInfo());
        out.println("--------------");
        out.flush();
    }

    public static String getSystemProperty(String name, boolean quiet) {
        try {
            return System.getProperty(name);
        }
        catch (SecurityException e) {
            if (!quiet) {
                System.err.println("Caught a SecurityException reading the system property '" + name + "'; the SystemUtil property value will default to null.");
            }
            return null;
        }
    }

    private static void append(StringBuilder builder, String caption, String value) {
        builder.append(caption).append(StringKit.defaultIfNull(value, "[n/a]")).append("\n");
    }

    public static final class HostInfo {
        private final String HOST_NAME;
        private final String HOST_ADDRESS;

        private HostInfo() {
            String hostAddress;
            String hostName;
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                hostName = localhost.getHostName();
                hostAddress = localhost.getHostAddress();
            }
            catch (UnknownHostException e) {
                hostName = "localhost";
                hostAddress = "127.0.0.1";
            }
            this.HOST_NAME = hostName;
            this.HOST_ADDRESS = hostAddress;
        }

        public final String getName() {
            return this.HOST_NAME;
        }

        public final String getAddress() {
            return this.HOST_ADDRESS;
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder();
            SystemKit.append(builder, "Host Name:    ", this.getName());
            SystemKit.append(builder, "Host Address: ", this.getAddress());
            return builder.toString();
        }
    }

    public static final class UserInfo {
        private final String USER_NAME = SystemKit.getSystemProperty("user.name", false);
        private final String USER_HOME = SystemKit.getSystemProperty("user.home", false);
        private final String USER_DIR = SystemKit.getSystemProperty("user.dir", false);
        private final String USER_LANGUAGE = SystemKit.getSystemProperty("user.language", false);
        private final String USER_COUNTRY = SystemKit.getSystemProperty("user.country", false) == null ? SystemKit.getSystemProperty("user.region", false) : SystemKit.getSystemProperty("user.country", false);
        private final String JAVA_IO_TMPDIR = SystemKit.getSystemProperty("java.io.tmpdir", false);

        private UserInfo() {
        }

        public final String getName() {
            return this.USER_NAME;
        }

        public final String getHomeDir() {
            return this.USER_HOME;
        }

        public final String getCurrentDir() {
            return this.USER_DIR;
        }

        public final String getTempDir() {
            return this.JAVA_IO_TMPDIR;
        }

        public final String getLanguage() {
            return this.USER_LANGUAGE;
        }

        public final String getCountry() {
            return this.USER_COUNTRY;
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder();
            SystemKit.append(builder, "User Name:        ", this.getName());
            SystemKit.append(builder, "User Home Dir:    ", this.getHomeDir());
            SystemKit.append(builder, "User Current Dir: ", this.getCurrentDir());
            SystemKit.append(builder, "User Temp Dir:    ", this.getTempDir());
            SystemKit.append(builder, "User Language:    ", this.getLanguage());
            SystemKit.append(builder, "User Country:     ", this.getCountry());
            return builder.toString();
        }
    }

    public static final class OsInfo {
        private final String OS_VERSION = SystemKit.getSystemProperty("os.version", false);
        private final String OS_ARCH = SystemKit.getSystemProperty("os.arch", false);
        private final String OS_NAME = SystemKit.getSystemProperty("os.name", false);
        private final boolean IS_OS_AIX = this.getOSMatches("AIX");
        private final boolean IS_OS_HP_UX = this.getOSMatches("HP-UX");
        private final boolean IS_OS_IRIX = this.getOSMatches("Irix");
        private final boolean IS_OS_LINUX = this.getOSMatches("Linux") || this.getOSMatches("LINUX");
        private final boolean IS_OS_MAC = this.getOSMatches("Mac");
        private final boolean IS_OS_MAC_OSX = this.getOSMatches("Mac OS X");
        private final boolean IS_OS_OS2 = this.getOSMatches("OS/2");
        private final boolean IS_OS_SOLARIS = this.getOSMatches("Solaris");
        private final boolean IS_OS_SUN_OS = this.getOSMatches("SunOS");
        private final boolean IS_OS_WINDOWS = this.getOSMatches("Windows");
        private final boolean IS_OS_WINDOWS_2000 = this.getOSMatches("Windows", "5.0");
        private final boolean IS_OS_WINDOWS_95 = this.getOSMatches("Windows 9", "4.0");
        private final boolean IS_OS_WINDOWS_98 = this.getOSMatches("Windows 9", "4.1");
        private final boolean IS_OS_WINDOWS_ME = this.getOSMatches("Windows", "4.9");
        private final boolean IS_OS_WINDOWS_NT = this.getOSMatches("Windows NT");
        private final boolean IS_OS_WINDOWS_XP = this.getOSMatches("Windows", "5.1");
        private final String FILE_SEPARATOR = SystemKit.getSystemProperty("file.separator", false);
        private final String LINE_SEPARATOR = SystemKit.getSystemProperty("line.separator", false);
        private final String PATH_SEPARATOR = SystemKit.getSystemProperty("path.separator", false);

        private OsInfo() {
        }

        public final String getArch() {
            return this.OS_ARCH;
        }

        public final String getName() {
            return this.OS_NAME;
        }

        public final String getVersion() {
            return this.OS_VERSION;
        }

        public final boolean isAix() {
            return this.IS_OS_AIX;
        }

        public final boolean isHpUx() {
            return this.IS_OS_HP_UX;
        }

        public final boolean isIrix() {
            return this.IS_OS_IRIX;
        }

        public final boolean isLinux() {
            return this.IS_OS_LINUX;
        }

        public final boolean isMac() {
            return this.IS_OS_MAC;
        }

        public final boolean isMacOsX() {
            return this.IS_OS_MAC_OSX;
        }

        public final boolean isOs2() {
            return this.IS_OS_OS2;
        }

        public final boolean isSolaris() {
            return this.IS_OS_SOLARIS;
        }

        public final boolean isSunOS() {
            return this.IS_OS_SUN_OS;
        }

        public final boolean isWindows() {
            return this.IS_OS_WINDOWS;
        }

        public final boolean isWindows2000() {
            return this.IS_OS_WINDOWS_2000;
        }

        public final boolean isWindows95() {
            return this.IS_OS_WINDOWS_95;
        }

        public final boolean isWindows98() {
            return this.IS_OS_WINDOWS_98;
        }

        public final boolean isWindowsME() {
            return this.IS_OS_WINDOWS_ME;
        }

        public final boolean isWindowsNT() {
            return this.IS_OS_WINDOWS_NT;
        }

        public final boolean isWindowsXP() {
            return this.IS_OS_WINDOWS_XP;
        }

        private final boolean getOSMatches(String osNamePrefix) {
            if (this.OS_NAME == null) {
                return false;
            }
            return this.OS_NAME.startsWith(osNamePrefix);
        }

        private final boolean getOSMatches(String osNamePrefix, String osVersionPrefix) {
            if (this.OS_NAME == null || this.OS_VERSION == null) {
                return false;
            }
            return this.OS_NAME.startsWith(osNamePrefix) && this.OS_VERSION.startsWith(osVersionPrefix);
        }

        public final String getFileSeparator() {
            return this.FILE_SEPARATOR;
        }

        public final String getLineSeparator() {
            return this.LINE_SEPARATOR;
        }

        public final String getPathSeparator() {
            return this.PATH_SEPARATOR;
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder();
            SystemKit.append(builder, "OS Arch:        ", this.getArch());
            SystemKit.append(builder, "OS Name:        ", this.getName());
            SystemKit.append(builder, "OS Version:     ", this.getVersion());
            SystemKit.append(builder, "File Separator: ", this.getFileSeparator());
            SystemKit.append(builder, "Line Separator: ", this.getLineSeparator());
            SystemKit.append(builder, "Path Separator: ", this.getPathSeparator());
            return builder.toString();
        }
    }

    public static final class JavaRuntimeInfo {
        private final String JAVA_RUNTIME_NAME = SystemKit.getSystemProperty("java.runtime.name", false);
        private final String JAVA_RUNTIME_VERSION = SystemKit.getSystemProperty("java.runtime.version", false);
        private final String JAVA_HOME = SystemKit.getSystemProperty("java.home", false);
        private final String JAVA_EXT_DIRS = SystemKit.getSystemProperty("java.ext.dirs", false);
        private final String JAVA_ENDORSED_DIRS = SystemKit.getSystemProperty("java.endorsed.dirs", false);
        private final String JAVA_CLASS_PATH = SystemKit.getSystemProperty("java.class.path", false);
        private final String JAVA_CLASS_VERSION = SystemKit.getSystemProperty("java.class.version", false);
        private final String JAVA_LIBRARY_PATH = SystemKit.getSystemProperty("java.library.path", false);
        private final String SUN_BOOT_CLASS_PATH = SystemKit.getSystemProperty("sun.boot.class.path", false);
        private final String SUN_ARCH_DATA_MODEL = SystemKit.getSystemProperty("sun.arch.data.model", false);

        private JavaRuntimeInfo() {
        }

        public final String getSunBoothClassPath() {
            return this.SUN_BOOT_CLASS_PATH;
        }

        public final String getSunArchDataModel() {
            return this.SUN_ARCH_DATA_MODEL;
        }

        public final String getName() {
            return this.JAVA_RUNTIME_NAME;
        }

        public final String getVersion() {
            return this.JAVA_RUNTIME_VERSION;
        }

        public final String getHomeDir() {
            return this.JAVA_HOME;
        }

        public final String getExtDirs() {
            return this.JAVA_EXT_DIRS;
        }

        public final String getEndorsedDirs() {
            return this.JAVA_ENDORSED_DIRS;
        }

        public final String getClassPath() {
            return this.JAVA_CLASS_PATH;
        }

        public final String[] getClassPathArray() {
            return StringKit.split(this.getClassPath(), SystemKit.getOsInfo().getPathSeparator());
        }

        public final String getClassVersion() {
            return this.JAVA_CLASS_VERSION;
        }

        public final String getLibraryPath() {
            return this.JAVA_LIBRARY_PATH;
        }

        public final String[] getLibraryPathArray() {
            return StringKit.split(this.getLibraryPath(), SystemKit.getOsInfo().getPathSeparator());
        }

        public final String getProtocolPackages() {
            return SystemKit.getSystemProperty("java.protocol.handler.pkgs", true);
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder();
            SystemKit.append(builder, "Java Runtime Name:      ", this.getName());
            SystemKit.append(builder, "Java Runtime Version:   ", this.getVersion());
            SystemKit.append(builder, "Java Home Dir:          ", this.getHomeDir());
            SystemKit.append(builder, "Java Extension Dirs:    ", this.getExtDirs());
            SystemKit.append(builder, "Java Endorsed Dirs:     ", this.getEndorsedDirs());
            SystemKit.append(builder, "Java Class Path:        ", this.getClassPath());
            SystemKit.append(builder, "Java Class Version:     ", this.getClassVersion());
            SystemKit.append(builder, "Java Library Path:      ", this.getLibraryPath());
            SystemKit.append(builder, "Java Protocol Packages: ", this.getProtocolPackages());
            return builder.toString();
        }
    }

    public static final class JavaInfo {
        private final String JAVA_VERSION = SystemKit.getSystemProperty("java.version", false);
        private final float JAVA_VERSION_FLOAT = this.getJavaVersionAsFloat();
        private final int JAVA_VERSION_INT = this.getJavaVersionAsInt();
        private final String JAVA_VENDOR = SystemKit.getSystemProperty("java.vendor", false);
        private final String JAVA_VENDOR_URL = SystemKit.getSystemProperty("java.vendor.url", false);
        private final boolean IS_JAVA_1_1 = this.getJavaVersionMatches("1.1");
        private final boolean IS_JAVA_1_2 = this.getJavaVersionMatches("1.2");
        private final boolean IS_JAVA_1_3 = this.getJavaVersionMatches("1.3");
        private final boolean IS_JAVA_1_4 = this.getJavaVersionMatches("1.4");
        private final boolean IS_JAVA_1_5 = this.getJavaVersionMatches("1.5");
        private final boolean IS_JAVA_1_6 = this.getJavaVersionMatches("1.6");
        private final boolean IS_JAVA_1_7 = this.getJavaVersionMatches("1.7");

        private JavaInfo() {
        }

        public final String getVersion() {
            return this.JAVA_VERSION;
        }

        public final float getVersionFloat() {
            return this.JAVA_VERSION_FLOAT;
        }

        public final int getVersionInt() {
            return this.JAVA_VERSION_INT;
        }

        private final float getJavaVersionAsFloat() {
            if (this.JAVA_VERSION == null) {
                return 0.0f;
            }
            String str = this.JAVA_VERSION.substring(0, 3);
            if (this.JAVA_VERSION.length() >= 5) {
                str = str + this.JAVA_VERSION.substring(4, 5);
            }
            return Float.parseFloat(str);
        }

        private final int getJavaVersionAsInt() {
            if (this.JAVA_VERSION == null) {
                return 0;
            }
            String str = this.JAVA_VERSION.substring(0, 1);
            str = str + this.JAVA_VERSION.substring(2, 3);
            str = this.JAVA_VERSION.length() >= 5 ? str + this.JAVA_VERSION.substring(4, 5) : str + "0";
            return Integer.parseInt(str);
        }

        public final String getVendor() {
            return this.JAVA_VENDOR;
        }

        public final String getVendorURL() {
            return this.JAVA_VENDOR_URL;
        }

        public final boolean isJava11() {
            return this.IS_JAVA_1_1;
        }

        public final boolean isJava12() {
            return this.IS_JAVA_1_2;
        }

        public final boolean isJava13() {
            return this.IS_JAVA_1_3;
        }

        public final boolean isJava14() {
            return this.IS_JAVA_1_4;
        }

        public final boolean isJava15() {
            return this.IS_JAVA_1_5;
        }

        public final boolean isJava16() {
            return this.IS_JAVA_1_6;
        }

        public final boolean isJava17() {
            return this.IS_JAVA_1_7;
        }

        private final boolean getJavaVersionMatches(String versionPrefix) {
            if (this.JAVA_VERSION == null) {
                return false;
            }
            return this.JAVA_VERSION.startsWith(versionPrefix);
        }

        public final boolean isJavaVersionAtLeast(float requiredVersion) {
            return this.getVersionFloat() >= requiredVersion;
        }

        public final boolean isJavaVersionAtLeast(int requiredVersion) {
            return this.getVersionInt() >= requiredVersion;
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder();
            SystemKit.append(builder, "Java Version:    ", this.getVersion());
            SystemKit.append(builder, "Java Vendor:     ", this.getVendor());
            SystemKit.append(builder, "Java Vendor URL: ", this.getVendorURL());
            return builder.toString();
        }
    }

    public static final class JavaSpecInfo {
        private final String JAVA_SPECIFICATION_NAME = SystemKit.getSystemProperty("java.specification.name", false);
        private final String JAVA_SPECIFICATION_VERSION = SystemKit.getSystemProperty("java.specification.version", false);
        private final String JAVA_SPECIFICATION_VENDOR = SystemKit.getSystemProperty("java.specification.vendor", false);

        private JavaSpecInfo() {
        }

        public final String getName() {
            return this.JAVA_SPECIFICATION_NAME;
        }

        public final String getVersion() {
            return this.JAVA_SPECIFICATION_VERSION;
        }

        public final String getVendor() {
            return this.JAVA_SPECIFICATION_VENDOR;
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder();
            SystemKit.append(builder, "Java Spec. Name:    ", this.getName());
            SystemKit.append(builder, "Java Spec. Version: ", this.getVersion());
            SystemKit.append(builder, "Java Spec. Vendor:  ", this.getVendor());
            return builder.toString();
        }
    }

    public static final class JvmInfo {
        private final String JAVA_VM_NAME = SystemKit.getSystemProperty("java.vm.name", false);
        private final String JAVA_VM_VERSION = SystemKit.getSystemProperty("java.vm.version", false);
        private final String JAVA_VM_VENDOR = SystemKit.getSystemProperty("java.vm.vendor", false);
        private final String JAVA_VM_INFO = SystemKit.getSystemProperty("java.vm.info", false);

        private JvmInfo() {
        }

        public final String getName() {
            return this.JAVA_VM_NAME;
        }

        public final String getVersion() {
            return this.JAVA_VM_VERSION;
        }

        public final String getVendor() {
            return this.JAVA_VM_VENDOR;
        }

        public final String getInfo() {
            return this.JAVA_VM_INFO;
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder();
            SystemKit.append(builder, "JavaVM Name:    ", this.getName());
            SystemKit.append(builder, "JavaVM Version: ", this.getVersion());
            SystemKit.append(builder, "JavaVM Vendor:  ", this.getVendor());
            SystemKit.append(builder, "JavaVM Info:    ", this.getInfo());
            return builder.toString();
        }
    }

    public static final class JvmSpecInfo {
        private final String JAVA_VM_SPECIFICATION_NAME = SystemKit.getSystemProperty("java.vm.specification.name", false);
        private final String JAVA_VM_SPECIFICATION_VERSION = SystemKit.getSystemProperty("java.vm.specification.version", false);
        private final String JAVA_VM_SPECIFICATION_VENDOR = SystemKit.getSystemProperty("java.vm.specification.vendor", false);

        private JvmSpecInfo() {
        }

        public final String getName() {
            return this.JAVA_VM_SPECIFICATION_NAME;
        }

        public final String getVersion() {
            return this.JAVA_VM_SPECIFICATION_VERSION;
        }

        public final String getVendor() {
            return this.JAVA_VM_SPECIFICATION_VENDOR;
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder();
            SystemKit.append(builder, "JavaVM Spec. Name:    ", this.getName());
            SystemKit.append(builder, "JavaVM Spec. Version: ", this.getVersion());
            SystemKit.append(builder, "JavaVM Spec. Vendor:  ", this.getVendor());
            return builder.toString();
        }
    }
}

